/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.IndexReaderContext;
import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.NumericDocValues;
import guideme.internal.shaded.lucene.index.ReaderUtil;
import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.index.TermState;
import guideme.internal.shaded.lucene.index.TermStates;
import guideme.internal.shaded.lucene.index.TermsEnum;
import guideme.internal.shaded.lucene.search.CollectionStatistics;
import guideme.internal.shaded.lucene.search.ConstantScoreScorer;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.QueryVisitor;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.Scorer;
import guideme.internal.shaded.lucene.search.ScorerSupplier;
import guideme.internal.shaded.lucene.search.TermScorer;
import guideme.internal.shaded.lucene.search.TermStatistics;
import guideme.internal.shaded.lucene.search.Weight;
import guideme.internal.shaded.lucene.search.similarities.Similarity;
import guideme.internal.shaded.lucene.util.IOSupplier;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;

public class TermQuery
extends Query {
    private final Term term;
    private final TermStates perReaderTermState;

    public TermQuery(Term t) {
        this.term = Objects.requireNonNull(t);
        this.perReaderTermState = null;
    }

    public TermQuery(Term t, TermStates states) {
        assert (states != null);
        this.term = Objects.requireNonNull(t);
        this.perReaderTermState = Objects.requireNonNull(states);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        IndexReaderContext context = searcher.getTopReaderContext();
        TermStates termState = this.perReaderTermState == null || !this.perReaderTermState.wasBuiltFor(context) ? TermStates.build(searcher, this.term, scoreMode.needsScores()) : this.perReaderTermState;
        return new TermWeight(searcher, scoreMode, boost, termState);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.term.field())) {
            visitor.consumeTerms(this, this.term);
        }
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        return buffer.toString();
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.term.equals(((TermQuery)other).term);
    }

    @Override
    public int hashCode() {
        return this.classHash() ^ this.term.hashCode();
    }

    final class TermWeight
    extends Weight {
        private final Similarity similarity;
        private final Similarity.SimScorer simScorer;
        private final TermStates termStates;
        private final ScoreMode scoreMode;

        public TermWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost, TermStates termStates) throws IOException {
            TermStatistics termStats;
            CollectionStatistics collectionStats;
            super(TermQuery.this);
            if (scoreMode.needsScores() && termStates == null) {
                throw new IllegalStateException("termStates are required when scores are needed");
            }
            this.scoreMode = scoreMode;
            this.termStates = termStates;
            this.similarity = searcher.getSimilarity();
            if (scoreMode.needsScores()) {
                collectionStats = searcher.collectionStatistics(TermQuery.this.term.field());
                termStats = termStates.docFreq() > 0 ? searcher.termStatistics(TermQuery.this.term, termStates.docFreq(), termStates.totalTermFreq()) : null;
            } else {
                collectionStats = new CollectionStatistics(TermQuery.this.term.field(), 1L, 1L, 1L, 1L);
                termStats = new TermStatistics(TermQuery.this.term.bytes(), 1L, 1L);
            }
            this.simScorer = termStats == null ? null : (scoreMode.needsScores() ? this.similarity.scorer(boost, collectionStats, termStats) : new Similarity.SimScorer(this){

                @Override
                public float score(float freq, long norm) {
                    return 0.0f;
                }
            });
        }

        public String toString() {
            return "weight(" + String.valueOf(TermQuery.this) + ")";
        }

        @Override
        public ScorerSupplier scorerSupplier(final LeafReaderContext context) throws IOException {
            assert (this.termStates == null || this.termStates.wasBuiltFor(ReaderUtil.getTopLevelContext(context))) : "The top-reader used to create Weight is not the same as the current reader's top-reader (" + String.valueOf(ReaderUtil.getTopLevelContext(context));
            final IOSupplier<TermState> stateSupplier = this.termStates.get(context);
            if (stateSupplier == null) {
                return null;
            }
            return new ScorerSupplier(){
                private TermsEnum termsEnum;
                private boolean topLevelScoringClause = false;

                private TermsEnum getTermsEnum() throws IOException {
                    if (this.termsEnum == null) {
                        TermState state = (TermState)stateSupplier.get();
                        if (state == null) {
                            return null;
                        }
                        this.termsEnum = context.reader().terms(TermQuery.this.term.field()).iterator();
                        this.termsEnum.seekExact(TermQuery.this.term.bytes(), state);
                    }
                    return this.termsEnum;
                }

                @Override
                public Scorer get(long leadCost) throws IOException {
                    TermsEnum termsEnum = this.getTermsEnum();
                    if (termsEnum == null) {
                        return new ConstantScoreScorer(0.0f, TermWeight.this.scoreMode, DocIdSetIterator.empty());
                    }
                    NumericDocValues norms = null;
                    if (TermWeight.this.scoreMode.needsScores()) {
                        norms = context.reader().getNormValues(TermQuery.this.term.field());
                    }
                    if (TermWeight.this.scoreMode == ScoreMode.TOP_SCORES) {
                        return new TermScorer(termsEnum.impacts(8), TermWeight.this.simScorer, norms, this.topLevelScoringClause);
                    }
                    int flags = TermWeight.this.scoreMode.needsScores() ? 8 : 0;
                    return new TermScorer(termsEnum.postings(null, flags), TermWeight.this.simScorer, norms);
                }

                @Override
                public long cost() {
                    try {
                        TermsEnum te = this.getTermsEnum();
                        return te == null ? 0L : (long)te.docFreq();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }

                @Override
                public void setTopLevelScoringClause() throws IOException {
                    this.topLevelScoringClause = true;
                }
            };
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return true;
        }
    }
}

