/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.codecs;

import guideme.internal.shaded.lucene.codecs.DocValuesConsumer;
import guideme.internal.shaded.lucene.codecs.DocValuesProducer;
import guideme.internal.shaded.lucene.index.SegmentReadState;
import guideme.internal.shaded.lucene.index.SegmentWriteState;
import guideme.internal.shaded.lucene.util.NamedSPILoader;
import java.io.IOException;

public abstract class DocValuesFormat
implements NamedSPILoader.NamedSPI {
    private final String name;

    protected DocValuesFormat(String name) {
        NamedSPILoader.checkServiceName(name);
        this.name = name;
    }

    public abstract DocValuesConsumer fieldsConsumer(SegmentWriteState var1) throws IOException;

    public abstract DocValuesProducer fieldsProducer(SegmentReadState var1) throws IOException;

    @Override
    public final String getName() {
        return this.name;
    }

    public String toString() {
        return "DocValuesFormat(name=" + this.name + ")";
    }

    public static DocValuesFormat forName(String name) {
        return Holder.getLoader().lookup(name);
    }

    private static final class Holder {
        private static final NamedSPILoader<DocValuesFormat> LOADER = new NamedSPILoader<DocValuesFormat>(DocValuesFormat.class);

        static NamedSPILoader<DocValuesFormat> getLoader() {
            if (LOADER == null) {
                throw new IllegalStateException("You tried to lookup a DocValuesFormat by name before all formats could be initialized. This likely happens if you call DocValuesFormat#forName from a DocValuesFormat's ctor.");
            }
            return LOADER;
        }
    }
}

