/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.miscellaneous;

import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.TokenStreamToAutomaton;
import guideme.internal.shaded.lucene.analysis.tokenattributes.CharTermAttribute;
import guideme.internal.shaded.lucene.analysis.tokenattributes.OffsetAttribute;
import guideme.internal.shaded.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import guideme.internal.shaded.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import guideme.internal.shaded.lucene.util.AttributeImpl;
import guideme.internal.shaded.lucene.util.AttributeReflector;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.BytesRefBuilder;
import guideme.internal.shaded.lucene.util.CharsRefBuilder;
import guideme.internal.shaded.lucene.util.IntsRef;
import guideme.internal.shaded.lucene.util.automaton.Automaton;
import guideme.internal.shaded.lucene.util.automaton.LimitedFiniteStringsIterator;
import guideme.internal.shaded.lucene.util.automaton.Operations;
import guideme.internal.shaded.lucene.util.automaton.Transition;
import guideme.internal.shaded.lucene.util.fst.Util;
import java.io.IOException;

public final class ConcatenateGraphFilter
extends TokenStream {
    public static final Character DEFAULT_TOKEN_SEPARATOR = Character.valueOf('\u001f');
    private final BytesRefBuilderTermAttribute bytesAtt;
    private final PositionIncrementAttribute posIncrAtt;
    private final OffsetAttribute offsetAtt;
    private final TokenStream inputTokenStream;
    private final Character tokenSeparator;
    private final boolean preservePositionIncrements;
    private final int maxGraphExpansions;
    private LimitedFiniteStringsIterator finiteStrings;
    private CharTermAttribute charTermAttribute;
    private boolean wasReset;
    private int endOffset;

    @Override
    public void reset() throws IOException {
        super.reset();
        this.charTermAttribute = this.getAttribute(CharTermAttribute.class);
        assert (this.getAttribute(TermToBytesRefAttribute.class) instanceof BytesRefBuilderTermAttributeImpl);
        this.wasReset = true;
    }

    @Override
    public boolean incrementToken() throws IOException {
        IntsRef string;
        if (this.finiteStrings == null) {
            if (!this.wasReset) {
                throw new IllegalStateException("reset() missing before incrementToken");
            }
            Automaton automaton = this.toAutomaton();
            this.finiteStrings = new LimitedFiniteStringsIterator(automaton, this.maxGraphExpansions);
            this.endOffset = this.inputTokenStream.getAttribute(OffsetAttribute.class).endOffset();
        }
        if ((string = this.finiteStrings.next()) == null) {
            return false;
        }
        this.clearAttributes();
        if (this.finiteStrings.size() > 1) {
            this.posIncrAtt.setPositionIncrement(0);
        }
        this.offsetAtt.setOffset(0, this.endOffset);
        Util.toBytesRef(string, this.bytesAtt.builder());
        if (this.charTermAttribute != null) {
            this.charTermAttribute.setLength(0);
            this.charTermAttribute.append(this.bytesAtt.toUTF16());
        }
        return true;
    }

    @Override
    public void end() throws IOException {
        super.end();
        if (this.finiteStrings == null) {
            this.inputTokenStream.end();
        }
        if (this.endOffset != -1) {
            this.offsetAtt.setOffset(0, this.endOffset);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.inputTokenStream.close();
        this.finiteStrings = null;
        this.wasReset = false;
        this.endOffset = -1;
    }

    public Automaton toAutomaton() throws IOException {
        return this.toAutomaton(false);
    }

    public Automaton toAutomaton(boolean unicodeAware) throws IOException {
        TokenStreamToAutomaton tsta = this.tokenSeparator != null ? new EscapingTokenStreamToAutomaton(this.tokenSeparator.charValue()) : new TokenStreamToAutomaton();
        tsta.setPreservePositionIncrements(this.preservePositionIncrements);
        tsta.setUnicodeArcs(unicodeAware);
        Automaton automaton = tsta.toAutomaton(this.inputTokenStream);
        automaton = ConcatenateGraphFilter.replaceSep(automaton, this.tokenSeparator);
        return Operations.determinize(automaton, this.maxGraphExpansions);
    }

    private static Automaton replaceSep(Automaton a, Character tokenSeparator) {
        Automaton result = new Automaton();
        int numStates = a.getNumStates();
        for (int s = 0; s < numStates; ++s) {
            result.createState();
            result.setAccept(s, a.isAccept(s));
        }
        Transition t = new Transition();
        int[] topoSortStates = Operations.topoSortStates(a);
        for (int i = 0; i < topoSortStates.length; ++i) {
            int state = topoSortStates[topoSortStates.length - 1 - i];
            int count = a.initTransition(state, t);
            for (int j = 0; j < count; ++j) {
                a.getNextTransition(t);
                if (t.min == 31) {
                    assert (t.max == 31);
                    if (tokenSeparator != null) {
                        result.addTransition(state, t.dest, tokenSeparator.charValue());
                        continue;
                    }
                    result.addEpsilon(state, t.dest);
                    continue;
                }
                if (t.min == 30) {
                    assert (t.max == 30);
                    result.addEpsilon(state, t.dest);
                    continue;
                }
                result.addTransition(state, t.dest, t.min, t.max);
            }
        }
        result.finishState();
        return result;
    }

    public static interface BytesRefBuilderTermAttribute
    extends TermToBytesRefAttribute {
        public BytesRefBuilder builder();

        public CharSequence toUTF16();
    }

    public static final class BytesRefBuilderTermAttributeImpl
    extends AttributeImpl
    implements BytesRefBuilderTermAttribute,
    TermToBytesRefAttribute {
        private final BytesRefBuilder bytes = new BytesRefBuilder();
        private transient CharsRefBuilder charsRef;

        @Override
        public BytesRefBuilder builder() {
            return this.bytes;
        }

        @Override
        public BytesRef getBytesRef() {
            return this.bytes.get();
        }

        @Override
        public void clear() {
            this.bytes.clear();
        }

        @Override
        public void copyTo(AttributeImpl target) {
            BytesRefBuilderTermAttributeImpl other = (BytesRefBuilderTermAttributeImpl)target;
            other.bytes.copyBytes(this.bytes);
        }

        @Override
        public AttributeImpl clone() {
            BytesRefBuilderTermAttributeImpl other = new BytesRefBuilderTermAttributeImpl();
            this.copyTo(other);
            return other;
        }

        @Override
        public void reflectWith(AttributeReflector reflector) {
            reflector.reflect(TermToBytesRefAttribute.class, "bytes", this.getBytesRef());
        }

        @Override
        public CharSequence toUTF16() {
            if (this.charsRef == null) {
                this.charsRef = new CharsRefBuilder();
            }
            this.charsRef.copyUTF8Bytes(this.getBytesRef());
            return this.charsRef.get();
        }
    }

    private static final class EscapingTokenStreamToAutomaton
    extends TokenStreamToAutomaton {
        final BytesRefBuilder spare = new BytesRefBuilder();
        final byte sepLabel;

        public EscapingTokenStreamToAutomaton(int sepLabel) {
            assert (sepLabel <= 127);
            this.sepLabel = (byte)sepLabel;
        }

        @Override
        protected BytesRef changeToken(BytesRef in) {
            int upto = 0;
            for (int i = 0; i < in.length; ++i) {
                byte b = in.bytes[in.offset + i];
                if (b == this.sepLabel) {
                    this.spare.grow(upto + 2);
                    this.spare.setByteAt(upto++, this.sepLabel);
                    this.spare.setByteAt(upto++, b);
                    continue;
                }
                this.spare.grow(upto + 1);
                this.spare.setByteAt(upto++, b);
            }
            this.spare.setLength(upto);
            return this.spare.get();
        }
    }
}

