/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class GuideScrollbar
extends AbstractWidget {
    private int contentHeight;
    private int scrollAmount;
    private Double thumbHeldAt;

    public GuideScrollbar() {
        super(0, 0, 8, 0, (Component)Component.empty());
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    protected int getMaxScrollAmount() {
        return Math.max(0, this.contentHeight - (this.height - 4));
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.visible) {
            return;
        }
        int maxScrollAmount = this.getMaxScrollAmount();
        if (maxScrollAmount <= 0) {
            return;
        }
        int thumbHeight = this.getThumbHeight();
        int left = this.getX();
        int right = left + 8;
        int top = this.getY() + this.getThumbTop();
        int bottom = top + thumbHeight;
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tesselator.getBuilder();
        bufferBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        bufferBuilder.vertex((double)left, (double)bottom, 0.0).color(128, 128, 128, 255).endVertex();
        bufferBuilder.vertex((double)right, (double)bottom, 0.0).color(128, 128, 128, 255).endVertex();
        bufferBuilder.vertex((double)right, (double)top, 0.0).color(128, 128, 128, 255).endVertex();
        bufferBuilder.vertex((double)left, (double)top, 0.0).color(128, 128, 128, 255).endVertex();
        bufferBuilder.vertex((double)left, (double)(bottom - 1), 0.0).color(192, 192, 192, 255).endVertex();
        bufferBuilder.vertex((double)(right - 1), (double)(bottom - 1), 0.0).color(192, 192, 192, 255).endVertex();
        bufferBuilder.vertex((double)(right - 1), (double)top, 0.0).color(192, 192, 192, 255).endVertex();
        bufferBuilder.vertex((double)left, (double)top, 0.0).color(192, 192, 192, 255).endVertex();
        tesselator.end();
    }

    private int getThumbTop() {
        if (this.getMaxScrollAmount() == 0) {
            return 0;
        }
        return Math.max(0, this.scrollAmount * (this.height - this.getThumbHeight()) / this.getMaxScrollAmount());
    }

    private int getThumbHeight() {
        if (this.contentHeight <= 0) {
            return 0;
        }
        return Mth.clamp((int)((int)((float)(this.height * this.height) / (float)this.contentHeight)), (int)32, (int)this.height);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean thumbHit;
        if (!this.visible || button != 0) {
            return false;
        }
        int thumbTop = this.getY() + this.getThumbTop();
        int thumbBottom = thumbTop + this.getThumbHeight();
        boolean bl = thumbHit = mouseX >= (double)this.getX() && mouseX <= (double)(this.getX() + 8) && mouseY >= (double)thumbTop && mouseY < (double)thumbBottom;
        if (thumbHit) {
            this.thumbHeldAt = mouseY - (double)thumbTop;
            return true;
        }
        this.thumbHeldAt = null;
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button != 0) {
            return super.mouseReleased(mouseX, mouseY, button);
        }
        this.thumbHeldAt = null;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.visible && this.thumbHeldAt != null) {
            int thumbY = (int)Math.round(mouseY - (double)this.getY() - this.thumbHeldAt);
            int maxThumbY = this.height - this.getThumbHeight();
            int scrollAmount = (int)Math.round((double)thumbY / (double)maxThumbY * (double)this.getMaxScrollAmount());
            this.setScrollAmount(scrollAmount);
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.visible) {
            this.setScrollAmount((int)((double)this.scrollAmount - deltaY * 10.0));
            return true;
        }
        return false;
    }

    public void move(int x, int y, int height) {
        this.setX(x);
        this.setY(y);
        this.height = height;
    }

    public void setContentHeight(int contentHeight) {
        this.contentHeight = contentHeight;
        if (this.scrollAmount > this.getMaxScrollAmount()) {
            this.scrollAmount = this.getMaxScrollAmount();
        }
    }

    public int getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(int scrollAmount) {
        this.scrollAmount = Mth.clamp((int)scrollAmount, (int)0, (int)this.getMaxScrollAmount());
    }
}

