/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.item;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import guideme.internal.GuideRegistry;
import guideme.internal.MutableGuide;
import guideme.internal.item.GuideItem;
import guideme.internal.item.GuideItemDispatchModel;
import java.util.function.Function;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.Nullable;

public class GuideItemDispatchUnbakedModel
implements IUnbakedGeometry<GuideItemDispatchUnbakedModel> {
    public BakedModel bake(IGeometryBakingContext geometryBakingContext, final ModelBaker modelBaker, final Function<Material, TextureAtlasSprite> sprites, final ModelState modelState, ItemOverrides itemOverrides, final ResourceLocation modelLocation) {
        final BakedModel baseModel = modelBaker.bake(GuideItem.BASE_MODEL_ID, modelState, sprites);
        class Loader
        extends CacheLoader<ResourceLocation, BakedModel> {
            Loader() {
            }

            public BakedModel load(ResourceLocation modelId) {
                UnbakedModel model = modelBaker.getModel(modelId);
                model.resolveParents(arg_0 -> ((ModelBaker)modelBaker).getModel(arg_0));
                return model.bake(modelBaker, sprites, modelState, modelLocation);
            }
        }
        final LoadingCache modelCache = CacheBuilder.newBuilder().build((CacheLoader)new Loader());
        ItemOverrides overrides = new ItemOverrides(this){

            @Nullable
            public BakedModel resolve(BakedModel model, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
                MutableGuide guide;
                ResourceLocation guideId = GuideItem.getGuideId(stack);
                if (guideId != null && (guide = GuideRegistry.getById(guideId)) != null && guide.getItemSettings().itemModel().isPresent()) {
                    return (BakedModel)modelCache.getUnchecked((Object)guide.getItemSettings().itemModel().get());
                }
                return baseModel;
            }
        };
        return new GuideItemDispatchModel(baseModel, overrides);
    }
}

