/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal;

import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import guideme.GuidePageChange;
import guideme.compiler.PageCompiler;
import guideme.compiler.ParsedGuidePage;
import guideme.internal.shaded.methvin.watcher.DirectoryChangeEvent;
import guideme.internal.shaded.methvin.watcher.DirectoryChangeListener;
import guideme.internal.shaded.methvin.watcher.DirectoryWatcher;
import guideme.internal.util.LangUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GuideSourceWatcher
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(GuideSourceWatcher.class);
    private final String defaultLanguage;
    private final String namespace;
    private final String sourcePackId;
    private final Path sourceFolder;
    @Nullable
    private final DirectoryWatcher sourceWatcher;
    private final Map<ResourceLocation, ParsedGuidePage> changedPages = new HashMap<ResourceLocation, ParsedGuidePage>();
    private final Set<ResourceLocation> deletedPages = new HashSet<ResourceLocation>();
    private final ExecutorService watchExecutor;

    public GuideSourceWatcher(String namespace, String defaultLanguage, Path sourceFolder) {
        DirectoryWatcher watcher;
        this.namespace = namespace;
        this.sourcePackId = ModList.get().isLoaded(namespace) ? "mod:" + namespace : namespace;
        this.defaultLanguage = defaultLanguage;
        this.sourceFolder = sourceFolder;
        if (!Files.isDirectory(sourceFolder, new LinkOption[0])) {
            throw new RuntimeException("Cannot find the specified folder with guidebook sources: " + String.valueOf(sourceFolder));
        }
        LOG.info("Watching guidebook sources in {}", (Object)sourceFolder);
        this.watchExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("GuideMELiveReloadWatcher%d").build());
        try {
            watcher = DirectoryWatcher.builder().path(sourceFolder).fileHashing(false).listener(new Listener()).build();
        }
        catch (IOException e) {
            LOG.error("Failed to watch for changes in the guidebook sources at {}", (Object)sourceFolder, (Object)e);
            watcher = null;
        }
        this.sourceWatcher = watcher;
        if (this.sourceWatcher != null) {
            this.sourceWatcher.watchAsync(this.watchExecutor);
        }
    }

    public List<ParsedGuidePage> loadAll(String defaultLanguage) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        String currentLanguage = LangUtil.getCurrentLanguage();
        Set<String> validLanguages = LangUtil.getValidLanguages();
        final HashMap pagesToLoad = new HashMap();
        try {
            Files.walkFileTree(this.sourceFolder, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    ResourceLocation pageId = GuideSourceWatcher.this.getPageId(file);
                    if (pageId != null) {
                        pagesToLoad.put(pageId, file);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    LOG.error("Failed to list page {}", (Object)file, (Object)exc);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    if (exc != null) {
                        LOG.error("Failed to list all pages in {}", (Object)dir, (Object)exc);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            LOG.error("Failed to list all pages in {}", (Object)this.sourceFolder, (Object)e);
        }
        LOG.info("Loading {} guidebook pages", (Object)pagesToLoad.size());
        List<ParsedGuidePage> loadedPages = pagesToLoad.entrySet().stream().map(entry -> {
            ParsedGuidePage parsedGuidePage;
            block11: {
                String language;
                ResourceLocation pageId = (ResourceLocation)entry.getKey();
                Path path = (Path)entry.getValue();
                if (LangUtil.getLangFromPageId(pageId, validLanguages) != null) {
                    return null;
                }
                Path translatedPage = (Path)pagesToLoad.get(LangUtil.getTranslatedAsset(pageId, currentLanguage));
                if (translatedPage != null) {
                    language = currentLanguage;
                    path = translatedPage;
                } else {
                    language = defaultLanguage;
                }
                InputStream in = Files.newInputStream(path, new OpenOption[0]);
                try {
                    parsedGuidePage = PageCompiler.parse(this.sourcePackId, language, pageId, in);
                    if (in == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOG.error("Failed to reload guidebook page {}", (Object)path, (Object)e);
                        return null;
                    }
                }
                in.close();
            }
            return parsedGuidePage;
        }).filter(Objects::nonNull).toList();
        LOG.info("Loaded {} pages from {} in {}", new Object[]{loadedPages.size(), this.sourceFolder, stopwatch});
        return loadedPages;
    }

    public synchronized void clearChanges() {
        this.changedPages.clear();
        this.deletedPages.clear();
    }

    public synchronized List<GuidePageChange> takeChanges(String currentLanguage) {
        if (this.deletedPages.isEmpty() && this.changedPages.isEmpty()) {
            return List.of();
        }
        ArrayList<GuidePageChange> changes = new ArrayList<GuidePageChange>();
        for (ResourceLocation deletedPage : this.deletedPages) {
            changes.add(new GuidePageChange(deletedPage, null, null));
        }
        this.deletedPages.clear();
        for (ParsedGuidePage changedPage : this.changedPages.values()) {
            changes.add(new GuidePageChange(changedPage.getId(), null, changedPage));
        }
        this.changedPages.clear();
        return changes;
    }

    @Override
    public synchronized void close() {
        this.changedPages.clear();
        this.deletedPages.clear();
        this.watchExecutor.shutdown();
        if (this.sourceWatcher != null) {
            try {
                this.sourceWatcher.close();
            }
            catch (IOException e) {
                LOG.error("Failed to close fileystem watcher for {}", (Object)this.sourceFolder);
            }
        }
    }

    private synchronized void pageChanged(Path path) {
        ResourceLocation pageId = this.getPageId(path);
        if (pageId == null) {
            return;
        }
        Set<String> validLanguages = LangUtil.getValidLanguages();
        String language = Objects.requireNonNullElse(LangUtil.getLangFromPageId(pageId, validLanguages), this.defaultLanguage);
        this.deletedPages.remove(pageId);
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            ParsedGuidePage page = PageCompiler.parse(this.sourcePackId, language, pageId, in);
            this.changedPages.put(pageId, page);
        }
        catch (Exception e) {
            LOG.error("Failed to reload guidebook page {}", (Object)path, (Object)e);
        }
    }

    private synchronized void pageDeleted(Path path) {
        ResourceLocation pageId = this.getPageId(path);
        if (pageId == null) {
            return;
        }
        this.changedPages.remove(pageId);
        this.deletedPages.add(pageId);
    }

    @Nullable
    private ResourceLocation getPageId(Path path) {
        Path relativePath = this.sourceFolder.relativize(path);
        String relativePathStr = relativePath.toString().replace('\\', '/');
        if (!relativePathStr.endsWith(".md")) {
            return null;
        }
        if (!ResourceLocation.isValidPath((String)relativePathStr)) {
            return null;
        }
        return new ResourceLocation(this.namespace, relativePathStr);
    }

    private class Listener
    implements DirectoryChangeListener {
        private Listener() {
        }

        @Override
        public void onEvent(DirectoryChangeEvent event) {
            if (event.isDirectory()) {
                return;
            }
            switch (event.eventType()) {
                case CREATE: 
                case MODIFY: {
                    GuideSourceWatcher.this.pageChanged(event.path());
                    break;
                }
                case DELETE: {
                    GuideSourceWatcher.this.pageDeleted(event.path());
                }
            }
        }

        @Override
        public boolean isWatching() {
            return GuideSourceWatcher.this.sourceWatcher != null && !GuideSourceWatcher.this.sourceWatcher.isClosed();
        }

        @Override
        public void onException(Exception e) {
            LOG.error("Failed watching for changes", (Throwable)e);
        }
    }
}

