/*
 * Decompiled with CFR 0.152.
 */
package guideme.scene.export;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import guideme.scene.export.RenderTypeIntrospection;
import guideme.scene.export.SpriteFinder;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import org.joml.Vector2f;
import org.joml.Vector4i;

record Mesh(BufferBuilder.DrawState drawState, ByteBuffer vertexBuffer, ByteBuffer indexBuffer, RenderType renderType) {
    public Stream<TextureAtlasSprite> getSprites() {
        TextureManager textureManager = Minecraft.getInstance().getTextureManager();
        if (this.drawState.mode() != VertexFormat.Mode.QUADS) {
            return Stream.of(new TextureAtlasSprite[0]);
        }
        List<RenderTypeIntrospection.Sampler> samplers = RenderTypeIntrospection.getSamplers(this.renderType);
        if (samplers.isEmpty()) {
            return Stream.of(new TextureAtlasSprite[0]);
        }
        AbstractTexture texture = textureManager.getTexture(samplers.get(0).texture());
        if (!(texture instanceof TextureAtlas)) {
            return Stream.of(new TextureAtlasSprite[0]);
        }
        TextureAtlas textureAtlas = (TextureAtlas)texture;
        int offset = 0;
        VertexFormatElement uvElement = null;
        for (VertexFormatElement element : this.renderType.format().getElements()) {
            if (element.getUsage() == VertexFormatElement.Usage.UV && element.getIndex() == 0 && element.getCount() == 2) {
                uvElement = element;
                break;
            }
            offset += element.getByteSize();
        }
        if (uvElement == null) {
            return Stream.of(new TextureAtlasSprite[0]);
        }
        IntFunction<Vector2f> uvSupplier = this.getUvSupplier(offset, uvElement);
        SpriteFinder spriteFinder = new SpriteFinder(textureAtlas.texturesByName, textureAtlas);
        return this.streamQuadMidpoints(uvSupplier).map(uvPos -> spriteFinder.find(uvPos.x, uvPos.y)).filter(Objects::nonNull);
    }

    private Stream<Vector2f> streamQuadMidpoints(IntFunction<Vector2f> uvSupplier) {
        return this.streamIndices().map(indices -> this.getQuadMidpoint(indices.x, indices.y, indices.z, indices.w, uvSupplier));
    }

    private Stream<Vector4i> streamIndices() {
        if (this.drawState.sequentialIndex()) {
            int quadCount = this.drawState.vertexCount() / 4;
            return IntStream.range(0, quadCount).mapToObj(quadIdx -> new Vector4i(quadIdx * 4, quadIdx * 4 + 1, quadIdx * 4 + 2, quadIdx * 4 + 3));
        }
        if (this.drawState.indexType() == VertexFormat.IndexType.INT) {
            int quadCount = this.drawState.indexCount() / 4;
            return IntStream.range(0, quadCount).mapToObj(quadIdx -> new Vector4i(this.indexBuffer.getInt(quadIdx * 4 * 4), this.indexBuffer.getInt(quadIdx * 4 * 4 + 4), this.indexBuffer.getInt(quadIdx * 4 * 4 + 8), this.indexBuffer.getInt(quadIdx * 4 * 4 + 12)));
        }
        if (this.drawState.indexType() == VertexFormat.IndexType.SHORT) {
            int quadCount = this.drawState.indexCount() / 4;
            return IntStream.range(0, quadCount).mapToObj(quadIdx -> new Vector4i((int)this.indexBuffer.getShort(quadIdx * 4 * 2), (int)this.indexBuffer.getShort(quadIdx * 4 * 2 + 2), (int)this.indexBuffer.getShort(quadIdx * 4 * 2 + 4), (int)this.indexBuffer.getShort(quadIdx * 4 * 2 + 6)));
        }
        throw new IllegalArgumentException("Unsupported index type: " + String.valueOf(this.drawState.indexType()));
    }

    private IntFunction<Vector2f> getUvSupplier(int offset, VertexFormatElement uvElement) {
        return idx -> this.getUV(idx, offset, uvElement);
    }

    private Vector2f getQuadMidpoint(int i1, int i2, int i3, int i4, IntFunction<Vector2f> uvSupplier) {
        Vector2f uv1 = uvSupplier.apply(i1);
        Vector2f uv2 = uvSupplier.apply(i2);
        Vector2f uv3 = uvSupplier.apply(i3);
        Vector2f uv4 = uvSupplier.apply(i4);
        float avgX = (uv1.x + uv2.x + uv3.x + uv4.x) / 4.0f;
        float avgY = (uv1.y + uv2.y + uv3.y + uv4.y) / 4.0f;
        return new Vector2f(avgX, avgY);
    }

    private Vector2f getUV(int index, int offset, VertexFormatElement uvElement) {
        int stride = this.drawState.format().getVertexSize();
        int dataStart = index * stride + offset;
        return new Vector2f(this.readFloat(uvElement.getType(), dataStart), this.readFloat(uvElement.getType(), dataStart + uvElement.getType().getSize()));
    }

    private float readFloat(VertexFormatElement.Type type, int offset) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case VertexFormatElement.Type.FLOAT -> this.vertexBuffer.getFloat(offset);
            case VertexFormatElement.Type.UBYTE -> this.vertexBuffer.get(offset) & 0xFF;
            case VertexFormatElement.Type.BYTE -> this.vertexBuffer.get(offset);
            case VertexFormatElement.Type.USHORT -> this.vertexBuffer.getShort(offset) & 0xFFFF;
            case VertexFormatElement.Type.SHORT -> this.vertexBuffer.getShort(offset);
            case VertexFormatElement.Type.UINT, VertexFormatElement.Type.INT -> this.vertexBuffer.getInt(offset);
        };
    }
}

