/*
 * Decompiled with CFR 0.152.
 */
package guideme.scene.export;

import com.mojang.blaze3d.platform.NativeImage;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.util.FastColor;

final class InterpolatedSpriteBuilder {
    public static InterpolatedResult interpolate(NativeImage frameSheet, int frameWidth, int frameHeight, int frameRowCount, List<SpriteContents.FrameInfo> frames) {
        InterpolatedFrame interpFrame;
        ArrayList<InterpolatedFrame> interpFrames = new ArrayList<InterpolatedFrame>();
        IntArrayList interpolated = new IntArrayList();
        for (int i = 0; i < frames.size(); ++i) {
            SpriteContents.FrameInfo frame = frames.get(i);
            SpriteContents.FrameInfo nextFrame = frames.get((i + 1) % frames.size());
            for (int j = 0; j < frame.time; ++j) {
                float f = (float)j / (float)frame.time;
                interpFrame = new InterpolatedFrame(frame.index, nextFrame.index, f);
                int newIndex = interpFrames.indexOf(interpFrame);
                if (newIndex != -1) {
                    interpolated.add(newIndex);
                    continue;
                }
                interpolated.add(interpFrames.size());
                interpFrames.add(interpFrame);
            }
        }
        int height = interpFrames.size() * frameHeight;
        NativeImage nativeImage = new NativeImage(frameSheet.format(), frameWidth, height, false);
        for (int i = 0; i < interpFrames.size(); ++i) {
            int destX = 0;
            int destY = i * frameHeight;
            interpFrame = (InterpolatedFrame)interpFrames.get(i);
            int srcIndexA = interpFrame.aIndex;
            int srcIndexB = interpFrame.bIndex;
            int srcX = srcIndexA % frameRowCount * frameWidth;
            int srcY = srcIndexA / frameRowCount * frameHeight;
            frameSheet.copyRect(nativeImage, srcX, srcY, destX, destY, frameWidth, frameHeight, false, false);
            if (srcIndexA == srcIndexB) continue;
            InterpolatedSpriteBuilder.blend(frameSheet, srcIndexB % frameRowCount * frameWidth, srcIndexB / frameRowCount * frameHeight, nativeImage, destX, destY, frameWidth, frameHeight, interpFrame.f);
        }
        return new InterpolatedResult(nativeImage, interpolated.toIntArray(), interpFrames.size(), 1);
    }

    private static void blend(NativeImage source, int srcX, int srcY, NativeImage dest, int destX, int destY, int frameWidth, int frameHeight, float alpha) {
        for (int y = 0; y < frameHeight; ++y) {
            for (int x = 0; x < frameWidth; ++x) {
                int srcColor = source.getPixelRGBA(srcX + x, srcY + y);
                int destColor = dest.getPixelRGBA(destX + x, destY + y);
                dest.setPixelRGBA(destX + x, destY + y, FastColor.ARGB32.lerp((float)alpha, (int)destColor, (int)srcColor));
            }
        }
    }

    static final class InterpolatedFrame
    extends Record {
        private final int aIndex;
        private final int bIndex;
        private final float f;

        InterpolatedFrame(int aIndex, int bIndex, float f) {
            if (Math.abs(f) < 0.01f) {
                f = 0.0f;
                bIndex = aIndex;
            } else if (Math.abs(1.0f - f) < 0.01f) {
                f = 0.0f;
                aIndex = bIndex;
            }
            if (bIndex < aIndex) {
                this.aIndex = bIndex;
                this.bIndex = aIndex;
                this.f = 1.0f - f;
            } else {
                this.aIndex = aIndex;
                this.bIndex = bIndex;
                this.f = f;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InterpolatedFrame that = (InterpolatedFrame)o;
            return this.aIndex == that.aIndex && this.bIndex == that.bIndex && Math.abs(this.f - that.f) < 0.01f;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.aIndex, this.bIndex, Float.valueOf(this.f));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{InterpolatedFrame.class, "aIndex;bIndex;f", "aIndex", "bIndex", "f"}, this);
        }
    }

    record InterpolatedResult(NativeImage frames, int[] indices, int frameCount, int frameRowSize) {
    }
}

