/*
 * Decompiled with CFR 0.152.
 */
package guideme.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import guideme.color.ColorValue;
import guideme.color.LightDarkMode;
import guideme.document.LytRect;
import guideme.internal.GuideMEClient;
import guideme.render.RenderContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public final class SimpleRenderContext
implements RenderContext {
    private final List<LytRect> viewportStack = new ArrayList<LytRect>();
    private final GuiGraphics guiGraphics;
    private final LightDarkMode lightDarkMode;

    public SimpleRenderContext(LytRect viewport, GuiGraphics guiGraphics, LightDarkMode lightDarkMode) {
        this.viewportStack.add(viewport);
        this.guiGraphics = guiGraphics;
        this.lightDarkMode = lightDarkMode;
    }

    public SimpleRenderContext(LytRect viewport, GuiGraphics guiGraphics) {
        this(viewport, guiGraphics, GuideMEClient.currentLightDarkMode());
    }

    public SimpleRenderContext(GuiGraphics guiGraphics) {
        this(SimpleRenderContext.getDefaultViewport(), guiGraphics, GuideMEClient.currentLightDarkMode());
    }

    private static LytRect getDefaultViewport() {
        int width = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        int height = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        return new LytRect(0, 0, width, height);
    }

    @Override
    public int resolveColor(ColorValue ref) {
        return ref.resolve(this.lightDarkMode);
    }

    @Override
    public void fillRect(LytRect rect, ColorValue topLeft, ColorValue topRight, ColorValue bottomRight, ColorValue bottomLeft) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder builder = tesselator.getBuilder();
        builder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        Matrix4f matrix = this.poseStack().last().pose();
        boolean z = false;
        builder.vertex(matrix, (float)rect.right(), (float)rect.y(), 0.0f).color(this.resolveColor(topRight)).endVertex();
        builder.vertex(matrix, (float)rect.x(), (float)rect.y(), 0.0f).color(this.resolveColor(topLeft)).endVertex();
        builder.vertex(matrix, (float)rect.x(), (float)rect.bottom(), 0.0f).color(this.resolveColor(bottomLeft)).endVertex();
        builder.vertex(matrix, (float)rect.right(), (float)rect.bottom(), 0.0f).color(this.resolveColor(bottomRight)).endVertex();
        tesselator.end();
        RenderSystem.disableBlend();
    }

    @Override
    public void fillTexturedRect(LytRect rect, AbstractTexture texture, ColorValue topLeft, ColorValue topRight, ColorValue bottomRight, ColorValue bottomLeft, float u0, float v0, float u1, float v1) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture((int)0, (int)texture.getId());
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder builder = tesselator.getBuilder();
        builder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        Matrix4f matrix = this.poseStack().last().pose();
        boolean z = false;
        builder.vertex(matrix, (float)rect.right(), (float)rect.y(), 0.0f).uv(u1, v0).color(this.resolveColor(topRight)).endVertex();
        builder.vertex(matrix, (float)rect.x(), (float)rect.y(), 0.0f).uv(u0, v0).color(this.resolveColor(topLeft)).endVertex();
        builder.vertex(matrix, (float)rect.x(), (float)rect.bottom(), 0.0f).uv(u0, v1).color(this.resolveColor(bottomLeft)).endVertex();
        builder.vertex(matrix, (float)rect.right(), (float)rect.bottom(), 0.0f).uv(u1, v1).color(this.resolveColor(bottomRight)).endVertex();
        tesselator.end();
        RenderSystem.disableBlend();
    }

    @Override
    public void fillTriangle(Vec2 p1, Vec2 p2, Vec2 p3, ColorValue color) {
        int resolvedColor = this.resolveColor(color);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder builder = tesselator.getBuilder();
        builder.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
        Matrix4f matrix = this.poseStack().last().pose();
        boolean z = false;
        builder.vertex(matrix, p1.x, p1.y, 0.0f).color(resolvedColor).endVertex();
        builder.vertex(matrix, p2.x, p2.y, 0.0f).color(resolvedColor).endVertex();
        builder.vertex(matrix, p3.x, p3.y, 0.0f).color(resolvedColor).endVertex();
        tesselator.end();
        RenderSystem.disableBlend();
    }

    @Override
    public void renderItem(ItemStack stack, int x, int y, int z, float width, float height) {
        Minecraft mc = Minecraft.getInstance();
        PoseStack pose = this.poseStack();
        pose.pushPose();
        pose.translate((float)x, (float)y, (float)(z + 1));
        pose.last().pose().scale(width / 16.0f, height / 16.0f, Math.max(width / 16.0f, height / 16.0f));
        this.guiGraphics().renderItem(stack, 0, 0);
        this.guiGraphics().renderItemDecorations(mc.font, stack, 0, 0);
        pose.popPose();
    }

    @Override
    public void pushScissor(LytRect bounds) {
        LytRect rootBounds = bounds.transform(this.poseStack().last().pose());
        this.viewportStack.add(rootBounds);
        RenderContext.super.pushScissor(bounds);
    }

    @Override
    public void popScissor() {
        if (this.viewportStack.size() <= 1) {
            throw new IllegalStateException("There is no active scissor rectangle.");
        }
        this.viewportStack.remove(this.viewportStack.size() - 1);
        RenderContext.super.popScissor();
    }

    @Override
    public LytRect viewport() {
        LytRect viewport = this.viewportStack.get(this.viewportStack.size() - 1);
        Matrix4f pose = new Matrix4f((Matrix4fc)this.guiGraphics().pose().last().pose());
        pose.invert();
        LytRect vp = viewport.transform(pose);
        return vp;
    }

    @Override
    public GuiGraphics guiGraphics() {
        return this.guiGraphics;
    }

    @Override
    public LightDarkMode lightDarkMode() {
        return this.lightDarkMode;
    }
}

