/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.index.DirectoryReader;
import guideme.internal.shaded.lucene.index.IndexCommit;
import guideme.internal.shaded.lucene.index.IndexReader;
import guideme.internal.shaded.lucene.index.IndexWriter;
import guideme.internal.shaded.lucene.index.LeafReader;
import guideme.internal.shaded.lucene.index.SegmentCommitInfo;
import guideme.internal.shaded.lucene.index.SegmentInfos;
import guideme.internal.shaded.lucene.index.SegmentReader;
import guideme.internal.shaded.lucene.store.AlreadyClosedException;
import guideme.internal.shaded.lucene.store.Directory;
import guideme.internal.shaded.lucene.store.IOContext;
import guideme.internal.shaded.lucene.util.IOFunction;
import guideme.internal.shaded.lucene.util.IOUtils;
import guideme.internal.shaded.lucene.util.Version;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public final class StandardDirectoryReader
extends DirectoryReader {
    final IndexWriter writer;
    final SegmentInfos segmentInfos;
    private final boolean applyAllDeletes;
    private final boolean writeAllDeletes;
    private final Set<IndexReader.ClosedListener> readerClosedListeners = new CopyOnWriteArraySet<IndexReader.ClosedListener>();
    private final IndexReader.CacheHelper cacheHelper = new IndexReader.CacheHelper(){
        private final IndexReader.CacheKey cacheKey = new IndexReader.CacheKey();

        @Override
        public IndexReader.CacheKey getKey() {
            return this.cacheKey;
        }

        @Override
        public void addClosedListener(IndexReader.ClosedListener listener) {
            StandardDirectoryReader.this.ensureOpen();
            StandardDirectoryReader.this.readerClosedListeners.add(listener);
        }
    };

    StandardDirectoryReader(Directory directory, LeafReader[] readers, IndexWriter writer, SegmentInfos sis, Comparator<LeafReader> leafSorter, boolean applyAllDeletes, boolean writeAllDeletes) throws IOException {
        super(directory, readers, leafSorter);
        this.writer = writer;
        this.segmentInfos = sis;
        this.applyAllDeletes = applyAllDeletes;
        this.writeAllDeletes = writeAllDeletes;
    }

    static DirectoryReader open(Directory directory, IndexCommit commit, Comparator<LeafReader> leafSorter) throws IOException {
        return StandardDirectoryReader.open(directory, Version.MIN_SUPPORTED_MAJOR, commit, leafSorter);
    }

    static DirectoryReader open(Directory directory, final int minSupportedMajorVersion, IndexCommit commit, final Comparator<LeafReader> leafSorter) throws IOException {
        return (DirectoryReader)new SegmentInfos.FindSegmentsFile<DirectoryReader>(directory){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected DirectoryReader doBody(String segmentFileName) throws IOException {
                if (minSupportedMajorVersion > Version.LATEST.major || minSupportedMajorVersion < 0) {
                    throw new IllegalArgumentException("minSupportedMajorVersion must be positive and <= " + Version.LATEST.major + " but was: " + minSupportedMajorVersion);
                }
                SegmentInfos sis = SegmentInfos.readCommit(this.directory, segmentFileName, minSupportedMajorVersion);
                Closeable[] readers = new SegmentReader[sis.size()];
                boolean success = false;
                try {
                    for (int i = sis.size() - 1; i >= 0; --i) {
                        readers[i] = new SegmentReader(sis.info(i), sis.getIndexCreatedVersionMajor(), IOContext.DEFAULT);
                    }
                    StandardDirectoryReader reader = new StandardDirectoryReader(this.directory, (LeafReader[])readers, null, sis, leafSorter, false, false);
                    success = true;
                    StandardDirectoryReader standardDirectoryReader = reader;
                    return standardDirectoryReader;
                }
                finally {
                    if (!success) {
                        IOUtils.closeWhileHandlingException(readers);
                    }
                }
            }
        }.run(commit);
    }

    static StandardDirectoryReader open(IndexWriter writer, IOFunction<SegmentCommitInfo, SegmentReader> readerFunction, SegmentInfos infos, boolean applyAllDeletes, boolean writeAllDeletes) throws IOException {
        int numSegments = infos.size();
        ArrayList<SegmentReader> readers = new ArrayList<SegmentReader>(numSegments);
        Directory dir = writer.getDirectory();
        SegmentInfos segmentInfos = infos.clone();
        int infosUpto = 0;
        try {
            for (int i = 0; i < numSegments; ++i) {
                SegmentCommitInfo info = infos.info(i);
                assert (info.info.dir == dir);
                SegmentReader reader = readerFunction.apply(info);
                if (reader.numDocs() > 0 || writer.getConfig().mergePolicy.keepFullyDeletedSegment(() -> reader)) {
                    readers.add(reader);
                    ++infosUpto;
                    continue;
                }
                reader.decRef();
                segmentInfos.remove(infosUpto);
            }
            writer.incRefDeleter(segmentInfos);
            StandardDirectoryReader result = new StandardDirectoryReader(dir, readers.toArray(new SegmentReader[readers.size()]), writer, segmentInfos, writer.getConfig().getLeafSorter(), applyAllDeletes, writeAllDeletes);
            return result;
        }
        catch (Throwable t) {
            try {
                IOUtils.applyToAll(readers, IndexReader::decRef);
            }
            catch (Throwable t1) {
                t.addSuppressed(t1);
            }
            throw t;
        }
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName());
        buffer.append('(');
        String segmentsFile = this.segmentInfos.getSegmentsFileName();
        if (segmentsFile != null) {
            buffer.append(segmentsFile).append(":").append(this.segmentInfos.getVersion());
        }
        if (this.writer != null) {
            buffer.append(":nrt");
        }
        for (LeafReader r : this.getSequentialSubReaders()) {
            buffer.append(' ');
            buffer.append(r);
        }
        buffer.append(')');
        return buffer.toString();
    }

    public long getVersion() {
        this.ensureOpen();
        return this.segmentInfos.getVersion();
    }

    public SegmentInfos getSegmentInfos() {
        return this.segmentInfos;
    }

    @Override
    protected void doClose() throws IOException {
        Closeable decRefDeleter;
        try (Closeable finalizer = decRefDeleter = () -> {
            if (this.writer != null) {
                try {
                    this.writer.decRefDeleter(this.segmentInfos);
                }
                catch (AlreadyClosedException alreadyClosedException) {
                    // empty catch block
                }
            }
        };){
            List sequentialSubReaders = this.getSequentialSubReaders();
            IOUtils.applyToAll(sequentialSubReaders, IndexReader::decRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void notifyReaderClosedListeners() throws IOException {
        Set<IndexReader.ClosedListener> set = this.readerClosedListeners;
        synchronized (set) {
            IOUtils.applyToAll(this.readerClosedListeners, l -> l.onClose(this.cacheHelper.getKey()));
        }
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.cacheHelper;
    }
}

