/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.codecs.Codec;
import guideme.internal.shaded.lucene.codecs.StoredFieldsFormat;
import guideme.internal.shaded.lucene.codecs.StoredFieldsReader;
import guideme.internal.shaded.lucene.codecs.StoredFieldsWriter;
import guideme.internal.shaded.lucene.codecs.compressing.CompressionMode;
import guideme.internal.shaded.lucene.codecs.compressing.Compressor;
import guideme.internal.shaded.lucene.codecs.compressing.Decompressor;
import guideme.internal.shaded.lucene.codecs.lucene90.compressing.Lucene90CompressingStoredFieldsFormat;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.SegmentInfo;
import guideme.internal.shaded.lucene.index.SegmentWriteState;
import guideme.internal.shaded.lucene.index.Sorter;
import guideme.internal.shaded.lucene.index.StoredFieldVisitor;
import guideme.internal.shaded.lucene.index.StoredFieldsConsumer;
import guideme.internal.shaded.lucene.index.TrackingTmpOutputDirectoryWrapper;
import guideme.internal.shaded.lucene.store.ByteBuffersDataInput;
import guideme.internal.shaded.lucene.store.DataInput;
import guideme.internal.shaded.lucene.store.DataOutput;
import guideme.internal.shaded.lucene.store.Directory;
import guideme.internal.shaded.lucene.store.IOContext;
import guideme.internal.shaded.lucene.util.ArrayUtil;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.IOUtils;
import java.io.IOException;
import java.util.Objects;

final class SortingStoredFieldsConsumer
extends StoredFieldsConsumer {
    static final CompressionMode NO_COMPRESSION = new CompressionMode(){

        @Override
        public Compressor newCompressor() {
            return new Compressor(this){

                @Override
                public void close() throws IOException {
                }

                @Override
                public void compress(ByteBuffersDataInput buffersInput, DataOutput out) throws IOException {
                    out.copyBytes(buffersInput, buffersInput.length());
                }
            };
        }

        @Override
        public Decompressor newDecompressor() {
            return new Decompressor(this){

                @Override
                public void decompress(DataInput in, int originalLength, int offset, int length, BytesRef bytes) throws IOException {
                    bytes.bytes = ArrayUtil.growNoCopy(bytes.bytes, length);
                    in.skipBytes(offset);
                    in.readBytes(bytes.bytes, 0, length);
                    bytes.offset = 0;
                    bytes.length = length;
                }

                @Override
                public Decompressor clone() {
                    return this;
                }
            };
        }
    };
    private static final StoredFieldsFormat TEMP_STORED_FIELDS_FORMAT = new Lucene90CompressingStoredFieldsFormat("TempStoredFields", NO_COMPRESSION, 131072, 1, 10);
    TrackingTmpOutputDirectoryWrapper tmpDirectory;

    SortingStoredFieldsConsumer(Codec codec, Directory directory, SegmentInfo info) {
        super(codec, directory, info);
    }

    @Override
    protected void initStoredFieldsWriter() throws IOException {
        if (this.writer == null) {
            this.tmpDirectory = new TrackingTmpOutputDirectoryWrapper(this.directory);
            this.writer = TEMP_STORED_FIELDS_FORMAT.fieldsWriter(this.tmpDirectory, this.info, IOContext.DEFAULT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void flush(SegmentWriteState state, Sorter.DocMap sortMap) throws IOException {
        super.flush(state, sortMap);
        StoredFieldsReader reader = TEMP_STORED_FIELDS_FORMAT.fieldsReader(this.tmpDirectory, state.segmentInfo, state.fieldInfos, IOContext.DEFAULT);
        StoredFieldsWriter sortWriter = this.codec.storedFieldsFormat().fieldsWriter(state.directory, state.segmentInfo, state.context);
        try {
            reader.checkIntegrity();
            CopyVisitor visitor = new CopyVisitor(sortWriter);
            for (int docID = 0; docID < state.segmentInfo.maxDoc(); ++docID) {
                sortWriter.startDocument();
                reader.document(sortMap == null ? docID : sortMap.newToOld(docID), visitor);
                sortWriter.finishDocument();
            }
            sortWriter.finish(state.segmentInfo.maxDoc());
        }
        catch (Throwable throwable) {
            IOUtils.close(reader, sortWriter);
            IOUtils.deleteFiles(this.tmpDirectory, this.tmpDirectory.getTemporaryFiles().values());
            throw throwable;
        }
        IOUtils.close(reader, sortWriter);
        IOUtils.deleteFiles(this.tmpDirectory, this.tmpDirectory.getTemporaryFiles().values());
    }

    @Override
    void abort() {
        try {
            super.abort();
        }
        finally {
            if (this.tmpDirectory != null) {
                IOUtils.deleteFilesIgnoringExceptions((Directory)this.tmpDirectory, this.tmpDirectory.getTemporaryFiles().values());
            }
        }
    }

    private static class CopyVisitor
    extends StoredFieldVisitor {
        final StoredFieldsWriter writer;

        CopyVisitor(StoredFieldsWriter writer) {
            this.writer = writer;
        }

        @Override
        public void binaryField(FieldInfo fieldInfo, DataInput value, int length) throws IOException {
            this.writer.writeField(fieldInfo, value, length);
        }

        @Override
        public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
            this.writer.writeField(fieldInfo, new BytesRef(value));
        }

        @Override
        public void stringField(FieldInfo fieldInfo, String value) throws IOException {
            this.writer.writeField(fieldInfo, Objects.requireNonNull(value, "String value should not be null"));
        }

        @Override
        public void intField(FieldInfo fieldInfo, int value) throws IOException {
            this.writer.writeField(fieldInfo, value);
        }

        @Override
        public void longField(FieldInfo fieldInfo, long value) throws IOException {
            this.writer.writeField(fieldInfo, value);
        }

        @Override
        public void floatField(FieldInfo fieldInfo, float value) throws IOException {
            this.writer.writeField(fieldInfo, value);
        }

        @Override
        public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
            this.writer.writeField(fieldInfo, value);
        }

        @Override
        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            return StoredFieldVisitor.Status.YES;
        }
    }
}

