/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.snowball;

import guideme.internal.shaded.lucene.analysis.TokenFilter;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.tokenattributes.CharTermAttribute;
import guideme.internal.shaded.lucene.analysis.tokenattributes.KeywordAttribute;
import guideme.internal.shaded.snowball.SnowballStemmer;
import java.io.IOException;
import java.util.Objects;

public final class SnowballFilter
extends TokenFilter {
    private final SnowballStemmer stemmer;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);

    public SnowballFilter(TokenStream input, SnowballStemmer stemmer) {
        super(input);
        this.stemmer = Objects.requireNonNull(stemmer, "stemmer");
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (!this.keywordAttr.isKeyword()) {
                char[] termBuffer = this.termAtt.buffer();
                int length = this.termAtt.length();
                this.stemmer.setCurrent(termBuffer, length);
                this.stemmer.stem();
                char[] finalTerm = this.stemmer.getCurrentBuffer();
                int newLength = this.stemmer.getCurrentBufferLength();
                if (finalTerm != termBuffer) {
                    this.termAtt.copyBuffer(finalTerm, 0, newLength);
                } else {
                    this.termAtt.setLength(newLength);
                }
            }
            return true;
        }
        return false;
    }
}

