/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.hotkey;

import com.google.common.base.Strings;
import com.mojang.blaze3d.platform.InputConstants;
import guideme.Guide;
import guideme.PageAnchor;
import guideme.indices.ItemIndex;
import guideme.internal.GuideMEClient;
import guideme.internal.GuideRegistry;
import guideme.internal.GuidebookText;
import guideme.internal.screen.GuideScreen;
import guideme.ui.GuideUiHost;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TickEvent;

public final class OpenGuideHotkey {
    private static final KeyMapping OPEN_GUIDE_MAPPING = new KeyMapping("key.guideme.guide", (IKeyConflictContext)KeyConflictContext.GUI, InputConstants.Type.KEYSYM, 71, "key.guideme.category");
    private static boolean newTick = true;
    private static ResourceLocation previousItemId;
    private static final List<FoundPage> guidebookPages;
    private static int ticksKeyHeld;
    private static boolean holding;

    private OpenGuideHotkey() {
    }

    public static void init() {
        NeoForge.EVENT_BUS.addListener(evt -> OpenGuideHotkey.handleTooltip(evt.getItemStack(), evt.getFlags(), evt.getToolTip()));
        NeoForge.EVENT_BUS.addListener(evt -> {
            if (evt.phase == TickEvent.Phase.END) {
                newTick = true;
            }
        });
    }

    private static void handleTooltip(ItemStack itemStack, TooltipFlag tooltipFlag, List<Component> lines) {
        GuideScreen guideScreen;
        if (!OpenGuideHotkey.isKeyBound()) {
            holding = false;
            ticksKeyHeld = 0;
            return;
        }
        if (newTick) {
            newTick = false;
            OpenGuideHotkey.update(itemStack);
        }
        if (guidebookPages.isEmpty()) {
            return;
        }
        Guide guide = guidebookPages.get(0).guide();
        PageAnchor pageAnchor = guidebookPages.get(0).page();
        Minecraft minecraft = Minecraft.getInstance();
        Screen screen = minecraft.screen;
        if (screen instanceof GuideScreen && (guideScreen = (GuideScreen)screen).getGuide() == guide && guideScreen.getCurrentPageId().equals((Object)pageAnchor.pageId())) {
            return;
        }
        float progress = ticksKeyHeld;
        progress = holding ? (progress += minecraft.getDeltaFrameTime()) : (progress -= minecraft.getDeltaFrameTime());
        Component component = OpenGuideHotkey.makeProgressBar(Mth.clamp((float)(progress /= 10.0f), (float)0.0f, (float)1.0f));
        if (lines.isEmpty()) {
            lines.add(component);
        } else {
            lines.add(1, component);
        }
    }

    private static Component makeProgressBar(float progress) {
        Minecraft minecraft = Minecraft.getInstance();
        MutableComponent holdW = GuidebookText.HoldToShow.text(OpenGuideHotkey.getHotkey().getTranslatedKeyMessage().copy().withStyle(ChatFormatting.GRAY)).withStyle(ChatFormatting.DARK_GRAY);
        Font fontRenderer = minecraft.font;
        int charWidth = fontRenderer.width("|");
        int tipWidth = fontRenderer.width((FormattedText)holdW);
        int total = tipWidth / charWidth;
        int current = (int)(progress * (float)total);
        if (progress > 0.0f) {
            MutableComponent result = Component.literal((String)Strings.repeat((String)"|", (int)current)).withStyle(ChatFormatting.GRAY);
            if (progress < 1.0f) {
                result = result.append((Component)Component.literal((String)Strings.repeat((String)"|", (int)(total - current))).withStyle(ChatFormatting.DARK_GRAY));
            }
            return result;
        }
        return holdW;
    }

    private static void update(ItemStack itemStack) {
        ResourceLocation itemId = itemStack.getItemHolder().unwrapKey().map(ResourceKey::location).orElse(null);
        if (!Objects.equals(itemId, previousItemId)) {
            previousItemId = itemId;
            guidebookPages.clear();
            ticksKeyHeld = 0;
            if (itemId == null) {
                return;
            }
            for (Guide guide : GuideRegistry.getAll()) {
                ItemIndex itemIndex;
                PageAnchor page;
                if (!guide.isAvailableToOpenHotkey() || (page = (PageAnchor)(itemIndex = guide.getIndex(ItemIndex.class)).get(itemId)) == null) continue;
                guidebookPages.add(new FoundPage(guide, page));
            }
        }
        if (holding = OpenGuideHotkey.isKeyHeld()) {
            if (ticksKeyHeld < 10 && ++ticksKeyHeld == 10) {
                if (!guidebookPages.isEmpty()) {
                    GuideUiHost uiHost;
                    Guide guide;
                    FoundPage foundPage = guidebookPages.get(0);
                    guide = foundPage.guide();
                    Screen screen = Minecraft.getInstance().screen;
                    if (screen instanceof GuideUiHost && (uiHost = (GuideUiHost)screen).getGuide() == guide) {
                        uiHost.navigateTo(foundPage.page());
                    } else {
                        GuideMEClient.openGuideAtAnchor(guide, foundPage.page());
                    }
                    ticksKeyHeld = 0;
                    holding = false;
                }
            } else if (ticksKeyHeld > 10) {
                ticksKeyHeld = 10;
            }
        } else {
            ticksKeyHeld = Math.max(0, ticksKeyHeld - 2);
        }
    }

    private static boolean isKeyHeld() {
        int keyCode = OpenGuideHotkey.getHotkey().getKey().getValue();
        long window = Minecraft.getInstance().getWindow().getWindow();
        return InputConstants.isKeyDown((long)window, (int)keyCode);
    }

    private static boolean isKeyBound() {
        return !OPEN_GUIDE_MAPPING.isUnbound();
    }

    public static KeyMapping getHotkey() {
        return OPEN_GUIDE_MAPPING;
    }

    static {
        guidebookPages = new ArrayList<FoundPage>();
    }

    private record FoundPage(Guide guide, PageAnchor page) {
    }
}

