/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal;

import guideme.Guide;
import guideme.Guides;
import guideme.PageAnchor;
import guideme.internal.GuideRegistry;
import guideme.internal.MutableGuide;
import guideme.internal.screen.GuideScreen;
import guideme.internal.util.Platform;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.commands.Commands;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.resource.ResourcePackLoader;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GuideOnStartup {
    private static final Logger LOG = LoggerFactory.getLogger(GuideOnStartup.class);

    private GuideOnStartup() {
    }

    public static void init(IEventBus modBus) {
        Set<ResourceLocation> guidesToValidate = GuideOnStartup.getGuideIdsToValidate();
        ShowOnStartup showOnStartup = GuideOnStartup.getShowOnStartup();
        if (!guidesToValidate.isEmpty() || showOnStartup != null) {
            MutableBoolean guideOpenedOnce = new MutableBoolean(false);
            NeoForge.EVENT_BUS.addListener(e -> {
                if (e.getNewScreen() instanceof TitleScreen && !guideOpenedOnce.booleanValue()) {
                    guideOpenedOnce.setTrue();
                    GuideOnStartup.runDatapackReload();
                    for (ResourceLocation guideId : guidesToValidate) {
                        MutableGuide guide = GuideRegistry.getById(guideId);
                        if (guide == null) {
                            LOG.error("Cannot validate guide '{}' since it does not exist.", (Object)guideId);
                            continue;
                        }
                        guide.validateAll();
                    }
                    if (showOnStartup != null) {
                        Guide guide = Guides.getById(showOnStartup.guideId);
                        if (guide == null) {
                            LOG.error("Cannot show guide '{}' since it does not exist.", (Object)showOnStartup.guideId);
                        } else {
                            try {
                                PageAnchor anchor = showOnStartup.anchor;
                                if (anchor == null) {
                                    anchor = PageAnchor.page(guide.getStartPage());
                                }
                                e.setNewScreen((Screen)GuideScreen.openNew(guide, anchor));
                            }
                            catch (Exception ex) {
                                LOG.error("Failed to open {}", (Object)showOnStartup, (Object)ex);
                                System.exit(1);
                            }
                        }
                    }
                }
            });
        }
    }

    private static ShowOnStartup getShowOnStartup() {
        String showOnStartup = System.getProperty("guideme.showOnStartup");
        if (showOnStartup == null) {
            return null;
        }
        String[] parts = showOnStartup.split("!", 2);
        ResourceLocation guideId = new ResourceLocation(parts[0]);
        PageAnchor page = null;
        if (parts.length > 1) {
            page = PageAnchor.parse(parts[1]);
        }
        return new ShowOnStartup(guideId, page);
    }

    private static Set<ResourceLocation> getGuideIdsToValidate() {
        LinkedHashSet<ResourceLocation> guidesToValidate = new LinkedHashSet<ResourceLocation>();
        String validateGuideIds = System.getProperty("guideme.validateAtStartup");
        if (validateGuideIds != null) {
            String[] guideIds;
            for (String guideId : guideIds = validateGuideIds.split(",")) {
                guidesToValidate.add(new ResourceLocation(guideId));
            }
        }
        return guidesToValidate;
    }

    public static CompletableFuture<Minecraft> afterClientStart(IEventBus modEventBus) {
        CompletableFuture<Minecraft> future = new CompletableFuture<Minecraft>();
        modEventBus.addListener(evt -> {
            CompletableFuture reload;
            Minecraft client = Minecraft.getInstance();
            Overlay patt0$temp = client.getOverlay();
            if (patt0$temp instanceof LoadingOverlay) {
                LoadingOverlay loadingOverlay = (LoadingOverlay)patt0$temp;
                reload = loadingOverlay.reload.done();
            } else {
                reload = CompletableFuture.completedFuture(null);
            }
            reload.whenCompleteAsync((o, throwable) -> {
                if (throwable != null) {
                    future.completeExceptionally((Throwable)throwable);
                } else {
                    future.complete(client);
                }
            }, (Executor)client);
        });
        return future;
    }

    public static void runDatapackReload() {
        try {
            LayeredRegistryAccess layeredAccess = RegistryLayer.createRegistryAccess();
            PackRepository packRepository = new PackRepository(new RepositorySource[]{new ServerPacksSource(new DirectoryValidator(path -> false))});
            ResourcePackLoader.populatePackRepository((PackRepository)packRepository, (PackType)PackType.SERVER_DATA);
            packRepository.reload();
            packRepository.setSelected(packRepository.getAvailableIds());
            MultiPackResourceManager resourceManager = new MultiPackResourceManager(PackType.SERVER_DATA, packRepository.openAllSelected());
            RegistryAccess.Frozen worldgenLayer = RegistryDataLoader.load((ResourceManager)resourceManager, (RegistryAccess)layeredAccess.getAccessForLoading((Object)RegistryLayer.WORLDGEN), (List)RegistryDataLoader.WORLDGEN_REGISTRIES);
            layeredAccess = layeredAccess.replaceFrom((Object)RegistryLayer.WORLDGEN, new RegistryAccess.Frozen[]{worldgenLayer});
            ReloadableServerResources stuff = (ReloadableServerResources)ReloadableServerResources.loadResources((ResourceManager)resourceManager, (RegistryAccess.Frozen)layeredAccess.getAccessForLoading((Object)RegistryLayer.RELOADABLE), (FeatureFlagSet)FeatureFlagSet.of(), (Commands.CommandSelection)Commands.CommandSelection.ALL, (int)0, (Executor)Util.backgroundExecutor(), command -> {
                try {
                    command.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
            }).get();
            stuff.updateRegistryTags((RegistryAccess)layeredAccess.compositeAccess());
            Platform.fallbackClientRecipeManager = stuff.getRecipeManager();
            Platform.fallbackClientRegistryAccess = layeredAccess.compositeAccess();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static final class ShowOnStartup
    extends Record {
        private final ResourceLocation guideId;
        @Nullable
        private final PageAnchor anchor;

        private ShowOnStartup(ResourceLocation guideId, @Nullable PageAnchor anchor) {
            this.guideId = guideId;
            this.anchor = anchor;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ShowOnStartup.class, "guideId;anchor", "guideId", "anchor"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ShowOnStartup.class, "guideId;anchor", "guideId", "anchor"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ShowOnStartup.class, "guideId;anchor", "guideId", "anchor"}, this, o);
        }
    }
}

