/*
 * Decompiled with CFR 0.152.
 */
package guideme.document.block.recipes;

import guideme.document.DefaultStyles;
import guideme.document.LytRect;
import guideme.document.block.LytSlot;
import guideme.document.block.LytSlotGrid;
import guideme.document.block.recipes.LytRecipeBox;
import guideme.internal.GuidebookText;
import guideme.internal.util.Platform;
import guideme.layout.LayoutContext;
import guideme.render.GuiAssets;
import guideme.render.RenderContext;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.block.Blocks;

@Deprecated(forRemoval=true)
public class LytCraftingRecipe
extends LytRecipeBox {
    private final CraftingRecipe recipe;
    private final LytSlotGrid grid;
    private final LytSlot resultSlot;

    public LytCraftingRecipe(RecipeHolder<CraftingRecipe> holder) {
        super(holder);
        this.recipe = (CraftingRecipe)holder.value();
        this.setPadding(5);
        this.paddingTop = 15;
        NonNullList ingredients = this.recipe.getIngredients();
        CraftingRecipe craftingRecipe = this.recipe;
        if (craftingRecipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)craftingRecipe;
            this.grid = new LytSlotGrid(shapedRecipe.getWidth(), shapedRecipe.getHeight());
            for (int x = 0; x < shapedRecipe.getWidth(); ++x) {
                for (int y = 0; y < shapedRecipe.getHeight(); ++y) {
                    Ingredient ingredient;
                    int index = y * shapedRecipe.getWidth() + x;
                    if (index >= ingredients.size() || (ingredient = (Ingredient)ingredients.get(index)).isEmpty()) continue;
                    this.grid.setIngredient(x, y, ingredient);
                }
            }
        } else {
            int ingredientCount = ingredients.size();
            this.grid = new LytSlotGrid(Math.min(3, ingredientCount), (ingredientCount + 2) / 3);
            for (int i = 0; i < ingredients.size(); ++i) {
                int col = i % 3;
                int row = i / 3;
                this.grid.setIngredient(col, row, (Ingredient)ingredients.get(i));
            }
        }
        this.append(this.grid);
        this.resultSlot = new LytSlot(this.recipe.getResultItem(Platform.getClientRegistryAccess()));
        this.append(this.resultSlot);
    }

    @Override
    protected LytRect computeBoxLayout(LayoutContext context, int x, int y, int availableWidth) {
        LytRect gridBounds = this.grid.layout(context, x, y, availableWidth);
        LytRect slotBounds = this.resultSlot.layout(context, gridBounds.right() + 28, Math.max(y, gridBounds.y() + (gridBounds.height() - 18) / 2), availableWidth);
        return LytRect.union(gridBounds, slotBounds);
    }

    @Override
    public void render(RenderContext context) {
        context.renderPanel(this.getBounds());
        context.renderItem(Blocks.CRAFTING_TABLE.asItem().getDefaultInstance(), this.bounds.x() + this.paddingLeft, this.bounds.y() + 4, 8.0f, 8.0f);
        GuidebookText title = this.recipe instanceof ShapelessRecipe ? GuidebookText.ShapelessCrafting : GuidebookText.Crafting;
        context.renderText(title.text().getString(), DefaultStyles.CRAFTING_RECIPE_TYPE.mergeWith(DefaultStyles.BASE_STYLE), this.bounds.x() + this.paddingLeft + 10, this.bounds.y() + 4);
        context.fillIcon(new LytRect(this.bounds.right() - 25 - 24, this.bounds.y() + 10 + (this.bounds.height() - 27) / 2, 24, 17), GuiAssets.ARROW);
        super.render(context);
    }
}

