/*
 * Decompiled with CFR 0.152.
 */
package guideme.compiler;

import guideme.GuidePage;
import guideme.PageAnchor;
import guideme.PageCollection;
import guideme.color.SymbolicColor;
import guideme.compiler.Frontmatter;
import guideme.compiler.IdUtils;
import guideme.compiler.LinkParser;
import guideme.compiler.ParsedGuidePage;
import guideme.compiler.TagCompiler;
import guideme.document.LytErrorSink;
import guideme.document.block.LytBlock;
import guideme.document.block.LytBlockContainer;
import guideme.document.block.LytDocument;
import guideme.document.block.LytHeading;
import guideme.document.block.LytImage;
import guideme.document.block.LytList;
import guideme.document.block.LytListItem;
import guideme.document.block.LytNode;
import guideme.document.block.LytParagraph;
import guideme.document.block.LytThematicBreak;
import guideme.document.block.LytVBox;
import guideme.document.block.table.LytTable;
import guideme.document.block.table.LytTableCell;
import guideme.document.block.table.LytTableRow;
import guideme.document.flow.LytFlowBreak;
import guideme.document.flow.LytFlowContent;
import guideme.document.flow.LytFlowInlineBlock;
import guideme.document.flow.LytFlowLink;
import guideme.document.flow.LytFlowParent;
import guideme.document.flow.LytFlowSpan;
import guideme.document.flow.LytFlowText;
import guideme.document.interaction.TextTooltip;
import guideme.extensions.Extension;
import guideme.extensions.ExtensionCollection;
import guideme.extensions.ExtensionPoint;
import guideme.indices.PageIndex;
import guideme.libs.mdast.MdAst;
import guideme.libs.mdast.MdAstYamlFrontmatter;
import guideme.libs.mdast.MdastOptions;
import guideme.libs.mdast.YamlFrontmatterExtension;
import guideme.libs.mdast.gfm.GfmTableMdastExtension;
import guideme.libs.mdast.gfm.model.GfmTable;
import guideme.libs.mdast.gfm.model.GfmTableRow;
import guideme.libs.mdast.gfmstrikethrough.GfmStrikethroughMdastExtension;
import guideme.libs.mdast.gfmstrikethrough.MdAstDelete;
import guideme.libs.mdast.mdx.MdxMdastExtension;
import guideme.libs.mdast.mdx.model.MdxJsxFlowElement;
import guideme.libs.mdast.mdx.model.MdxJsxTextElement;
import guideme.libs.mdast.model.MdAstAnyContent;
import guideme.libs.mdast.model.MdAstBlockquote;
import guideme.libs.mdast.model.MdAstBreak;
import guideme.libs.mdast.model.MdAstCode;
import guideme.libs.mdast.model.MdAstEmphasis;
import guideme.libs.mdast.model.MdAstHeading;
import guideme.libs.mdast.model.MdAstImage;
import guideme.libs.mdast.model.MdAstInlineCode;
import guideme.libs.mdast.model.MdAstLink;
import guideme.libs.mdast.model.MdAstList;
import guideme.libs.mdast.model.MdAstListContent;
import guideme.libs.mdast.model.MdAstListItem;
import guideme.libs.mdast.model.MdAstNode;
import guideme.libs.mdast.model.MdAstParagraph;
import guideme.libs.mdast.model.MdAstParent;
import guideme.libs.mdast.model.MdAstPhrasingContent;
import guideme.libs.mdast.model.MdAstPosition;
import guideme.libs.mdast.model.MdAstRoot;
import guideme.libs.mdast.model.MdAstStrong;
import guideme.libs.mdast.model.MdAstText;
import guideme.libs.mdast.model.MdAstThematicBreak;
import guideme.libs.mdx.MdxSyntax;
import guideme.libs.micromark.ParseException;
import guideme.libs.micromark.extensions.YamlFrontmatterSyntax;
import guideme.libs.micromark.extensions.gfm.GfmTableSyntax;
import guideme.libs.micromark.extensions.gfmstrikethrough.GfmStrikethroughSyntax;
import guideme.libs.unist.UnistNode;
import guideme.libs.unist.UnistPoint;
import guideme.libs.unist.UnistPosition;
import guideme.style.TextAlignment;
import guideme.style.WhiteSpaceMode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PageCompiler {
    private static final Logger LOG = LoggerFactory.getLogger(PageCompiler.class);
    private final PageCollection pages;
    private final ExtensionCollection extensions;
    private final String sourcePack;
    private final ResourceLocation pageId;
    private final String pageContent;
    private final Map<String, TagCompiler> tagCompilers = new HashMap<String, TagCompiler>();
    private final Map<State<?>, Object> compilerState = new IdentityHashMap();

    public PageCompiler(PageCollection pages, ExtensionCollection extensions, String sourcePack, ResourceLocation pageId, String pageContent) {
        this.pages = pages;
        this.extensions = extensions;
        this.sourcePack = sourcePack;
        this.pageId = pageId;
        this.pageContent = pageContent;
        for (TagCompiler tagCompiler : extensions.get(TagCompiler.EXTENSION_POINT)) {
            for (String tagName : tagCompiler.getTagNames()) {
                this.tagCompilers.put(tagName, tagCompiler);
            }
        }
    }

    @Deprecated(forRemoval=true)
    public static ParsedGuidePage parse(String sourcePack, ResourceLocation id, InputStream in) throws IOException {
        return PageCompiler.parse(sourcePack, "en_us", id, in);
    }

    public static ParsedGuidePage parse(String sourcePack, String language, ResourceLocation id, InputStream in) throws IOException {
        String pageContent = new String(in.readAllBytes(), StandardCharsets.UTF_8);
        return PageCompiler.parse(sourcePack, language, id, pageContent);
    }

    @Deprecated(forRemoval=true)
    public static ParsedGuidePage parse(String sourcePack, ResourceLocation id, String pageContent) {
        return PageCompiler.parse(sourcePack, "en_us", id, pageContent);
    }

    public static ParsedGuidePage parse(String sourcePack, String language, ResourceLocation id, String pageContent) {
        MdAstRoot astRoot;
        pageContent = pageContent.replaceAll("\\r\\n?", "\n");
        MdastOptions options = new MdastOptions().withSyntaxExtension(MdxSyntax.INSTANCE).withSyntaxExtension(YamlFrontmatterSyntax.INSTANCE).withSyntaxExtension(GfmTableSyntax.INSTANCE).withSyntaxExtension(GfmStrikethroughSyntax.INSTANCE).withMdastExtension(MdxMdastExtension.INSTANCE).withMdastExtension(YamlFrontmatterExtension.INSTANCE).withMdastExtension(GfmTableMdastExtension.INSTANCE).withMdastExtension(GfmStrikethroughMdastExtension.INSTANCE);
        try {
            astRoot = MdAst.fromMarkdown(pageContent, options);
        }
        catch (ParseException e) {
            String errorMessage = String.format(Locale.ROOT, "Failed to parse GuideME page %s (lang: %s) from resource pack %s", id, language, sourcePack);
            LOG.error("{}", (Object)errorMessage, (Object)e);
            astRoot = PageCompiler.buildErrorPage(errorMessage + ": \n" + String.valueOf(e));
        }
        Frontmatter frontmatter = PageCompiler.parseFrontmatter(id, astRoot);
        return new ParsedGuidePage(sourcePack, id, pageContent, astRoot, frontmatter, language);
    }

    private static MdAstRoot buildErrorPage(String errorText) {
        MdAstRoot root = new MdAstRoot();
        MdAstHeading heading = new MdAstHeading();
        root.addChild(heading);
        heading.depth = 1;
        MdAstText headingText = new MdAstText();
        headingText.setValue("PARSING ERROR");
        heading.addChild(headingText);
        MdAstParagraph errorParagraph = new MdAstParagraph();
        root.addChild(errorParagraph);
        MdAstText errorTextNode = new MdAstText();
        errorTextNode.setValue(errorText);
        errorParagraph.addChild(errorTextNode);
        return root;
    }

    public static GuidePage compile(PageCollection pages, ExtensionCollection extensions, ParsedGuidePage parsedPage) {
        LytDocument document = new PageCompiler(pages, extensions, parsedPage.sourcePack, parsedPage.id, parsedPage.source).compile(parsedPage.astRoot);
        return new GuidePage(parsedPage.sourcePack, parsedPage.id, document);
    }

    public ExtensionCollection getExtensions() {
        return this.extensions;
    }

    public <T extends Extension> List<T> getExtensions(ExtensionPoint<T> extensionPoint) {
        return this.extensions.get(extensionPoint);
    }

    private LytDocument compile(MdAstRoot root) {
        LytDocument document = new LytDocument();
        document.setSourceNode(root);
        this.compileBlockContext(root, (LytBlockContainer)document);
        return document;
    }

    private static Frontmatter parseFrontmatter(ResourceLocation pageId, MdAstRoot root) {
        Frontmatter result = null;
        for (MdAstAnyContent child : root.children()) {
            if (!(child instanceof MdAstYamlFrontmatter)) continue;
            MdAstYamlFrontmatter frontmatter = (MdAstYamlFrontmatter)child;
            if (result != null) {
                LOG.error("Found more than one frontmatter!");
                continue;
            }
            try {
                result = Frontmatter.parse(pageId, frontmatter.value);
            }
            catch (Exception e) {
                LOG.error("Failed to parse frontmatter for page {}", (Object)pageId, (Object)e);
                break;
            }
        }
        return Objects.requireNonNullElse(result, new Frontmatter(null, Map.of()));
    }

    public void compileBlockContext(MdAstParent<?> markdownParent, LytBlockContainer layoutParent) {
        this.compileBlockContext(markdownParent.children(), layoutParent);
    }

    public void compileBlockContext(List<? extends MdAstAnyContent> children, LytBlockContainer layoutParent) {
        LytThematicBreak previousLayoutChild = null;
        for (MdAstAnyContent mdAstAnyContent : children) {
            LytBlock layoutChild;
            if (mdAstAnyContent instanceof MdAstThematicBreak) {
                layoutChild = new LytThematicBreak();
            } else if (mdAstAnyContent instanceof MdAstList) {
                MdAstList astList = (MdAstList)mdAstAnyContent;
                layoutChild = this.compileList(astList);
            } else if (mdAstAnyContent instanceof MdAstCode) {
                MdAstCode astCode = (MdAstCode)mdAstAnyContent;
                paragraph = new LytParagraph();
                paragraph.modifyStyle(style -> style.italic(true).whiteSpace(WhiteSpaceMode.PRE));
                paragraph.setMarginLeft(5);
                paragraph.appendText(astCode.value);
                layoutChild = paragraph;
            } else if (mdAstAnyContent instanceof MdAstHeading) {
                MdAstHeading astHeading = (MdAstHeading)mdAstAnyContent;
                LytHeading heading = new LytHeading();
                heading.setDepth(astHeading.depth);
                this.compileFlowContext(astHeading, (LytFlowParent)heading);
                layoutChild = heading;
            } else if (mdAstAnyContent instanceof MdAstBlockquote) {
                MdAstBlockquote astBlockquote = (MdAstBlockquote)mdAstAnyContent;
                LytVBox blockquote = new LytVBox();
                blockquote.setBackgroundColor(SymbolicColor.BLOCKQUOTE_BACKGROUND);
                blockquote.setPadding(5);
                blockquote.setPaddingLeft(10);
                blockquote.setMarginTop(5);
                blockquote.setMarginBottom(5);
                this.compileBlockContext(astBlockquote, (LytBlockContainer)blockquote);
                List<? extends LytNode> bqChildren = blockquote.getChildren();
                if (!bqChildren.isEmpty()) {
                    LytNode lytNode = bqChildren.get(0);
                    if (lytNode instanceof LytParagraph) {
                        LytParagraph firstParagraph = (LytParagraph)lytNode;
                        firstParagraph.setMarginTop(0);
                    }
                    if ((lytNode = bqChildren.get(bqChildren.size() - 1)) instanceof LytParagraph) {
                        LytParagraph lastParagraph = (LytParagraph)lytNode;
                        lastParagraph.setMarginBottom(0);
                    }
                }
                layoutChild = blockquote;
            } else if (mdAstAnyContent instanceof MdAstParagraph) {
                MdAstParagraph astParagraph = (MdAstParagraph)mdAstAnyContent;
                paragraph = new LytParagraph();
                this.compileFlowContext(astParagraph, (LytFlowParent)paragraph);
                paragraph.setMarginTop(5);
                paragraph.setMarginBottom(5);
                layoutChild = paragraph;
            } else if (mdAstAnyContent instanceof MdAstYamlFrontmatter) {
                layoutChild = null;
            } else if (mdAstAnyContent instanceof GfmTable) {
                GfmTable astTable = (GfmTable)mdAstAnyContent;
                layoutChild = this.compileTable(astTable);
            } else if (mdAstAnyContent instanceof MdxJsxFlowElement) {
                MdxJsxFlowElement el = (MdxJsxFlowElement)mdAstAnyContent;
                TagCompiler compiler = this.tagCompilers.get(el.name());
                if (compiler == null) {
                    layoutChild = this.createErrorBlock("Unhandled MDX element in block context", mdAstAnyContent);
                } else {
                    layoutChild = null;
                    compiler.compileBlockContext(this, layoutParent, el);
                }
            } else if (mdAstAnyContent instanceof MdAstPhrasingContent) {
                MdAstPhrasingContent phrasingContent = (MdAstPhrasingContent)mdAstAnyContent;
                if (previousLayoutChild instanceof LytParagraph) {
                    paragraph = (LytParagraph)((Object)previousLayoutChild);
                    this.compileFlowContent(paragraph, phrasingContent);
                    continue;
                }
                LytParagraph paragraph = new LytParagraph();
                this.compileFlowContent(paragraph, phrasingContent);
                layoutChild = paragraph;
            } else {
                layoutChild = this.createErrorBlock("Unhandled Markdown node in block context", mdAstAnyContent);
            }
            if (layoutChild != null) {
                if (mdAstAnyContent instanceof MdAstNode) {
                    MdAstNode astNode = (MdAstNode)((Object)mdAstAnyContent);
                    layoutChild.setSourceNode(astNode);
                }
                layoutParent.append(layoutChild);
            }
            previousLayoutChild = layoutChild;
        }
    }

    private LytList compileList(MdAstList astList) {
        LytList list = new LytList(astList.ordered, astList.start);
        for (MdAstListContent listContent : astList.children()) {
            if (listContent instanceof MdAstListItem) {
                LytNode firstChild;
                MdAstListItem astListItem = (MdAstListItem)listContent;
                LytListItem listItem = new LytListItem();
                this.compileBlockContext(astListItem, (LytBlockContainer)listItem);
                List<? extends LytNode> children = listItem.getChildren();
                if (!children.isEmpty() && (firstChild = children.get(0)) instanceof LytBlock) {
                    LytBlock firstBlock = (LytBlock)firstChild;
                    firstBlock.setMarginTop(0);
                    firstBlock.setMarginBottom(0);
                }
                list.append(listItem);
                continue;
            }
            list.append(this.createErrorBlock("Cannot handle list content", listContent));
        }
        return list;
    }

    private LytBlock compileTable(GfmTable astTable) {
        LytTable table = new LytTable();
        table.setMarginBottom(5);
        boolean firstRow = true;
        for (GfmTableRow astRow : astTable.children()) {
            LytTableRow row = table.appendRow();
            if (firstRow) {
                row.modifyStyle(style -> style.bold(true));
                firstRow = false;
            }
            List astCells = astRow.children();
            for (int i = 0; i < astCells.size(); ++i) {
                LytTableCell cell = row.appendCell();
                if (astTable.align != null && i < astTable.align.size()) {
                    switch (astTable.align.get(i)) {
                        case CENTER: {
                            cell.modifyStyle(style -> style.alignment(TextAlignment.CENTER));
                            break;
                        }
                        case RIGHT: {
                            cell.modifyStyle(style -> style.alignment(TextAlignment.RIGHT));
                        }
                    }
                }
                this.compileBlockContext((MdAstParent)astCells.get(i), (LytBlockContainer)cell);
            }
        }
        return table;
    }

    public void compileFlowContext(MdAstParent<?> markdownParent, LytFlowParent layoutParent) {
        this.compileFlowContext(markdownParent.children(), layoutParent);
    }

    public void compileFlowContext(Collection<? extends MdAstAnyContent> children, LytFlowParent layoutParent) {
        for (MdAstAnyContent mdAstAnyContent : children) {
            this.compileFlowContent(layoutParent, mdAstAnyContent);
        }
    }

    private void compileFlowContent(LytFlowParent layoutParent, MdAstAnyContent content) {
        LytFlowContent layoutChild;
        if (content instanceof MdAstText) {
            MdAstText astText = (MdAstText)content;
            LytFlowText text = new LytFlowText();
            text.setText(astText.value);
            layoutChild = text;
        } else if (content instanceof MdAstInlineCode) {
            MdAstInlineCode astCode = (MdAstInlineCode)content;
            LytFlowText text = new LytFlowText();
            text.setText(astCode.value);
            text.modifyStyle(style -> style.italic(true).whiteSpace(WhiteSpaceMode.PRE));
            layoutChild = text;
        } else if (content instanceof MdAstStrong) {
            MdAstStrong astStrong = (MdAstStrong)content;
            LytFlowSpan span = new LytFlowSpan();
            span.modifyStyle(style -> style.bold(true));
            this.compileFlowContext(astStrong, (LytFlowParent)span);
            layoutChild = span;
        } else if (content instanceof MdAstEmphasis) {
            MdAstEmphasis astEmphasis = (MdAstEmphasis)content;
            LytFlowSpan span = new LytFlowSpan();
            span.modifyStyle(style -> style.italic(true));
            this.compileFlowContext(astEmphasis, (LytFlowParent)span);
            layoutChild = span;
        } else if (content instanceof MdAstDelete) {
            MdAstDelete astEmphasis = (MdAstDelete)content;
            LytFlowSpan span = new LytFlowSpan();
            span.modifyStyle(style -> style.strikethrough(true));
            this.compileFlowContext(astEmphasis, (LytFlowParent)span);
            layoutChild = span;
        } else if (content instanceof MdAstBreak) {
            layoutChild = new LytFlowBreak();
        } else if (content instanceof MdAstLink) {
            MdAstLink astLink = (MdAstLink)content;
            layoutChild = this.compileLink(astLink, layoutParent);
        } else if (content instanceof MdAstImage) {
            MdAstImage astImage = (MdAstImage)content;
            LytFlowInlineBlock inlineBlock = new LytFlowInlineBlock();
            inlineBlock.setBlock(this.compileImage(astImage));
            layoutChild = inlineBlock;
        } else if (content instanceof MdxJsxTextElement) {
            MdxJsxTextElement el = (MdxJsxTextElement)content;
            TagCompiler compiler = this.tagCompilers.get(el.name());
            if (compiler == null) {
                layoutChild = this.createErrorFlowContent("Unhandled MDX element in flow context", content);
            } else {
                layoutChild = null;
                compiler.compileFlowContext(this, layoutParent, el);
            }
        } else {
            layoutChild = this.createErrorFlowContent("Unhandled Markdown node in flow context", content);
        }
        if (layoutChild != null) {
            layoutParent.append(layoutChild);
        }
    }

    private LytFlowContent compileLink(final MdAstLink astLink, final LytErrorSink errorSink) {
        final LytFlowLink link = new LytFlowLink();
        if (astLink.title != null && !astLink.title.isEmpty()) {
            link.setTooltip(new TextTooltip(astLink.title));
        }
        if (astLink.url != null && !astLink.url.isEmpty()) {
            LinkParser.parseLink(this, astLink.url, new LinkParser.Visitor(){

                @Override
                public void handlePage(PageAnchor page) {
                    link.setPageLink(page);
                }

                @Override
                public void handleExternal(URI uri) {
                    link.setExternalUrl(uri);
                }

                @Override
                public void handleError(String error) {
                    errorSink.appendError(PageCompiler.this, error, astLink);
                }
            });
        }
        this.compileFlowContext(astLink, (LytFlowParent)link);
        return link;
    }

    private LytImage compileImage(MdAstImage astImage) {
        LytImage image = new LytImage();
        image.setTitle(astImage.title);
        image.setAlt(astImage.alt);
        try {
            ResourceLocation imageId = IdUtils.resolveLink(astImage.url, this.pageId);
            byte[] imageContent = this.pages.loadAsset(imageId);
            if (imageContent == null) {
                LOG.error("Couldn't find image {}", (Object)astImage.url);
                image.setTitle("Missing image: " + astImage.url);
            }
            image.setImage(imageId, imageContent);
        }
        catch (ResourceLocationException e) {
            LOG.error("Invalid image id: {}", (Object)astImage.url);
            image.setTitle("Invalid image URL: " + astImage.url);
        }
        return image;
    }

    public LytBlock createErrorBlock(String text, UnistNode child) {
        LytParagraph paragraph = new LytParagraph();
        paragraph.append(this.createErrorFlowContent(text, child));
        return paragraph;
    }

    public LytFlowContent createErrorFlowContent(String text, UnistNode child) {
        LytFlowSpan span = new LytFlowSpan();
        span.modifyStyle(style -> style.color(SymbolicColor.ERROR_TEXT).whiteSpace(WhiteSpaceMode.PRE));
        UnistPosition position = child.position();
        if (position != null) {
            UnistPoint pos = position.start();
            int startOfLine = this.pageContent.lastIndexOf(10, pos.offset()) + 1;
            int endOfLine = this.pageContent.indexOf(10, pos.offset() + 1);
            if (endOfLine == -1) {
                endOfLine = this.pageContent.length();
            }
            String line = this.pageContent.substring(startOfLine, endOfLine);
            text = (String)text + " " + child.type() + " (" + MdAstPosition.stringify(pos) + ")";
            span.appendText((String)text);
            span.appendBreak();
            span.appendText(line);
            span.appendBreak();
            span.appendText("~".repeat(pos.column() - 1) + "^");
            span.appendBreak();
            LOG.warn("{}\n{}\n{}\n", new Object[]{text, line, "~".repeat(pos.column() - 1) + "^"});
        } else {
            LOG.warn("{}\n", text);
        }
        return span;
    }

    public ResourceLocation resolveId(String idText) {
        return IdUtils.resolveId(idText, this.pageId.getNamespace());
    }

    public ResourceLocation getPageId() {
        return this.pageId;
    }

    public PageCollection getPageCollection() {
        return this.pages;
    }

    public byte @Nullable [] loadAsset(ResourceLocation imageId) {
        return this.pages.loadAsset(imageId);
    }

    public <T extends PageIndex> T getIndex(Class<T> clazz) {
        return this.pages.getIndex(clazz);
    }

    public <T> T getCompilerState(State<T> state) {
        Object current = this.compilerState.getOrDefault(state, state.defaultValue);
        return state.dataClass.cast(current);
    }

    public <T> void setCompilerState(State<T> state, T value) {
        this.compilerState.put(state, value);
    }

    public <T> void clearCompilerState(State<T> state) {
        this.compilerState.remove(state);
    }

    public record State<T>(String name, Class<T> dataClass, T defaultValue) {
    }
}

