/*
 * Decompiled with CFR 0.152.
 */
package guideme.scene.level;

import guideme.scene.level.GuidebookChunk;
import guideme.scene.level.GuidebookLevel;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.function.BooleanSupplier;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.jetbrains.annotations.Nullable;

class GuidebookChunkSource
extends ChunkSource {
    private final GuidebookLevel level;
    private final Long2ObjectMap<GuidebookChunk> chunks = new Long2ObjectOpenHashMap();
    private final LevelLightEngine lightEngine;

    public GuidebookChunkSource(GuidebookLevel level) {
        this.level = level;
        this.lightEngine = new LevelLightEngine((LightChunkGetter)this, true, true);
    }

    @Nullable
    public ChunkAccess getChunk(int chunkX, int chunkZ, ChunkStatus requiredStatus, boolean load) {
        long chunkKey = ChunkPos.asLong((int)chunkX, (int)chunkZ);
        GuidebookChunk chunk = (GuidebookChunk)((Object)this.chunks.get(chunkKey));
        if (chunk == null) {
            chunk = new GuidebookChunk(this.level, new ChunkPos(chunkX, chunkZ));
            this.chunks.put(chunkKey, (Object)chunk);
        }
        return chunk;
    }

    public void tick(BooleanSupplier booleanSupplier, boolean bl) {
    }

    public String gatherStats() {
        return "";
    }

    public int getLoadedChunksCount() {
        return 0;
    }

    public LevelLightEngine getLightEngine() {
        return this.lightEngine;
    }

    public BlockGetter getLevel() {
        return this.level;
    }
}

