/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark.factory;

import guideme.libs.micromark.Assert;
import guideme.libs.micromark.CharUtil;
import guideme.libs.micromark.ContentType;
import guideme.libs.micromark.State;
import guideme.libs.micromark.Token;
import guideme.libs.micromark.Tokenizer;
import guideme.libs.micromark.factory.FactorySpace;

public final class FactoryTitle {
    public static State create(Tokenizer.Effects effects, State ok, State nok, String type, String markerType, String stringType) {
        return new StateMachine(effects, ok, nok, type, markerType, stringType)::start;
    }

    private static class StateMachine {
        private Tokenizer.Effects effects;
        private State ok;
        private State nok;
        private String type;
        private String markerType;
        private String stringType;
        private int marker;

        public StateMachine(Tokenizer.Effects effects, State ok, State nok, String type, String markerType, String stringType) {
            this.effects = effects;
            this.ok = ok;
            this.nok = nok;
            this.type = type;
            this.markerType = markerType;
            this.stringType = stringType;
        }

        public State start(int code) {
            Assert.check(code == 34 || code == 39 || code == 40, "expected `\"`, `'`, or `(`");
            this.effects.enter(this.type);
            this.effects.enter(this.markerType);
            this.effects.consume(code);
            this.effects.exit(this.markerType);
            this.marker = code == 40 ? 41 : code;
            return this::atFirstTitleBreak;
        }

        private State atFirstTitleBreak(int code) {
            if (code == this.marker) {
                this.effects.enter(this.markerType);
                this.effects.consume(code);
                this.effects.exit(this.markerType);
                this.effects.exit(this.type);
                return this.ok;
            }
            this.effects.enter(this.stringType);
            return this.atTitleBreak(code);
        }

        private State atTitleBreak(int code) {
            if (code == this.marker) {
                this.effects.exit(this.stringType);
                return this.atFirstTitleBreak(this.marker);
            }
            if (code == Integer.MIN_VALUE) {
                return this.nok.step(code);
            }
            if (CharUtil.markdownLineEnding(code)) {
                this.effects.enter("lineEnding");
                this.effects.consume(code);
                this.effects.exit("lineEnding");
                return FactorySpace.create(this.effects, this::atTitleBreak, "linePrefix");
            }
            Token tokenFields = new Token();
            tokenFields.contentType = ContentType.STRING;
            this.effects.enter("chunkString", tokenFields);
            return this.title(code);
        }

        private State title(int code) {
            if (code == this.marker || code == Integer.MIN_VALUE || CharUtil.markdownLineEnding(code)) {
                this.effects.exit("chunkString");
                return this.atTitleBreak(code);
            }
            this.effects.consume(code);
            return code == 92 ? this::titleEscape : this::title;
        }

        private State titleEscape(int code) {
            if (code == this.marker || code == 92) {
                this.effects.consume(code);
                return this::title;
            }
            return this.title(code);
        }
    }
}

