/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark;

import guideme.libs.micromark.CharUtil;
import guideme.libs.micromark.Construct;
import guideme.libs.micromark.ContentType;
import guideme.libs.micromark.InitialConstruct;
import guideme.libs.micromark.ListUtils;
import guideme.libs.micromark.Point;
import guideme.libs.micromark.State;
import guideme.libs.micromark.Token;
import guideme.libs.micromark.TokenizeContext;
import guideme.libs.micromark.Tokenizer;
import guideme.libs.micromark.factory.FactorySpace;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class InitializeDocument {
    public static final InitialConstruct document = new InitialConstruct();
    public static final Construct containerConstruct;

    private static State tokenizeContainer(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
        return FactorySpace.create(effects, effects.attempt.hook(context.getParser().constructs.document, ok, nok), "linePrefix", context.getParser().constructs.nullDisable.contains("codeIndented") ? Integer.MAX_VALUE : 4);
    }

    static {
        InitializeDocument.document.tokenize = (context, effects, ok, nok) -> new StateMachine(context, effects)::start;
        containerConstruct = new Construct();
        InitializeDocument.containerConstruct.tokenize = InitializeDocument::tokenizeContainer;
    }

    private static class StateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        private final List<StackItem> stack = new ArrayList<StackItem>();
        private int continued = 0;
        @Nullable
        private TokenizeContext childFlow;
        @Nullable
        private Token childToken;
        private int lineStartOffset;

        public StateMachine(TokenizeContext context, Tokenizer.Effects effects) {
            this.context = context;
            this.effects = effects;
        }

        public State start(int code) {
            if (this.continued < this.stack.size()) {
                StackItem item = this.stack.get(this.continued);
                this.context.setContainerState(item.stackState());
                if (item.construct.continuation == null) {
                    throw new IllegalStateException("expected 'continuation' to be defined on container construct");
                }
                return this.effects.attempt.hook(item.construct().continuation, this::documentContinue, this::checkNewContainers).step(code);
            }
            return this.checkNewContainers(code);
        }

        private State documentContinue(int code) {
            if (this.context.getContainerState() == null) {
                throw new IllegalStateException("expected 'containerState' to be defined after continuation");
            }
            ++this.continued;
            if (Boolean.TRUE.equals(this.context.getContainerState().get("_closeFlow"))) {
                int index;
                int indexBeforeExits;
                this.context.getContainerState().remove("_closeFlow");
                if (this.childFlow != null) {
                    this.closeFlow();
                }
                int indexBeforeFlow = indexBeforeExits = this.context.getEvents().size();
                Point point = null;
                while (indexBeforeFlow-- > 0) {
                    Tokenizer.Event event = this.context.getEvents().get(indexBeforeFlow);
                    if (event.type() != Tokenizer.EventType.EXIT || !event.token().type.equals("chunkFlow")) continue;
                    point = event.token().end;
                    break;
                }
                if (point == null) {
                    throw new IllegalStateException("could not find previous flow chunk");
                }
                this.exitContainers(this.continued);
                for (index = indexBeforeExits; index < this.context.getEvents().size(); ++index) {
                    this.context.getEvents().get((int)index).token().end = point;
                }
                List<Tokenizer.Event> eventsToMove = ListUtils.slice(this.context.getEvents(), indexBeforeExits);
                this.context.getEvents().addAll(indexBeforeFlow + 1, eventsToMove);
                ListUtils.setLength(this.context.getEvents(), index);
                return this.checkNewContainers(code);
            }
            return this.start(code);
        }

        private State checkNewContainers(int code) {
            if (this.continued == this.stack.size()) {
                if (this.childFlow == null) {
                    return this.documentContinued(code);
                }
                if (this.childFlow.getCurrentConstruct() != null && this.childFlow.getCurrentConstruct().concrete) {
                    return this.flowStart(code);
                }
                this.context.setInterrupt(this.childFlow.getCurrentConstruct() != null && !this.childFlow.isGfmTableDynamicInterruptHack());
            }
            this.context.setContainerState(new Tokenizer.ContainerState());
            return this.effects.check.hook(containerConstruct, this::thereIsANewContainer, this::thereIsNoNewContainer).step(code);
        }

        private State thereIsANewContainer(int code) {
            if (this.childFlow != null) {
                this.closeFlow();
            }
            this.exitContainers(this.continued);
            return this.documentContinued(code);
        }

        private State thereIsNoNewContainer(int code) {
            this.context.getParser().lazy.put(this.context.now().line(), this.continued != this.stack.size());
            this.lineStartOffset = this.context.now().offset();
            return this.flowStart(code);
        }

        private State documentContinued(int code) {
            this.context.setContainerState(new Tokenizer.ContainerState());
            return this.effects.attempt.hook(containerConstruct, this::containerContinue, this::flowStart).step(code);
        }

        private State containerContinue(int code) {
            if (this.context.getCurrentConstruct() == null) {
                throw new IllegalStateException("expected 'currentConstruct' to be defined on tokenizer");
            }
            if (this.context.getContainerState() == null) {
                throw new IllegalStateException("expected 'containerState' to be defined on tokenizer");
            }
            ++this.continued;
            this.stack.add(new StackItem(this.context.getCurrentConstruct(), this.context.getContainerState()));
            return this.documentContinued(code);
        }

        private State flowStart(int code) {
            if (code == Integer.MIN_VALUE) {
                if (this.childFlow != null) {
                    this.closeFlow();
                }
                this.exitContainers(0);
                this.effects.consume(code);
                return null;
            }
            if (this.childFlow == null) {
                this.childFlow = this.context.getParser().flow.create(this.context.now());
            }
            Token token = new Token();
            token.contentType = ContentType.FLOW;
            token.previous = this.childToken;
            token._tokenizer = this.childFlow;
            this.effects.enter("chunkFlow", token);
            return this.flowContinue(code);
        }

        private State flowContinue(int code) {
            if (code == Integer.MIN_VALUE) {
                this.writeToChild(this.effects.exit("chunkFlow"), true);
                this.exitContainers(0);
                this.effects.consume(code);
                return null;
            }
            if (CharUtil.markdownLineEnding(code)) {
                this.effects.consume(code);
                this.writeToChild(this.effects.exit("chunkFlow"), false);
                this.continued = 0;
                this.context.setInterrupt(false);
                return this::start;
            }
            this.effects.consume(code);
            return this::flowContinue;
        }

        private void writeToChild(Token token, boolean eof) {
            if (this.childFlow == null) {
                throw new IllegalStateException("expected 'childFlow' to be defined when continuing");
            }
            List<Object> stream = this.context.sliceStream(token);
            if (eof) {
                stream.add(Integer.MIN_VALUE);
            }
            token.previous = this.childToken;
            if (this.childToken != null) {
                this.childToken.next = token;
            }
            this.childToken = token;
            this.childFlow.defineSkip(token.start);
            this.childFlow.write(stream);
            if (this.context.getParser().isLazyLine(token.start.line())) {
                int indexBeforeExits;
                int index = this.childFlow.getEvents().size();
                while (index-- > 0) {
                    Token childFlowToken = this.childFlow.getEvents().get(index).token();
                    if (childFlowToken.start.offset() >= this.lineStartOffset || childFlowToken.end != null && childFlowToken.end.offset() <= this.lineStartOffset) continue;
                    return;
                }
                int indexBeforeFlow = indexBeforeExits = this.context.getEvents().size();
                boolean seen = false;
                Point point = null;
                while (indexBeforeFlow-- > 0) {
                    Tokenizer.Event event = this.context.getEvents().get(indexBeforeFlow);
                    if (event.type() != Tokenizer.EventType.EXIT || !event.token().type.equals("chunkFlow")) continue;
                    if (seen) {
                        point = event.token().end;
                        break;
                    }
                    seen = true;
                }
                if (point == null) {
                    throw new IllegalStateException("could not find previous flow chunk");
                }
                this.exitContainers(this.continued);
                for (index = indexBeforeExits; index < this.context.getEvents().size(); ++index) {
                    this.context.getEvents().get((int)index).token().end = point;
                }
                List<Tokenizer.Event> eventsToMove = ListUtils.slice(this.context.getEvents(), indexBeforeExits);
                this.context.getEvents().addAll(indexBeforeFlow + 1, eventsToMove);
                ListUtils.setLength(this.context.getEvents(), index);
            }
        }

        private void exitContainers(int size) {
            int index = this.stack.size();
            while (index-- > size) {
                StackItem entry = this.stack.get(index);
                this.context.setContainerState(entry.stackState());
                if (entry.construct.exit == null) {
                    throw new IllegalStateException("expected 'exit' to be defined on container construct");
                }
                entry.construct.exit.exit(this.context, this.effects);
            }
            ListUtils.setLength(this.stack, size);
        }

        private void closeFlow() {
            if (this.context.getContainerState() == null) {
                throw new IllegalStateException("expected 'containerState' to be defined when closing flow");
            }
            if (this.childFlow == null) {
                throw new IllegalStateException("expected 'childFlow' to be defined when closing it");
            }
            this.childFlow.write(List.of(Integer.valueOf(Integer.MIN_VALUE)));
            this.childToken = null;
            this.childFlow = null;
            this.context.getContainerState().remove("_closeFlow");
        }
    }

    record StackItem(Construct construct, Tokenizer.ContainerState stackState) {
    }
}

