/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util.automaton;

import guideme.internal.shaded.lucene.internal.hppc.BitMixer;
import guideme.internal.shaded.lucene.internal.hppc.IntHashSet;
import guideme.internal.shaded.lucene.internal.hppc.IntObjectHashMap;
import guideme.internal.shaded.lucene.util.ArrayUtil;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.BytesRefBuilder;
import guideme.internal.shaded.lucene.util.FixedBitSet;
import guideme.internal.shaded.lucene.util.IntsRef;
import guideme.internal.shaded.lucene.util.IntsRefBuilder;
import guideme.internal.shaded.lucene.util.RamUsageEstimator;
import guideme.internal.shaded.lucene.util.automaton.Automaton;
import guideme.internal.shaded.lucene.util.automaton.FrozenIntSet;
import guideme.internal.shaded.lucene.util.automaton.StateSet;
import guideme.internal.shaded.lucene.util.automaton.TooComplexToDeterminizeException;
import guideme.internal.shaded.lucene.util.automaton.Transition;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public final class Operations {
    private Operations() {
    }

    public static Automaton concatenate(List<Automaton> l) {
        Automaton result = new Automaton();
        for (Automaton a : l) {
            if (a.getNumStates() == 0) {
                result.finishState();
                return result;
            }
            int numStates = a.getNumStates();
            for (int s = 0; s < numStates; ++s) {
                result.createState();
            }
        }
        int stateOffset = 0;
        Transition t = new Transition();
        for (int i = 0; i < l.size(); ++i) {
            Automaton a = l.get(i);
            int numStates = a.getNumStates();
            Automaton nextA = i == l.size() - 1 ? null : l.get(i + 1);
            block3: for (int s = 0; s < numStates; ++s) {
                int numTransitions = a.initTransition(s, t);
                for (int j = 0; j < numTransitions; ++j) {
                    a.getNextTransition(t);
                    result.addTransition(stateOffset + s, stateOffset + t.dest, t.min, t.max);
                }
                if (!a.isAccept(s)) continue;
                Automaton followA = nextA;
                int followOffset = stateOffset;
                int upto = i + 1;
                while (followA != null) {
                    numTransitions = followA.initTransition(0, t);
                    for (int j = 0; j < numTransitions; ++j) {
                        followA.getNextTransition(t);
                        result.addTransition(stateOffset + s, followOffset + numStates + t.dest, t.min, t.max);
                    }
                    if (!followA.isAccept(0)) continue block3;
                    followOffset += followA.getNumStates();
                    followA = upto == l.size() - 1 ? null : l.get(upto + 1);
                    ++upto;
                }
                result.setAccept(stateOffset + s, true);
            }
            stateOffset += numStates;
        }
        if (result.getNumStates() == 0) {
            result.createState();
        }
        result.finishState();
        return result;
    }

    public static boolean hasDeadStates(Automaton a) {
        BitSet liveStates = Operations.getLiveStates(a);
        int numLive = liveStates.cardinality();
        int numStates = a.getNumStates();
        assert (numLive <= numStates) : "numLive=" + numLive + " numStates=" + numStates + " " + liveStates;
        return numLive < numStates;
    }

    public static boolean hasDeadStatesFromInitial(Automaton a) {
        BitSet reachableFromInitial = Operations.getLiveStatesFromInitial(a);
        BitSet reachableFromAccept = Operations.getLiveStatesToAccept(a);
        reachableFromInitial.andNot(reachableFromAccept);
        return !reachableFromInitial.isEmpty();
    }

    public static Automaton determinize(Automaton a, int workLimit) {
        if (a.isDeterministic()) {
            return a;
        }
        if (a.getNumStates() <= 1) {
            return a;
        }
        Automaton.Builder b = new Automaton.Builder();
        FrozenIntSet initialset = new FrozenIntSet(new int[]{0}, BitMixer.mix(0) + 1, 0);
        b.createState();
        ArrayDeque<FrozenIntSet> worklist = new ArrayDeque<FrozenIntSet>();
        HashMap<FrozenIntSet, Integer> newstate = new HashMap<FrozenIntSet, Integer>();
        worklist.add(initialset);
        b.setAccept(0, a.isAccept(0));
        newstate.put(initialset, 0);
        PointTransitionSet points = new PointTransitionSet();
        StateSet statesSet = new StateSet(5);
        Transition t = new Transition();
        long effortSpent = 0L;
        long effortLimit = (long)workLimit * 10L;
        while (worklist.size() > 0) {
            FrozenIntSet s = (FrozenIntSet)worklist.removeFirst();
            if ((effortSpent += (long)s.values.length) >= effortLimit) {
                throw new TooComplexToDeterminizeException(a, workLimit);
            }
            for (int i = 0; i < s.values.length; ++i) {
                int s0 = s.values[i];
                int numTransitions = a.getNumTransitions(s0);
                a.initTransition(s0, t);
                for (int j = 0; j < numTransitions; ++j) {
                    a.getNextTransition(t);
                    points.add(t);
                }
            }
            if (points.count == 0) continue;
            points.sort();
            int lastPoint = -1;
            int accCount = 0;
            int r = s.state;
            for (int i = 0; i < points.count; ++i) {
                int dest;
                int j;
                int point = points.points[i].point;
                if (statesSet.size() > 0) {
                    assert (lastPoint != -1);
                    Integer q = (Integer)newstate.get(statesSet);
                    if (q == null) {
                        q = b.createState();
                        FrozenIntSet p = statesSet.freeze(q);
                        worklist.add(p);
                        b.setAccept(q, accCount > 0);
                        newstate.put(p, q);
                    } else assert (accCount > 0 == b.isAccept(q)) : "accCount=" + accCount + " vs existing accept=" + b.isAccept(q) + " states=" + statesSet;
                    b.addTransition(r, q, lastPoint, point - 1);
                }
                int[] transitions = points.points[i].ends.transitions;
                int limit = points.points[i].ends.next;
                for (j = 0; j < limit; j += 3) {
                    dest = transitions[j];
                    statesSet.decr(dest);
                    accCount -= a.isAccept(dest) ? 1 : 0;
                }
                points.points[i].ends.next = 0;
                transitions = points.points[i].starts.transitions;
                limit = points.points[i].starts.next;
                for (j = 0; j < limit; j += 3) {
                    dest = transitions[j];
                    statesSet.incr(dest);
                    accCount += a.isAccept(dest) ? 1 : 0;
                }
                lastPoint = point;
                points.points[i].starts.next = 0;
            }
            points.reset();
            assert (statesSet.size() == 0) : "size=" + statesSet.size();
        }
        Automaton result = b.finish();
        assert (result.isDeterministic());
        return result;
    }

    public static boolean isEmpty(Automaton a) {
        if (a.getNumStates() == 0) {
            return true;
        }
        if (!a.isAccept(0) && a.getNumTransitions(0) == 0) {
            return true;
        }
        if (a.isAccept(0)) {
            return false;
        }
        ArrayDeque<Integer> workList = new ArrayDeque<Integer>();
        BitSet seen = new BitSet(a.getNumStates());
        workList.add(0);
        seen.set(0);
        Transition t = new Transition();
        while (!workList.isEmpty()) {
            int state = (Integer)workList.removeFirst();
            if (a.isAccept(state)) {
                return false;
            }
            int count = a.initTransition(state, t);
            for (int i = 0; i < count; ++i) {
                a.getNextTransition(t);
                if (seen.get(t.dest)) continue;
                workList.add(t.dest);
                seen.set(t.dest);
            }
        }
        return true;
    }

    public static boolean isTotal(Automaton a) {
        return Operations.isTotal(a, 0, 0x10FFFF);
    }

    public static boolean isTotal(Automaton a, int minAlphabet, int maxAlphabet) {
        if (a.isAccept(0) && a.getNumTransitions(0) == 1) {
            Transition t = new Transition();
            a.getTransition(0, 0, t);
            return t.dest == 0 && t.min == minAlphabet && t.max == maxAlphabet;
        }
        return false;
    }

    private static BitSet getLiveStates(Automaton a) {
        BitSet live = Operations.getLiveStatesFromInitial(a);
        live.and(Operations.getLiveStatesToAccept(a));
        return live;
    }

    private static BitSet getLiveStatesFromInitial(Automaton a) {
        int numStates = a.getNumStates();
        BitSet live = new BitSet(numStates);
        if (numStates == 0) {
            return live;
        }
        ArrayDeque<Integer> workList = new ArrayDeque<Integer>();
        live.set(0);
        workList.add(0);
        Transition t = new Transition();
        while (!workList.isEmpty()) {
            int s = (Integer)workList.removeFirst();
            int count = a.initTransition(s, t);
            for (int i = 0; i < count; ++i) {
                a.getNextTransition(t);
                if (live.get(t.dest)) continue;
                live.set(t.dest);
                workList.add(t.dest);
            }
        }
        return live;
    }

    private static BitSet getLiveStatesToAccept(Automaton a) {
        int s;
        int s2;
        Automaton.Builder builder = new Automaton.Builder();
        Transition t = new Transition();
        int numStates = a.getNumStates();
        for (s2 = 0; s2 < numStates; ++s2) {
            builder.createState();
        }
        for (s2 = 0; s2 < numStates; ++s2) {
            int count = a.initTransition(s2, t);
            for (int i = 0; i < count; ++i) {
                a.getNextTransition(t);
                builder.addTransition(t.dest, s2, t.min, t.max);
            }
        }
        Automaton a2 = builder.finish();
        ArrayDeque<Integer> workList = new ArrayDeque<Integer>();
        BitSet live = new BitSet(numStates);
        BitSet acceptBits = a.getAcceptStates();
        for (s = 0; s < numStates && (s = acceptBits.nextSetBit(s)) != -1; ++s) {
            live.set(s);
            workList.add(s);
        }
        while (!workList.isEmpty()) {
            s = (Integer)workList.removeFirst();
            int count = a2.initTransition(s, t);
            for (int i = 0; i < count; ++i) {
                a2.getNextTransition(t);
                if (live.get(t.dest)) continue;
                live.set(t.dest);
                workList.add(t.dest);
            }
        }
        return live;
    }

    public static Automaton removeDeadStates(Automaton a) {
        int numStates = a.getNumStates();
        BitSet liveSet = Operations.getLiveStates(a);
        int[] map = new int[numStates];
        Automaton result = new Automaton();
        for (int i = 0; i < numStates; ++i) {
            if (!liveSet.get(i)) continue;
            map[i] = result.createState();
            result.setAccept(map[i], a.isAccept(i));
        }
        Transition t = new Transition();
        for (int i = 0; i < numStates; ++i) {
            if (!liveSet.get(i)) continue;
            int numTransitions = a.initTransition(i, t);
            for (int j = 0; j < numTransitions; ++j) {
                a.getNextTransition(t);
                if (!liveSet.get(t.dest)) continue;
                result.addTransition(map[i], map[t.dest], t.min, t.max);
            }
        }
        result.finishState();
        assert (!Operations.hasDeadStates(result));
        return result;
    }

    public static boolean isFinite(Automaton a) {
        if (a.getNumStates() == 0) {
            return true;
        }
        return Operations.isFinite(new Transition(), a, 0, new BitSet(a.getNumStates()), new BitSet(a.getNumStates()), 0);
    }

    private static boolean isFinite(Transition scratch, Automaton a, int state, BitSet path, BitSet visited, int level) {
        if (level > 1000) {
            throw new IllegalArgumentException("input automaton is too large: " + level);
        }
        path.set(state);
        int numTransitions = a.initTransition(state, scratch);
        for (int t = 0; t < numTransitions; ++t) {
            a.getTransition(state, t, scratch);
            if (!path.get(scratch.dest) && (visited.get(scratch.dest) || Operations.isFinite(scratch, a, scratch.dest, path, visited, level + 1))) continue;
            return false;
        }
        path.clear(state);
        visited.set(state);
        return true;
    }

    public static String getCommonPrefix(Automaton a) {
        if (Operations.hasDeadStatesFromInitial(a)) {
            throw new IllegalArgumentException("input automaton has dead states");
        }
        if (Operations.isEmpty(a)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Transition scratch = new Transition();
        FixedBitSet visited = new FixedBitSet(a.getNumStates());
        FixedBitSet current = new FixedBitSet(a.getNumStates());
        FixedBitSet next = new FixedBitSet(a.getNumStates());
        current.set(0);
        block0: while (true) {
            int label = -1;
            int state = current.nextSetBit(0);
            while (state != Integer.MAX_VALUE) {
                visited.set(state);
                if (a.isAccept(state)) break block0;
                for (int transition = 0; transition < a.getNumTransitions(state); ++transition) {
                    a.getTransition(state, transition, scratch);
                    if (label == -1) {
                        label = scratch.min;
                    }
                    if (scratch.min != scratch.max || scratch.min != label) break block0;
                    next.set(scratch.dest);
                }
                state = state + 1 >= current.length() ? Integer.MAX_VALUE : current.nextSetBit(state + 1);
            }
            assert (label != -1) : "we should not get here since we checked no dead-end states up front!?";
            builder.appendCodePoint(label);
            FixedBitSet tmp = current;
            current = next;
            next = tmp;
            next.clear();
        }
        return builder.toString();
    }

    public static BytesRef getCommonPrefixBytesRef(Automaton a) {
        String prefix = Operations.getCommonPrefix(a);
        BytesRefBuilder builder = new BytesRefBuilder();
        for (int i = 0; i < prefix.length(); ++i) {
            char ch = prefix.charAt(i);
            if (ch > '\u00ff') {
                throw new IllegalStateException("automaton is not binary");
            }
            builder.append((byte)ch);
        }
        return builder.get();
    }

    public static IntsRef getSingleton(Automaton a) {
        block5: {
            if (!a.isDeterministic()) {
                throw new IllegalArgumentException("input automaton must be deterministic");
            }
            IntsRefBuilder builder = new IntsRefBuilder();
            IntHashSet visited = new IntHashSet();
            int s = 0;
            Transition t = new Transition();
            while (true) {
                visited.add(s);
                if (a.isAccept(s)) break;
                if (a.getNumTransitions(s) == 1) {
                    a.getTransition(s, 0, t);
                    if (t.min == t.max && !visited.contains(t.dest)) {
                        builder.append(t.min);
                        s = t.dest;
                        continue;
                    }
                }
                break block5;
                break;
            }
            if (a.getNumTransitions(s) == 0) {
                return builder.get();
            }
        }
        return null;
    }

    public static BytesRef getCommonSuffixBytesRef(Automaton a) {
        Automaton r = Operations.removeDeadStates(Operations.reverse(a));
        BytesRef ref = Operations.getCommonPrefixBytesRef(r);
        Operations.reverseBytes(ref);
        return ref;
    }

    private static void reverseBytes(BytesRef ref) {
        if (ref.length <= 1) {
            return;
        }
        int num = ref.length >> 1;
        for (int i = ref.offset; i < ref.offset + num; ++i) {
            byte b = ref.bytes[i];
            ref.bytes[i] = ref.bytes[ref.offset * 2 + ref.length - i - 1];
            ref.bytes[ref.offset * 2 + ref.length - i - 1] = b;
        }
    }

    public static Automaton reverse(Automaton a) {
        return Operations.reverse(a, null);
    }

    public static Automaton reverse(Automaton a, Set<Integer> initialStates) {
        if (Operations.isEmpty(a)) {
            return new Automaton();
        }
        int numStates = a.getNumStates();
        Automaton.Builder builder = new Automaton.Builder();
        builder.createState();
        for (int s = 0; s < numStates; ++s) {
            builder.createState();
        }
        builder.setAccept(1, true);
        Transition t = new Transition();
        for (int s = 0; s < numStates; ++s) {
            int numTransitions = a.getNumTransitions(s);
            a.initTransition(s, t);
            for (int i = 0; i < numTransitions; ++i) {
                a.getNextTransition(t);
                builder.addTransition(t.dest + 1, s + 1, t.min, t.max);
            }
        }
        Automaton result = builder.finish();
        BitSet acceptStates = a.getAcceptStates();
        for (int s = 0; s < numStates && (s = acceptStates.nextSetBit(s)) != -1; ++s) {
            result.addEpsilon(0, s + 1);
            if (initialStates == null) continue;
            initialStates.add(s + 1);
        }
        result.finishState();
        return result;
    }

    public static int[] topoSortStates(Automaton a) {
        if (a.getNumStates() == 0) {
            return new int[0];
        }
        int numStates = a.getNumStates();
        int[] states = new int[numStates];
        int upto = Operations.topoSortStates(a, states);
        if (upto < states.length) {
            int[] newStates = new int[upto];
            System.arraycopy(states, 0, newStates, 0, upto);
            states = newStates;
        }
        for (int i = 0; i < states.length / 2; ++i) {
            int s = states[i];
            states[i] = states[states.length - 1 - i];
            states[states.length - 1 - i] = s;
        }
        return states;
    }

    private static int topoSortStates(Automaton a, int[] states) {
        BitSet onStack = new BitSet(a.getNumStates());
        BitSet visited = new BitSet(a.getNumStates());
        ArrayDeque<Integer> stack = new ArrayDeque<Integer>();
        stack.push(0);
        int upto = 0;
        Transition t = new Transition();
        while (!stack.isEmpty()) {
            int state = (Integer)stack.peek();
            int count = a.initTransition(state, t);
            boolean pushed = false;
            for (int i = 0; i < count; ++i) {
                a.getNextTransition(t);
                if (!visited.get(t.dest)) {
                    visited.set(t.dest);
                    stack.push(t.dest);
                    onStack.set(state);
                    pushed = true;
                    break;
                }
                if (!onStack.get(t.dest)) continue;
                throw new IllegalArgumentException("Input automaton has a cycle.");
            }
            if (pushed) continue;
            onStack.clear(state);
            stack.pop();
            states[upto] = state;
            ++upto;
        }
        return upto;
    }

    private static final class PointTransitionSet {
        int count;
        PointTransitions[] points = new PointTransitions[5];
        private final IntObjectHashMap<PointTransitions> map = new IntObjectHashMap();
        private boolean useHash = false;

        private PointTransitionSet() {
        }

        private PointTransitions next(int point) {
            PointTransitions points0;
            if (this.count == this.points.length) {
                PointTransitions[] newArray = new PointTransitions[ArrayUtil.oversize(1 + this.count, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
                System.arraycopy(this.points, 0, newArray, 0, this.count);
                this.points = newArray;
            }
            if ((points0 = this.points[this.count]) == null) {
                points0 = this.points[this.count] = new PointTransitions();
            }
            points0.reset(point);
            ++this.count;
            return points0;
        }

        private PointTransitions find(int point) {
            if (this.useHash) {
                Integer pi = point;
                PointTransitions p = this.map.get(pi);
                if (p == null) {
                    p = this.next(point);
                    this.map.put(pi, p);
                }
                return p;
            }
            for (int i = 0; i < this.count; ++i) {
                if (this.points[i].point != point) continue;
                return this.points[i];
            }
            PointTransitions p = this.next(point);
            if (this.count == 30) {
                assert (this.map.size() == 0);
                for (int i = 0; i < this.count; ++i) {
                    this.map.put(this.points[i].point, this.points[i]);
                }
                this.useHash = true;
            }
            return p;
        }

        public void reset() {
            if (this.useHash) {
                this.map.clear();
                this.useHash = false;
            }
            this.count = 0;
        }

        public void sort() {
            if (this.count > 1) {
                ArrayUtil.timSort((Comparable[])this.points, (int)0, (int)this.count);
            }
        }

        public void add(Transition t) {
            this.find((int)t.min).starts.add(t);
            this.find((int)(1 + t.max)).ends.add(t);
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < this.count; ++i) {
                if (i > 0) {
                    s.append(' ');
                }
                s.append(this.points[i].point).append(':').append(this.points[i].starts.next / 3).append(',').append(this.points[i].ends.next / 3);
            }
            return s.toString();
        }
    }

    private static final class PointTransitions
    implements Comparable<PointTransitions> {
        int point;
        final TransitionList ends = new TransitionList();
        final TransitionList starts = new TransitionList();

        private PointTransitions() {
        }

        @Override
        public int compareTo(PointTransitions other) {
            return this.point - other.point;
        }

        public void reset(int point) {
            this.point = point;
            this.ends.next = 0;
            this.starts.next = 0;
        }

        public boolean equals(Object other) {
            return ((PointTransitions)other).point == this.point;
        }

        public int hashCode() {
            return this.point;
        }
    }

    private static final class TransitionList {
        int[] transitions = new int[3];
        int next;

        private TransitionList() {
        }

        public void add(Transition t) {
            if (this.transitions.length < this.next + 3) {
                this.transitions = ArrayUtil.grow(this.transitions, this.next + 3);
            }
            this.transitions[this.next] = t.dest;
            this.transitions[this.next + 1] = t.min;
            this.transitions[this.next + 2] = t.max;
            this.next += 3;
        }
    }
}

