/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util;

import guideme.internal.shaded.lucene.internal.vectorization.VectorUtilSupport;
import guideme.internal.shaded.lucene.internal.vectorization.VectorizationProvider;
import guideme.internal.shaded.lucene.util.Constants;

public final class VectorUtil {
    private static final VectorUtilSupport IMPL = VectorizationProvider.getInstance().getVectorUtilSupport();
    static final boolean XOR_BIT_COUNT_STRIDE_AS_INT = Constants.OS_ARCH.equals("aarch64");

    private VectorUtil() {
    }

    public static float dotProduct(float[] a, float[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("vector dimensions differ: " + a.length + "!=" + b.length);
        }
        float r = IMPL.dotProduct(a, b);
        assert (Float.isFinite(r));
        return r;
    }

    public static float cosine(float[] a, float[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("vector dimensions differ: " + a.length + "!=" + b.length);
        }
        float r = IMPL.cosine(a, b);
        assert (Float.isFinite(r));
        return r;
    }

    public static float cosine(byte[] a, byte[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("vector dimensions differ: " + a.length + "!=" + b.length);
        }
        return IMPL.cosine(a, b);
    }

    public static float squareDistance(float[] a, float[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("vector dimensions differ: " + a.length + "!=" + b.length);
        }
        float r = IMPL.squareDistance(a, b);
        assert (Float.isFinite(r));
        return r;
    }

    public static int squareDistance(byte[] a, byte[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("vector dimensions differ: " + a.length + "!=" + b.length);
        }
        return IMPL.squareDistance(a, b);
    }

    public static int dotProduct(byte[] a, byte[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("vector dimensions differ: " + a.length + "!=" + b.length);
        }
        return IMPL.dotProduct(a, b);
    }

    public static float dotProductScore(byte[] a, byte[] b) {
        float denom = a.length * 32768;
        return 0.5f + (float)VectorUtil.dotProduct(a, b) / denom;
    }

    public static float scaleMaxInnerProductScore(float vectorDotProductSimilarity) {
        if (vectorDotProductSimilarity < 0.0f) {
            return 1.0f / (1.0f + -1.0f * vectorDotProductSimilarity);
        }
        return vectorDotProductSimilarity + 1.0f;
    }
}

