/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util;

import guideme.internal.shaded.lucene.store.Directory;
import guideme.internal.shaded.lucene.util.Constants;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

public final class IOUtils {
    public static final String UTF_8 = StandardCharsets.UTF_8.name();

    private IOUtils() {
    }

    public static void close(Closeable ... objects) throws IOException {
        IOUtils.close(Arrays.asList(objects));
    }

    public static void close(Iterable<? extends Closeable> objects) throws IOException {
        Throwable th = null;
        for (Closeable closeable : objects) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Throwable t) {
                th = IOUtils.useOrSuppress(th, t);
            }
        }
        if (th != null) {
            throw IOUtils.rethrowAlways(th);
        }
    }

    public static void closeWhileHandlingException(Closeable ... objects) {
        IOUtils.closeWhileHandlingException(Arrays.asList(objects));
    }

    public static void closeWhileHandlingException(Iterable<? extends Closeable> objects) {
        Throwable firstError = null;
        Throwable firstThrowable = null;
        for (Closeable closeable : objects) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (VirtualMachineError e) {
                firstError = IOUtils.useOrSuppress(firstError, e);
            }
            catch (Throwable t) {
                firstThrowable = IOUtils.useOrSuppress(firstThrowable, t);
            }
        }
        if (firstError != null) {
            if (firstThrowable != null) {
                firstError.addSuppressed(firstThrowable);
            }
            throw firstError;
        }
    }

    public static Reader getDecodingReader(InputStream stream, Charset charSet) {
        CharsetDecoder charSetDecoder = charSet.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        return new BufferedReader(new InputStreamReader(stream, charSetDecoder));
    }

    public static <T> T requireResourceNonNull(T resource, String name) throws IOException {
        if (resource == null) {
            throw new FileNotFoundException("The resource '" + name + "' was not found.");
        }
        return resource;
    }

    public static void deleteFilesIgnoringExceptions(Directory dir, Collection<String> files) {
        for (String name : files) {
            try {
                dir.deleteFile(name);
            }
            catch (Throwable throwable) {}
        }
    }

    public static void deleteFilesIgnoringExceptions(Directory dir, String ... files) {
        IOUtils.deleteFilesIgnoringExceptions(dir, Arrays.asList(files));
    }

    public static void deleteFiles(Directory dir, Collection<String> names) throws IOException {
        Throwable th = null;
        for (String name : names) {
            if (name == null) continue;
            try {
                dir.deleteFile(name);
            }
            catch (Throwable t) {
                th = IOUtils.useOrSuppress(th, t);
            }
        }
        if (th != null) {
            throw IOUtils.rethrowAlways(th);
        }
    }

    public static Error rethrowAlways(Throwable th) throws IOException, RuntimeException {
        if (th == null) {
            throw new AssertionError((Object)"rethrow argument must not be null.");
        }
        if (th instanceof IOException) {
            throw (IOException)th;
        }
        if (th instanceof RuntimeException) {
            throw (RuntimeException)th;
        }
        if (th instanceof Error) {
            throw (Error)th;
        }
        throw new RuntimeException(th);
    }

    public static void fsync(Path fileToSync, boolean isDir) throws IOException {
        if (isDir && Constants.WINDOWS) {
            if (!Files.exists(fileToSync, new LinkOption[0])) {
                throw new NoSuchFileException(fileToSync.toString());
            }
            return;
        }
        try (FileChannel file = FileChannel.open(fileToSync, isDir ? StandardOpenOption.READ : StandardOpenOption.WRITE);){
            try {
                file.force(true);
            }
            catch (IOException e) {
                if (isDir) {
                    assert (!(Constants.LINUX || Constants.MAC_OS_X)) : "On Linux and MacOSX fsyncing a directory should not throw IOException, we just don't want to rely on that in production (undocumented). Got: " + e;
                    if (file != null) {
                        file.close();
                    }
                    return;
                }
                throw e;
            }
        }
    }

    public static <T extends Throwable> T useOrSuppress(T first, T second) {
        if (first == null) {
            return second;
        }
        first.addSuppressed(second);
        return first;
    }

    public static <T> void applyToAll(Collection<T> collection, IOConsumer<T> consumer) throws IOException {
        IOUtils.close(collection.stream().filter(Objects::nonNull).map(t -> () -> consumer.accept(t))::iterator);
    }

    @FunctionalInterface
    @Deprecated(forRemoval=true, since="9.1")
    public static interface IOConsumer<T> {
        public void accept(T var1) throws IOException;
    }
}

