/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.store;

import java.util.zip.Checksum;

public class BufferedChecksum
implements Checksum {
    private final Checksum in;
    private final byte[] buffer;
    private int upto;

    public BufferedChecksum(Checksum in) {
        this(in, 1024);
    }

    public BufferedChecksum(Checksum in, int bufferSize) {
        this.in = in;
        this.buffer = new byte[bufferSize];
    }

    @Override
    public void update(int b) {
        if (this.upto == this.buffer.length) {
            this.flush();
        }
        this.buffer[this.upto++] = (byte)b;
    }

    @Override
    public void update(byte[] b, int off, int len) {
        if (len >= this.buffer.length) {
            this.flush();
            this.in.update(b, off, len);
        } else {
            if (this.upto + len > this.buffer.length) {
                this.flush();
            }
            System.arraycopy(b, off, this.buffer, this.upto, len);
            this.upto += len;
        }
    }

    @Override
    public long getValue() {
        this.flush();
        return this.in.getValue();
    }

    @Override
    public void reset() {
        this.upto = 0;
        this.in.reset();
    }

    private void flush() {
        if (this.upto > 0) {
            this.in.update(this.buffer, 0, this.upto);
        }
        this.upto = 0;
    }
}

