/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.FilteredTermsEnum;
import guideme.internal.shaded.lucene.index.PrefixCodedTerms;
import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.index.Terms;
import guideme.internal.shaded.lucene.index.TermsEnum;
import guideme.internal.shaded.lucene.search.MultiTermQuery;
import guideme.internal.shaded.lucene.search.QueryVisitor;
import guideme.internal.shaded.lucene.util.Accountable;
import guideme.internal.shaded.lucene.util.AttributeSource;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.RamUsageEstimator;
import guideme.internal.shaded.lucene.util.automaton.Automata;
import guideme.internal.shaded.lucene.util.automaton.Automaton;
import guideme.internal.shaded.lucene.util.automaton.ByteRunAutomaton;
import java.io.IOException;
import java.io.UncheckedIOException;

public class TermInSetQuery
extends MultiTermQuery
implements Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(TermInSetQuery.class);
    private final String field;
    private final PrefixCodedTerms termData;
    private final int termDataHashCode;

    @Override
    public long getTermsCount() throws IOException {
        return this.termData.size();
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (!visitor.acceptField(this.field)) {
            return;
        }
        if (this.termData.size() == 1L) {
            visitor.consumeTerms(this, new Term(this.field, this.termData.iterator().next()));
        }
        if (this.termData.size() > 1L) {
            visitor.consumeTermsMatching(this, this.field, this::asByteRunAutomaton);
        }
    }

    private ByteRunAutomaton asByteRunAutomaton() {
        try {
            Automaton a = Automata.makeBinaryStringUnion(this.termData.iterator());
            return new ByteRunAutomaton(a, true, 10000);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((TermInSetQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(TermInSetQuery other) {
        return this.termDataHashCode == other.termDataHashCode && this.termData.equals(other.termData);
    }

    @Override
    public int hashCode() {
        return 31 * this.classHash() + this.termDataHashCode;
    }

    @Override
    public String toString(String defaultField) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.field);
        builder.append(":(");
        PrefixCodedTerms.TermIterator iterator = this.termData.iterator();
        boolean first = true;
        BytesRef term = iterator.next();
        while (term != null) {
            if (!first) {
                builder.append(' ');
            }
            first = false;
            builder.append(Term.toString(term));
            term = iterator.next();
        }
        builder.append(')');
        return builder.toString();
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + this.termData.ramBytesUsed();
    }

    @Override
    protected TermsEnum getTermsEnum(Terms terms, AttributeSource atts) throws IOException {
        return new SetEnum(terms.iterator());
    }

    private class SetEnum
    extends FilteredTermsEnum {
        private final PrefixCodedTerms.TermIterator iterator;
        private BytesRef seekTerm;

        SetEnum(TermsEnum termsEnum) {
            super(termsEnum);
            this.iterator = TermInSetQuery.this.termData.iterator();
            this.seekTerm = this.iterator.next();
        }

        @Override
        protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) throws IOException {
            int cmp = 0;
            while (this.seekTerm != null && (cmp = this.seekTerm.compareTo(term)) < 0) {
                this.seekTerm = this.iterator.next();
            }
            if (this.seekTerm == null) {
                return FilteredTermsEnum.AcceptStatus.END;
            }
            if (cmp == 0) {
                return FilteredTermsEnum.AcceptStatus.YES_AND_SEEK;
            }
            return FilteredTermsEnum.AcceptStatus.NO_AND_SEEK;
        }

        @Override
        protected BytesRef nextSeekTerm(BytesRef currentTerm) throws IOException {
            if (currentTerm == null) {
                return this.seekTerm;
            }
            while (this.seekTerm != null && this.seekTerm.compareTo(currentTerm) <= 0) {
                this.seekTerm = this.iterator.next();
            }
            return this.seekTerm;
        }
    }
}

