/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.LeafSimScorer;
import guideme.internal.shaded.lucene.search.PhraseMatcher;
import guideme.internal.shaded.lucene.search.PhraseScorer;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.Scorer;
import guideme.internal.shaded.lucene.search.Weight;
import guideme.internal.shaded.lucene.search.similarities.Similarity;
import java.io.IOException;

public abstract class PhraseWeight
extends Weight {
    final ScoreMode scoreMode;
    final Similarity.SimScorer stats;
    final Similarity similarity;
    final String field;

    protected PhraseWeight(Query query, String field, IndexSearcher searcher, ScoreMode scoreMode) throws IOException {
        super(query);
        this.scoreMode = scoreMode;
        this.field = field;
        this.similarity = searcher.getSimilarity();
        Similarity.SimScorer stats = this.getStats(searcher);
        if (stats == null) {
            stats = new Similarity.SimScorer(){

                @Override
                public float score(float freq, long norm) {
                    return 1.0f;
                }
            };
        }
        this.stats = stats;
    }

    protected abstract Similarity.SimScorer getStats(IndexSearcher var1) throws IOException;

    protected abstract PhraseMatcher getPhraseMatcher(LeafReaderContext var1, Similarity.SimScorer var2, boolean var3) throws IOException;

    @Override
    public Scorer scorer(LeafReaderContext context) throws IOException {
        PhraseMatcher matcher = this.getPhraseMatcher(context, this.stats, false);
        if (matcher == null) {
            return null;
        }
        LeafSimScorer simScorer = new LeafSimScorer(this.stats, context.reader(), this.field, this.scoreMode.needsScores());
        return new PhraseScorer(this, matcher, this.scoreMode, simScorer);
    }

    @Override
    public boolean isCacheable(LeafReaderContext ctx) {
        return true;
    }
}

