/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.search.BulkScorer;
import guideme.internal.shaded.lucene.search.ConstantScoreScorer;
import guideme.internal.shaded.lucene.search.ConstantScoreWeight;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.LeafCollector;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.QueryVisitor;
import guideme.internal.shaded.lucene.search.ScoreAndDoc;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.Scorer;
import guideme.internal.shaded.lucene.search.Weight;
import guideme.internal.shaded.lucene.util.Bits;
import java.io.IOException;

public final class MatchAllDocsQuery
extends Query {
    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) {
        return new ConstantScoreWeight(this, boost){

            public String toString() {
                return "weight(" + MatchAllDocsQuery.this + ")";
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, DocIdSetIterator.all(context.reader().maxDoc()));
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }

            @Override
            public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                if (!scoreMode.isExhaustive()) {
                    return super.bulkScorer(context);
                }
                final float score = this.score();
                final int maxDoc = context.reader().maxDoc();
                return new BulkScorer(){

                    @Override
                    public int score(LeafCollector collector, Bits acceptDocs, int min, int max) throws IOException {
                        max = Math.min(max, maxDoc);
                        ScoreAndDoc scorer = new ScoreAndDoc();
                        scorer.score = score;
                        collector.setScorer(scorer);
                        for (int doc = min; doc < max; ++doc) {
                            scorer.doc = doc;
                            if (acceptDocs != null && !acceptDocs.get(doc)) continue;
                            collector.collect(doc);
                        }
                        return max == maxDoc ? Integer.MAX_VALUE : max;
                    }

                    @Override
                    public long cost() {
                        return maxDoc;
                    }
                };
            }
        };
    }

    @Override
    public String toString(String field) {
        return "*:*";
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o);
    }

    @Override
    public int hashCode() {
        return this.classHash();
    }

    @Override
    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf(this);
    }
}

