/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.internal.vectorization;

import guideme.internal.shaded.lucene.internal.vectorization.VectorUtilSupport;
import guideme.internal.shaded.lucene.util.Constants;

final class DefaultVectorUtilSupport
implements VectorUtilSupport {
    DefaultVectorUtilSupport() {
    }

    private static float fma(float a, float b, float c) {
        if (Constants.HAS_FAST_SCALAR_FMA) {
            return Math.fma(a, b, c);
        }
        return a * b + c;
    }

    @Override
    public float dotProduct(float[] a, float[] b) {
        int i;
        float res = 0.0f;
        if (a.length > 32) {
            float acc1 = 0.0f;
            float acc2 = 0.0f;
            float acc3 = 0.0f;
            float acc4 = 0.0f;
            int upperBound = a.length & 0xFFFFFFFC;
            for (i = 0; i < upperBound; i += 4) {
                acc1 = DefaultVectorUtilSupport.fma(a[i], b[i], acc1);
                acc2 = DefaultVectorUtilSupport.fma(a[i + 1], b[i + 1], acc2);
                acc3 = DefaultVectorUtilSupport.fma(a[i + 2], b[i + 2], acc3);
                acc4 = DefaultVectorUtilSupport.fma(a[i + 3], b[i + 3], acc4);
            }
            res += acc1 + acc2 + acc3 + acc4;
        }
        while (i < a.length) {
            res = DefaultVectorUtilSupport.fma(a[i], b[i], res);
            ++i;
        }
        return res;
    }

    @Override
    public float cosine(float[] a, float[] b) {
        int i;
        float sum = 0.0f;
        float norm1 = 0.0f;
        float norm2 = 0.0f;
        if (a.length > 32) {
            float sum1 = 0.0f;
            float sum2 = 0.0f;
            float norm1_1 = 0.0f;
            float norm1_2 = 0.0f;
            float norm2_1 = 0.0f;
            float norm2_2 = 0.0f;
            int upperBound = a.length & 0xFFFFFFFE;
            for (i = 0; i < upperBound; i += 2) {
                sum1 = DefaultVectorUtilSupport.fma(a[i], b[i], sum1);
                norm1_1 = DefaultVectorUtilSupport.fma(a[i], a[i], norm1_1);
                norm2_1 = DefaultVectorUtilSupport.fma(b[i], b[i], norm2_1);
                sum2 = DefaultVectorUtilSupport.fma(a[i + 1], b[i + 1], sum2);
                norm1_2 = DefaultVectorUtilSupport.fma(a[i + 1], a[i + 1], norm1_2);
                norm2_2 = DefaultVectorUtilSupport.fma(b[i + 1], b[i + 1], norm2_2);
            }
            sum += sum1 + sum2;
            norm1 += norm1_1 + norm1_2;
            norm2 += norm2_1 + norm2_2;
        }
        while (i < a.length) {
            sum = DefaultVectorUtilSupport.fma(a[i], b[i], sum);
            norm1 = DefaultVectorUtilSupport.fma(a[i], a[i], norm1);
            norm2 = DefaultVectorUtilSupport.fma(b[i], b[i], norm2);
            ++i;
        }
        return (float)((double)sum / Math.sqrt((double)norm1 * (double)norm2));
    }

    @Override
    public float squareDistance(float[] a, float[] b) {
        int i;
        float res = 0.0f;
        if (a.length > 32) {
            float acc1 = 0.0f;
            float acc2 = 0.0f;
            float acc3 = 0.0f;
            float acc4 = 0.0f;
            int upperBound = a.length & 0xFFFFFFFC;
            for (i = 0; i < upperBound; i += 4) {
                float diff1 = a[i] - b[i];
                acc1 = DefaultVectorUtilSupport.fma(diff1, diff1, acc1);
                float diff2 = a[i + 1] - b[i + 1];
                acc2 = DefaultVectorUtilSupport.fma(diff2, diff2, acc2);
                float diff3 = a[i + 2] - b[i + 2];
                acc3 = DefaultVectorUtilSupport.fma(diff3, diff3, acc3);
                float diff4 = a[i + 3] - b[i + 3];
                acc4 = DefaultVectorUtilSupport.fma(diff4, diff4, acc4);
            }
            res += acc1 + acc2 + acc3 + acc4;
        }
        while (i < a.length) {
            float diff = a[i] - b[i];
            res = DefaultVectorUtilSupport.fma(diff, diff, res);
            ++i;
        }
        return res;
    }

    @Override
    public int dotProduct(byte[] a, byte[] b) {
        int total = 0;
        for (int i = 0; i < a.length; ++i) {
            total += a[i] * b[i];
        }
        return total;
    }

    @Override
    public float cosine(byte[] a, byte[] b) {
        int sum = 0;
        int norm1 = 0;
        int norm2 = 0;
        for (int i = 0; i < a.length; ++i) {
            byte elem1 = a[i];
            byte elem2 = b[i];
            sum += elem1 * elem2;
            norm1 += elem1 * elem1;
            norm2 += elem2 * elem2;
        }
        return (float)((double)sum / Math.sqrt((double)norm1 * (double)norm2));
    }

    @Override
    public int squareDistance(byte[] a, byte[] b) {
        int squareSum = 0;
        for (int i = 0; i < a.length; ++i) {
            int diff = a[i] - b[i];
            squareSum += diff * diff;
        }
        return squareSum;
    }
}

