/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.internal.hppc;

import guideme.internal.shaded.lucene.internal.hppc.AbstractIterator;
import guideme.internal.shaded.lucene.internal.hppc.BitMixer;
import guideme.internal.shaded.lucene.internal.hppc.BufferAllocationException;
import guideme.internal.shaded.lucene.internal.hppc.HashContainers;
import guideme.internal.shaded.lucene.internal.hppc.IntCursor;
import guideme.internal.shaded.lucene.internal.hppc.ObjectCursor;
import guideme.internal.shaded.lucene.util.Accountable;
import guideme.internal.shaded.lucene.util.RamUsageEstimator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;

public class IntObjectHashMap<VType>
implements Accountable,
Cloneable,
Iterable<IntObjectCursor<VType>> {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(IntObjectHashMap.class);
    public int[] keys;
    public Object[] values;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected int iterationSeed;

    public IntObjectHashMap() {
        this(4);
    }

    public IntObjectHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public IntObjectHashMap(int expectedElements, double loadFactor) {
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.iterationSeed = HashContainers.ITERATION_SEED.incrementAndGet();
        this.ensureCapacity(expectedElements);
    }

    public VType put(int key, VType value) {
        int existing;
        assert (this.assigned < this.mask + 1);
        int mask = this.mask;
        if (key == 0) {
            Object previousValue = this.hasEmptyKey ? this.values[mask + 1] : null;
            this.hasEmptyKey = true;
            this.values[mask + 1] = value;
            return (VType)previousValue;
        }
        int[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                Object previousValue = this.values[slot];
                this.values[slot] = value;
                return (VType)previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value);
        } else {
            keys[slot] = key;
            this.values[slot] = value;
        }
        ++this.assigned;
        return null;
    }

    public VType get(int key) {
        int existing;
        if (key == 0) {
            return (VType)(this.hasEmptyKey ? this.values[this.mask + 1] : null);
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                return (VType)this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return null;
    }

    public boolean containsKey(int key) {
        int existing;
        if (key == 0) {
            return this.hasEmptyKey;
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0);
    }

    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        for (IntObjectCursor<VType> c : this) {
            h += BitMixer.mix(c.key) + BitMixer.mix(c.value);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.equalElements((IntObjectHashMap)this.getClass().cast(obj));
    }

    protected boolean equalElements(IntObjectHashMap<?> other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (IntObjectCursor<?> c : other) {
            int key = c.key;
            if (this.containsKey(key) && Objects.equals(c.value, this.get(key))) continue;
            return false;
        }
        return true;
    }

    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            int[] prevKeys = this.keys;
            Object[] prevValues = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    protected int nextIterationSeed() {
        this.iterationSeed = BitMixer.mixPhi(this.iterationSeed);
        return this.iterationSeed;
    }

    @Override
    public Iterator<IntObjectCursor<VType>> iterator() {
        return new EntryIterator();
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.keys) + this.sizeOfValues();
    }

    private long sizeOfValues() {
        long size = RamUsageEstimator.shallowSizeOf(this.values);
        for (ObjectCursor value : this.values()) {
            size += RamUsageEstimator.sizeOfObject(value);
        }
        return size;
    }

    public KeysContainer keys() {
        return new KeysContainer();
    }

    public ValuesContainer values() {
        return new ValuesContainer();
    }

    public IntObjectHashMap<VType> clone() {
        try {
            IntObjectHashMap cloned = (IntObjectHashMap)super.clone();
            cloned.keys = (int[])this.keys.clone();
            cloned.values = (Object[])this.values.clone();
            cloned.hasEmptyKey = this.hasEmptyKey;
            cloned.iterationSeed = HashContainers.ITERATION_SEED.incrementAndGet();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (IntObjectCursor<VType> cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    protected int hashKey(int key) {
        assert (key != 0);
        return BitMixer.mixPhi(key);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(int[] fromKeys, VType[] fromValues) {
        assert (fromKeys.length == fromValues.length && HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        int[] keys = this.keys;
        Object[] values = this.values;
        int mask = this.mask;
        int from = fromKeys.length - 1;
        keys[keys.length - 1] = fromKeys[from];
        values[values.length - 1] = fromValues[from];
        while (--from >= 0) {
            int existing = fromKeys[from];
            if (existing == 0) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != 0) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values[slot] = fromValues[from];
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        int[] prevKeys = this.keys;
        Object[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new int[arraySize + emptyElementSlot];
            this.values = new Object[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.mask + 1, arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, int pendingKey, VType pendingValue) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == 0 && pendingKey != 0);
        int[] prevKeys = this.keys;
        Object[] prevValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    public static final class IntObjectCursor<VType> {
        public int index;
        public int key;
        public VType value;

        public String toString() {
            return "[cursor, index: " + this.index + ", key: " + this.key + ", value: " + this.value + "]";
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ObjectCursor<VType>> {
        private final ObjectCursor<VType> cursor = new ObjectCursor();
        private final int increment;
        private int index;
        private int slot;

        public ValuesIterator() {
            int seed = IntObjectHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & IntObjectHashMap.this.mask;
        }

        @Override
        protected ObjectCursor<VType> fetch() {
            int mask = IntObjectHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                if (IntObjectHashMap.this.keys[this.slot] == 0) continue;
                this.cursor.index = this.slot;
                this.cursor.value = IntObjectHashMap.this.values[this.slot];
                return this.cursor;
            }
            if (this.index == mask + 1 && IntObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index;
                this.cursor.value = IntObjectHashMap.this.values[this.index++];
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }

    public final class ValuesContainer
    implements Iterable<ObjectCursor<VType>> {
        @Override
        public Iterator<ObjectCursor<VType>> iterator() {
            return new ValuesIterator();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();
        private final int increment;
        private int index;
        private int slot;

        public KeysIterator() {
            int seed = IntObjectHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & IntObjectHashMap.this.mask;
        }

        @Override
        protected IntCursor fetch() {
            int mask = IntObjectHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                int existing = IntObjectHashMap.this.keys[this.slot];
                if (existing == 0) continue;
                this.cursor.index = this.slot;
                this.cursor.value = existing;
                return this.cursor;
            }
            if (this.index == mask + 1 && IntObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index++;
                this.cursor.value = 0;
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }

    public final class KeysContainer
    implements Iterable<IntCursor> {
        @Override
        public Iterator<IntCursor> iterator() {
            return new KeysIterator();
        }
    }

    private final class EntryIterator
    extends AbstractIterator<IntObjectCursor<VType>> {
        private final IntObjectCursor<VType> cursor = new IntObjectCursor();
        private final int increment;
        private int index;
        private int slot;

        public EntryIterator() {
            int seed = IntObjectHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & IntObjectHashMap.this.mask;
        }

        @Override
        protected IntObjectCursor<VType> fetch() {
            int mask = IntObjectHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                int existing = IntObjectHashMap.this.keys[this.slot];
                if (existing == 0) continue;
                this.cursor.index = this.slot;
                this.cursor.key = existing;
                this.cursor.value = IntObjectHashMap.this.values[this.slot];
                return this.cursor;
            }
            if (this.index == mask + 1 && IntObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index;
                this.cursor.key = 0;
                this.cursor.value = IntObjectHashMap.this.values[this.index++];
                return this.cursor;
            }
            return (IntObjectCursor)this.done();
        }
    }
}

