/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index.memory;

import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.tokenattributes.OffsetAttribute;
import guideme.internal.shaded.lucene.analysis.tokenattributes.PayloadAttribute;
import guideme.internal.shaded.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import guideme.internal.shaded.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import guideme.internal.shaded.lucene.document.FieldType;
import guideme.internal.shaded.lucene.index.BaseTermsEnum;
import guideme.internal.shaded.lucene.index.BinaryDocValues;
import guideme.internal.shaded.lucene.index.ByteVectorValues;
import guideme.internal.shaded.lucene.index.DocValuesType;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.FieldInfos;
import guideme.internal.shaded.lucene.index.FieldInvertState;
import guideme.internal.shaded.lucene.index.Fields;
import guideme.internal.shaded.lucene.index.FloatVectorValues;
import guideme.internal.shaded.lucene.index.ImpactsEnum;
import guideme.internal.shaded.lucene.index.IndexOptions;
import guideme.internal.shaded.lucene.index.IndexReader;
import guideme.internal.shaded.lucene.index.IndexableFieldType;
import guideme.internal.shaded.lucene.index.LeafMetaData;
import guideme.internal.shaded.lucene.index.LeafReader;
import guideme.internal.shaded.lucene.index.NumericDocValues;
import guideme.internal.shaded.lucene.index.OrdTermState;
import guideme.internal.shaded.lucene.index.PointValues;
import guideme.internal.shaded.lucene.index.PostingsEnum;
import guideme.internal.shaded.lucene.index.SlowImpactsEnum;
import guideme.internal.shaded.lucene.index.SortedDocValues;
import guideme.internal.shaded.lucene.index.SortedNumericDocValues;
import guideme.internal.shaded.lucene.index.SortedSetDocValues;
import guideme.internal.shaded.lucene.index.StoredFieldVisitor;
import guideme.internal.shaded.lucene.index.StoredFields;
import guideme.internal.shaded.lucene.index.TermState;
import guideme.internal.shaded.lucene.index.Terms;
import guideme.internal.shaded.lucene.index.TermsEnum;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.similarities.Similarity;
import guideme.internal.shaded.lucene.util.ArrayUtil;
import guideme.internal.shaded.lucene.util.Bits;
import guideme.internal.shaded.lucene.util.ByteBlockPool;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.BytesRefArray;
import guideme.internal.shaded.lucene.util.BytesRefBuilder;
import guideme.internal.shaded.lucene.util.BytesRefHash;
import guideme.internal.shaded.lucene.util.Counter;
import guideme.internal.shaded.lucene.util.IntBlockPool;
import guideme.internal.shaded.lucene.util.RecyclingByteBlockAllocator;
import guideme.internal.shaded.lucene.util.RecyclingIntBlockAllocator;
import guideme.internal.shaded.lucene.util.Version;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;

public class MemoryIndex {
    private final SortedMap<String, Info> fields = new TreeMap<String, Info>();
    private final boolean storeOffsets;
    private final boolean storePayloads;
    private final ByteBlockPool byteBlockPool;
    private final SlicedIntBlockPool slicedIntBlockPool;
    private final SlicedIntBlockPool.SliceWriter postingsWriter;
    private final BytesRefArray payloadsBytesRefs;
    private Counter bytesUsed;
    private boolean frozen = false;
    private Similarity normSimilarity = IndexSearcher.getDefaultSimilarity();
    private FieldType defaultFieldType = new FieldType();

    public MemoryIndex() {
        this(false);
    }

    public MemoryIndex(boolean storeOffsets) {
        this(storeOffsets, false);
    }

    public MemoryIndex(boolean storeOffsets, boolean storePayloads) {
        this(storeOffsets, storePayloads, 0L);
    }

    MemoryIndex(boolean storeOffsets, boolean storePayloads, long maxReusedBytes) {
        this.storeOffsets = storeOffsets;
        this.storePayloads = storePayloads;
        this.defaultFieldType.setIndexOptions(storeOffsets ? IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS : IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        this.defaultFieldType.setStoreTermVectors(true);
        this.bytesUsed = Counter.newCounter();
        int maxBufferedByteBlocks = (int)(maxReusedBytes / 2L / 32768L);
        int maxBufferedIntBlocks = (int)((maxReusedBytes - (long)maxBufferedByteBlocks * 32768L) / 32768L);
        assert ((long)(maxBufferedByteBlocks * 32768 + maxBufferedIntBlocks * 8192 * 4) <= maxReusedBytes);
        this.byteBlockPool = new ByteBlockPool(new RecyclingByteBlockAllocator(maxBufferedByteBlocks, this.bytesUsed));
        this.slicedIntBlockPool = new SlicedIntBlockPool(new RecyclingIntBlockAllocator(8192, maxBufferedIntBlocks, this.bytesUsed));
        this.postingsWriter = new SlicedIntBlockPool.SliceWriter(this.slicedIntBlockPool);
        this.payloadsBytesRefs = storePayloads ? new BytesRefArray(this.bytesUsed) : null;
    }

    public void addField(String fieldName, TokenStream stream) {
        this.addField(fieldName, stream, 0);
    }

    public void addField(String fieldName, TokenStream stream, int positionIncrementGap) {
        this.addField(fieldName, stream, positionIncrementGap, 1);
    }

    public void addField(String fieldName, TokenStream tokenStream, int positionIncrementGap, int offsetGap) {
        Info info = this.getInfo(fieldName, this.defaultFieldType);
        this.storeTerms(info, tokenStream, positionIncrementGap, offsetGap);
    }

    private Info getInfo(String fieldName, IndexableFieldType fieldType) {
        if (this.frozen) {
            throw new IllegalArgumentException("Cannot call addField() when MemoryIndex is frozen");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName must not be null");
        }
        Info info = (Info)this.fields.get(fieldName);
        if (info == null) {
            info = new Info(this.createFieldInfo(fieldName, this.fields.size(), fieldType), this.byteBlockPool);
            this.fields.put(fieldName, info);
        }
        if (fieldType.pointDimensionCount() != info.fieldInfo.getPointDimensionCount() && fieldType.pointDimensionCount() > 0) {
            info.fieldInfo.setPointDimensions(fieldType.pointDimensionCount(), fieldType.pointIndexDimensionCount(), fieldType.pointNumBytes());
        }
        if (fieldType.docValuesType() != info.fieldInfo.getDocValuesType() && fieldType.docValuesType() != DocValuesType.NONE) {
            info.fieldInfo.setDocValuesType(fieldType.docValuesType());
        }
        return info;
    }

    private FieldInfo createFieldInfo(String fieldName, int ord, IndexableFieldType fieldType) {
        IndexOptions indexOptions = this.storeOffsets ? IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS : IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
        return new FieldInfo(fieldName, ord, fieldType.storeTermVectors(), fieldType.omitNorms(), this.storePayloads, indexOptions, fieldType.docValuesType(), -1L, Collections.emptyMap(), fieldType.pointDimensionCount(), fieldType.pointIndexDimensionCount(), fieldType.pointNumBytes(), fieldType.vectorDimension(), fieldType.vectorEncoding(), fieldType.vectorSimilarityFunction(), false, false);
    }

    private void storeTerms(Info info, TokenStream tokenStream, int positionIncrementGap, int offsetGap) {
        int pos = -1;
        int offset = 0;
        if (info.numTokens > 0) {
            pos = info.lastPosition + positionIncrementGap;
            offset = info.lastOffset + offsetGap;
        }
        try (TokenStream stream = tokenStream;){
            TermToBytesRefAttribute termAtt = stream.getAttribute(TermToBytesRefAttribute.class);
            PositionIncrementAttribute posIncrAttribute = stream.addAttribute(PositionIncrementAttribute.class);
            OffsetAttribute offsetAtt = stream.addAttribute(OffsetAttribute.class);
            PayloadAttribute payloadAtt = this.storePayloads ? stream.addAttribute(PayloadAttribute.class) : null;
            stream.reset();
            while (stream.incrementToken()) {
                ++info.numTokens;
                int posIncr = posIncrAttribute.getPositionIncrement();
                if (posIncr == 0) {
                    ++info.numOverlapTokens;
                }
                pos += posIncr;
                int ord = info.terms.add(termAtt.getBytesRef());
                if (ord < 0) {
                    ord = -ord - 1;
                    this.postingsWriter.reset(info.sliceArray.end[ord]);
                } else {
                    info.sliceArray.start[ord] = this.postingsWriter.startNewSlice();
                }
                int n = ord;
                info.sliceArray.freq[n] = info.sliceArray.freq[n] + 1;
                info.maxTermFrequency = Math.max(info.maxTermFrequency, info.sliceArray.freq[ord]);
                ++info.sumTotalTermFreq;
                this.postingsWriter.writeInt(pos);
                if (this.storeOffsets) {
                    this.postingsWriter.writeInt(offsetAtt.startOffset() + offset);
                    this.postingsWriter.writeInt(offsetAtt.endOffset() + offset);
                }
                if (this.storePayloads) {
                    BytesRef payload = payloadAtt.getPayload();
                    int pIndex = payload == null || payload.length == 0 ? -1 : this.payloadsBytesRefs.append(payload);
                    this.postingsWriter.writeInt(pIndex);
                }
                info.sliceArray.end[ord] = this.postingsWriter.getCurrentOffset();
            }
            stream.end();
            if (info.numTokens > 0) {
                info.lastPosition = pos;
                info.lastOffset = offsetAtt.endOffset() + offset;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public IndexSearcher createSearcher() {
        MemoryIndexReader reader = new MemoryIndexReader();
        IndexSearcher searcher = new IndexSearcher(reader);
        searcher.setSimilarity(this.normSimilarity);
        searcher.setQueryCache(null);
        return searcher;
    }

    private static SortedNumericDocValues numericDocValues(final long[] values, final int count) {
        final MemoryDocValuesIterator it = new MemoryDocValuesIterator();
        return new SortedNumericDocValues(){
            int ord = 0;

            @Override
            public long nextValue() throws IOException {
                return values[this.ord++];
            }

            @Override
            public int docValueCount() {
                return count;
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                this.ord = 0;
                return it.advance(target) == target;
            }

            @Override
            public int docID() {
                return it.docId();
            }

            @Override
            public int nextDoc() throws IOException {
                return it.nextDoc();
            }

            @Override
            public int advance(int target) throws IOException {
                return it.advance(target);
            }

            @Override
            public long cost() {
                return 1L;
            }
        };
    }

    private static NumericDocValues numericDocValues(final long value) {
        final MemoryDocValuesIterator it = new MemoryDocValuesIterator();
        return new NumericDocValues(){

            @Override
            public long longValue() throws IOException {
                return value;
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                return this.advance(target) == target;
            }

            @Override
            public int docID() {
                return it.docId();
            }

            @Override
            public int nextDoc() throws IOException {
                return it.nextDoc();
            }

            @Override
            public int advance(int target) throws IOException {
                return it.advance(target);
            }

            @Override
            public long cost() {
                return 1L;
            }
        };
    }

    private static SortedDocValues sortedDocValues(final BytesRef value) {
        final MemoryDocValuesIterator it = new MemoryDocValuesIterator();
        return new SortedDocValues(){

            @Override
            public int ordValue() {
                return 0;
            }

            @Override
            public BytesRef lookupOrd(int ord) throws IOException {
                return value;
            }

            @Override
            public int getValueCount() {
                return 1;
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                return it.advance(target) == target;
            }

            @Override
            public int docID() {
                return it.docId();
            }

            @Override
            public int nextDoc() throws IOException {
                return it.nextDoc();
            }

            @Override
            public int advance(int target) throws IOException {
                return it.advance(target);
            }

            @Override
            public long cost() {
                return 1L;
            }
        };
    }

    private static SortedSetDocValues sortedSetDocValues(final BytesRefHash values, final int[] bytesIds) {
        final MemoryDocValuesIterator it = new MemoryDocValuesIterator();
        final BytesRef scratch = new BytesRef();
        return new SortedSetDocValues(){
            int ord = 0;

            @Override
            public long nextOrd() throws IOException {
                if (this.ord >= values.size()) {
                    return -1L;
                }
                return this.ord++;
            }

            @Override
            public int docValueCount() {
                return values.size();
            }

            @Override
            public BytesRef lookupOrd(long ord) throws IOException {
                return values.get(bytesIds[(int)ord], scratch);
            }

            @Override
            public long getValueCount() {
                return values.size();
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                this.ord = 0;
                return it.advance(target) == target;
            }

            @Override
            public int docID() {
                return it.docId();
            }

            @Override
            public int nextDoc() throws IOException {
                return it.nextDoc();
            }

            @Override
            public int advance(int target) throws IOException {
                return it.advance(target);
            }

            @Override
            public long cost() {
                return 1L;
            }
        };
    }

    private static final class MemoryByteVectorValues
    extends ByteVectorValues {
        private final Info info;
        private int currentDoc = -1;

        MemoryByteVectorValues(Info info) {
            this.info = info;
        }

        @Override
        public int dimension() {
            return this.info.fieldInfo.getVectorDimension();
        }

        @Override
        public int size() {
            return this.info.byteVectorCount;
        }

        @Override
        public byte[] vectorValue() {
            if (this.currentDoc == 0) {
                return this.info.byteVectorValues[0];
            }
            return null;
        }

        @Override
        public int docID() {
            return this.currentDoc;
        }

        @Override
        public int nextDoc() {
            int doc;
            if ((doc = ++this.currentDoc) == 0) {
                return doc;
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public int advance(int target) {
            if (target == 0) {
                this.currentDoc = target;
                return target;
            }
            return Integer.MAX_VALUE;
        }
    }

    private static final class MemoryFloatVectorValues
    extends FloatVectorValues {
        private final Info info;
        private int currentDoc = -1;

        MemoryFloatVectorValues(Info info) {
            this.info = info;
        }

        @Override
        public int dimension() {
            return this.info.fieldInfo.getVectorDimension();
        }

        @Override
        public int size() {
            return this.info.floatVectorCount;
        }

        @Override
        public float[] vectorValue() {
            if (this.currentDoc == 0) {
                return this.info.floatVectorValues[0];
            }
            return null;
        }

        @Override
        public int docID() {
            return this.currentDoc;
        }

        @Override
        public int nextDoc() {
            int doc;
            if ((doc = ++this.currentDoc) == 0) {
                return doc;
            }
            return Integer.MAX_VALUE;
        }

        @Override
        public int advance(int target) {
            if (target == 0) {
                this.currentDoc = target;
                return target;
            }
            return Integer.MAX_VALUE;
        }
    }

    private static final class SliceByteStartArray
    extends BytesRefHash.DirectBytesStartArray {
        int[] start;
        int[] end;
        int[] freq;

        public SliceByteStartArray(int initSize) {
            super(initSize);
        }

        @Override
        public int[] init() {
            int[] ord = super.init();
            this.start = new int[ArrayUtil.oversize(ord.length, 4)];
            this.end = new int[ArrayUtil.oversize(ord.length, 4)];
            this.freq = new int[ArrayUtil.oversize(ord.length, 4)];
            assert (this.start.length >= ord.length);
            assert (this.end.length >= ord.length);
            assert (this.freq.length >= ord.length);
            return ord;
        }

        @Override
        public int[] grow() {
            int[] ord = super.grow();
            if (this.start.length < ord.length) {
                this.start = ArrayUtil.grow(this.start, ord.length);
                this.end = ArrayUtil.grow(this.end, ord.length);
                this.freq = ArrayUtil.grow(this.freq, ord.length);
            }
            assert (this.start.length >= ord.length);
            assert (this.end.length >= ord.length);
            assert (this.freq.length >= ord.length);
            return ord;
        }

        @Override
        public int[] clear() {
            this.end = null;
            this.start = null;
            return super.clear();
        }
    }

    private final class MemoryIndexReader
    extends LeafReader {
        private final MemoryFields memoryFields;
        private final FieldInfos fieldInfos;

        private MemoryIndexReader() {
            this.memoryFields = new MemoryFields(MemoryIndex.this.fields);
            FieldInfo[] fieldInfosArr = new FieldInfo[MemoryIndex.this.fields.size()];
            int i = 0;
            for (Info info : MemoryIndex.this.fields.values()) {
                info.prepareDocValuesAndPointValues();
                fieldInfosArr[i++] = info.fieldInfo;
            }
            this.fieldInfos = new FieldInfos(fieldInfosArr);
        }

        private Info getInfoForExpectedDocValuesType(String fieldName, DocValuesType expectedType) {
            if (expectedType == DocValuesType.NONE) {
                return null;
            }
            Info info = (Info)MemoryIndex.this.fields.get(fieldName);
            if (info == null) {
                return null;
            }
            if (info.fieldInfo.getDocValuesType() != expectedType) {
                return null;
            }
            return info;
        }

        @Override
        public Bits getLiveDocs() {
            return null;
        }

        @Override
        public FieldInfos getFieldInfos() {
            return this.fieldInfos;
        }

        @Override
        public NumericDocValues getNumericDocValues(String field) throws IOException {
            Info info = this.getInfoForExpectedDocValuesType(field, DocValuesType.NUMERIC);
            if (info == null) {
                return null;
            }
            return MemoryIndex.numericDocValues(info.numericProducer.dvLongValues[0]);
        }

        @Override
        public BinaryDocValues getBinaryDocValues(String field) {
            final SortedDocValues in = this.getSortedDocValues(field, DocValuesType.BINARY);
            if (in == null) {
                return null;
            }
            return new BinaryDocValues(){

                @Override
                public BytesRef binaryValue() throws IOException {
                    return in.lookupOrd(in.ordValue());
                }

                @Override
                public boolean advanceExact(int target) throws IOException {
                    return in.advanceExact(target);
                }

                @Override
                public int docID() {
                    return in.docID();
                }

                @Override
                public int nextDoc() throws IOException {
                    return in.nextDoc();
                }

                @Override
                public int advance(int target) throws IOException {
                    return in.advance(target);
                }

                @Override
                public long cost() {
                    return in.cost();
                }
            };
        }

        @Override
        public SortedDocValues getSortedDocValues(String field) {
            return this.getSortedDocValues(field, DocValuesType.SORTED);
        }

        private SortedDocValues getSortedDocValues(String field, DocValuesType docValuesType) {
            Info info = this.getInfoForExpectedDocValuesType(field, docValuesType);
            if (info != null) {
                return MemoryIndex.sortedDocValues(info.binaryProducer.dvBytesValuesSet);
            }
            return null;
        }

        @Override
        public SortedNumericDocValues getSortedNumericDocValues(String field) {
            Info info = this.getInfoForExpectedDocValuesType(field, DocValuesType.SORTED_NUMERIC);
            if (info != null) {
                return MemoryIndex.numericDocValues(info.numericProducer.dvLongValues, info.numericProducer.count);
            }
            return null;
        }

        @Override
        public SortedSetDocValues getSortedSetDocValues(String field) {
            Info info = this.getInfoForExpectedDocValuesType(field, DocValuesType.SORTED_SET);
            if (info != null) {
                return MemoryIndex.sortedSetDocValues(info.bytesRefHashProducer.dvBytesRefHashValuesSet, info.bytesRefHashProducer.bytesIds);
            }
            return null;
        }

        @Override
        public PointValues getPointValues(String fieldName) {
            Info info = (Info)MemoryIndex.this.fields.get(fieldName);
            if (info == null || info.pointValues == null) {
                return null;
            }
            return new MemoryIndexPointValues(info);
        }

        @Override
        public FloatVectorValues getFloatVectorValues(String fieldName) {
            Info info = (Info)MemoryIndex.this.fields.get(fieldName);
            if (info == null || info.floatVectorValues == null) {
                return null;
            }
            return new MemoryFloatVectorValues(info);
        }

        @Override
        public ByteVectorValues getByteVectorValues(String fieldName) {
            Info info = (Info)MemoryIndex.this.fields.get(fieldName);
            if (info == null || info.byteVectorValues == null) {
                return null;
            }
            return new MemoryByteVectorValues(info);
        }

        @Override
        public Terms terms(String field) throws IOException {
            return this.memoryFields.terms(field);
        }

        @Override
        public int numDocs() {
            return 1;
        }

        @Override
        public int maxDoc() {
            return 1;
        }

        @Override
        public StoredFields storedFields() {
            return new StoredFields(){

                @Override
                public void document(int docID, StoredFieldVisitor visitor) throws IOException {
                    for (Info info : MemoryIndex.this.fields.values()) {
                        StoredFieldVisitor.Status status = visitor.needsField(info.fieldInfo);
                        if (status == StoredFieldVisitor.Status.STOP) {
                            return;
                        }
                        if (status == StoredFieldVisitor.Status.NO || info.storedValues == null) continue;
                        for (Object value : info.storedValues) {
                            if (value instanceof BytesRef) {
                                visitor.binaryField(info.fieldInfo, BytesRef.deepCopyOf((BytesRef)((BytesRef)value)).bytes);
                                continue;
                            }
                            if (value instanceof Double) {
                                visitor.doubleField(info.fieldInfo, (Double)value);
                                continue;
                            }
                            if (value instanceof Float) {
                                visitor.floatField(info.fieldInfo, ((Float)value).floatValue());
                                continue;
                            }
                            if (value instanceof Long) {
                                visitor.longField(info.fieldInfo, (Long)value);
                                continue;
                            }
                            if (value instanceof Integer) {
                                visitor.intField(info.fieldInfo, (Integer)value);
                                continue;
                            }
                            if (!(value instanceof String)) continue;
                            visitor.stringField(info.fieldInfo, (String)value);
                        }
                    }
                }
            };
        }

        @Override
        protected void doClose() {
        }

        @Override
        public NumericDocValues getNormValues(String field) {
            Info info = (Info)MemoryIndex.this.fields.get(field);
            if (info == null || info.fieldInfo.omitsNorms()) {
                return null;
            }
            return info.getNormDocValues();
        }

        @Override
        public LeafMetaData getMetaData() {
            return new LeafMetaData(Version.LATEST.major, Version.LATEST, null, false);
        }

        @Override
        public IndexReader.CacheHelper getCoreCacheHelper() {
            return null;
        }

        @Override
        public IndexReader.CacheHelper getReaderCacheHelper() {
            return null;
        }

        private class MemoryIndexPointValues
        extends PointValues {
            final Info info;

            MemoryIndexPointValues(Info info) {
                this.info = Objects.requireNonNull(info);
                Objects.requireNonNull(info.pointValues, "Field does not have points");
            }

            @Override
            public PointValues.PointTree getPointTree() {
                return new PointValues.PointTree(){

                    @Override
                    public PointValues.PointTree clone() {
                        return this;
                    }

                    @Override
                    public boolean moveToChild() {
                        return false;
                    }

                    @Override
                    public boolean moveToSibling() {
                        return false;
                    }

                    @Override
                    public boolean moveToParent() {
                        return false;
                    }

                    @Override
                    public long size() {
                        return MemoryIndexPointValues.this.info.pointValuesCount;
                    }

                    @Override
                    public void visitDocIDs(PointValues.IntersectVisitor visitor) throws IOException {
                        visitor.grow(MemoryIndexPointValues.this.info.pointValuesCount);
                        for (int i = 0; i < MemoryIndexPointValues.this.info.pointValuesCount; ++i) {
                            visitor.visit(0);
                        }
                    }

                    @Override
                    public void visitDocValues(PointValues.IntersectVisitor visitor) throws IOException {
                        BytesRef[] values = MemoryIndexPointValues.this.info.pointValues;
                        visitor.grow(MemoryIndexPointValues.this.info.pointValuesCount);
                        for (int i = 0; i < MemoryIndexPointValues.this.info.pointValuesCount; ++i) {
                            visitor.visit(0, values[i].bytes);
                        }
                    }
                };
            }

            @Override
            public int getNumDimensions() throws IOException {
                return this.info.fieldInfo.getPointDimensionCount();
            }

            @Override
            public int getNumIndexDimensions() throws IOException {
                return this.info.fieldInfo.getPointDimensionCount();
            }

            @Override
            public int getBytesPerDimension() throws IOException {
                return this.info.fieldInfo.getPointNumBytes();
            }

            @Override
            public long size() {
                return this.info.pointValuesCount;
            }

            @Override
            public int getDocCount() {
                return 1;
            }
        }

        private class MemoryPostingsEnum
        extends PostingsEnum {
            private final SlicedIntBlockPool.SliceReader sliceReader;
            private int posUpto;
            private boolean hasNext;
            private int doc = -1;
            private int freq;
            private int startOffset;
            private int endOffset;
            private int payloadIndex;
            private final BytesRefBuilder payloadBuilder;

            public MemoryPostingsEnum() {
                this.sliceReader = new SlicedIntBlockPool.SliceReader(MemoryIndex.this.slicedIntBlockPool);
                this.payloadBuilder = MemoryIndex.this.storePayloads ? new BytesRefBuilder() : null;
            }

            public PostingsEnum reset(int start, int end, int freq) {
                this.sliceReader.reset(start, end);
                this.posUpto = 0;
                this.hasNext = true;
                this.doc = -1;
                this.freq = freq;
                return this;
            }

            @Override
            public int docID() {
                return this.doc;
            }

            @Override
            public int nextDoc() {
                if (this.hasNext) {
                    this.hasNext = false;
                    this.doc = 0;
                    return 0;
                }
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }

            @Override
            public int advance(int target) throws IOException {
                return this.slowAdvance(target);
            }

            @Override
            public int freq() throws IOException {
                return this.freq;
            }

            @Override
            public int nextPosition() {
                ++this.posUpto;
                assert (this.posUpto <= this.freq);
                assert (!this.sliceReader.endOfSlice()) : " stores offsets : " + this.startOffset;
                int pos = this.sliceReader.readInt();
                if (MemoryIndex.this.storeOffsets) {
                    this.startOffset = this.sliceReader.readInt();
                    this.endOffset = this.sliceReader.readInt();
                }
                if (MemoryIndex.this.storePayloads) {
                    this.payloadIndex = this.sliceReader.readInt();
                }
                return pos;
            }

            @Override
            public int startOffset() {
                return this.startOffset;
            }

            @Override
            public int endOffset() {
                return this.endOffset;
            }

            @Override
            public BytesRef getPayload() {
                if (this.payloadBuilder == null || this.payloadIndex == -1) {
                    return null;
                }
                return MemoryIndex.this.payloadsBytesRefs.get(this.payloadBuilder, this.payloadIndex);
            }

            @Override
            public long cost() {
                return 1L;
            }
        }

        private class MemoryTermsEnum
        extends BaseTermsEnum {
            private final Info info;
            private final BytesRef br = new BytesRef();
            int termUpto = -1;

            public MemoryTermsEnum(Info info) {
                this.info = info;
                info.sortTerms();
            }

            private final int binarySearch(BytesRef b, BytesRef bytesRef, int low, int high, BytesRefHash hash, int[] ords) {
                int mid = 0;
                while (low <= high) {
                    mid = low + high >>> 1;
                    hash.get(ords[mid], bytesRef);
                    int cmp = bytesRef.compareTo(b);
                    if (cmp < 0) {
                        low = mid + 1;
                        continue;
                    }
                    if (cmp > 0) {
                        high = mid - 1;
                        continue;
                    }
                    return mid;
                }
                assert (bytesRef.compareTo(b) != 0);
                return -(low + 1);
            }

            @Override
            public boolean seekExact(BytesRef text) {
                this.termUpto = this.binarySearch(text, this.br, 0, this.info.terms.size() - 1, this.info.terms, this.info.sortedTerms);
                return this.termUpto >= 0;
            }

            @Override
            public TermsEnum.SeekStatus seekCeil(BytesRef text) {
                this.termUpto = this.binarySearch(text, this.br, 0, this.info.terms.size() - 1, this.info.terms, this.info.sortedTerms);
                if (this.termUpto < 0) {
                    this.termUpto = -this.termUpto - 1;
                    if (this.termUpto >= this.info.terms.size()) {
                        return TermsEnum.SeekStatus.END;
                    }
                    this.info.terms.get(this.info.sortedTerms[this.termUpto], this.br);
                    return TermsEnum.SeekStatus.NOT_FOUND;
                }
                return TermsEnum.SeekStatus.FOUND;
            }

            @Override
            public void seekExact(long ord) {
                assert (ord < (long)this.info.terms.size());
                this.termUpto = (int)ord;
                this.info.terms.get(this.info.sortedTerms[this.termUpto], this.br);
            }

            @Override
            public BytesRef next() {
                ++this.termUpto;
                if (this.termUpto >= this.info.terms.size()) {
                    return null;
                }
                this.info.terms.get(this.info.sortedTerms[this.termUpto], this.br);
                return this.br;
            }

            @Override
            public BytesRef term() {
                return this.br;
            }

            @Override
            public long ord() {
                return this.termUpto;
            }

            @Override
            public int docFreq() {
                return 1;
            }

            @Override
            public long totalTermFreq() {
                return this.info.sliceArray.freq[this.info.sortedTerms[this.termUpto]];
            }

            @Override
            public PostingsEnum postings(PostingsEnum reuse, int flags) {
                if (reuse == null || !(reuse instanceof MemoryPostingsEnum)) {
                    reuse = new MemoryPostingsEnum();
                }
                int ord = this.info.sortedTerms[this.termUpto];
                return ((MemoryPostingsEnum)reuse).reset(this.info.sliceArray.start[ord], this.info.sliceArray.end[ord], this.info.sliceArray.freq[ord]);
            }

            @Override
            public ImpactsEnum impacts(int flags) throws IOException {
                return new SlowImpactsEnum(this.postings(null, flags));
            }

            @Override
            public void seekExact(BytesRef term, TermState state) throws IOException {
                assert (state != null);
                this.seekExact(((OrdTermState)state).ord);
            }

            @Override
            public TermState termState() throws IOException {
                OrdTermState ts = new OrdTermState();
                ts.ord = this.termUpto;
                return ts;
            }
        }

        private class MemoryFields
        extends Fields {
            private final Map<String, Info> fields;

            public MemoryFields(Map<String, Info> fields) {
                this.fields = fields;
            }

            @Override
            public Iterator<String> iterator() {
                return this.fields.entrySet().stream().filter(e -> ((Info)e.getValue()).numTokens > 0).map(Map.Entry::getKey).iterator();
            }

            @Override
            public Terms terms(String field) {
                final Info info = this.fields.get(field);
                if (info == null || info.numTokens <= 0) {
                    return null;
                }
                return new Terms(){

                    @Override
                    public TermsEnum iterator() {
                        return new MemoryTermsEnum(info);
                    }

                    @Override
                    public long size() {
                        return info.terms.size();
                    }

                    @Override
                    public long getSumTotalTermFreq() {
                        return info.sumTotalTermFreq;
                    }

                    @Override
                    public long getSumDocFreq() {
                        return info.terms.size();
                    }

                    @Override
                    public int getDocCount() {
                        return this.size() > 0L ? 1 : 0;
                    }

                    @Override
                    public boolean hasFreqs() {
                        return true;
                    }

                    @Override
                    public boolean hasOffsets() {
                        return MemoryIndex.this.storeOffsets;
                    }

                    @Override
                    public boolean hasPositions() {
                        return true;
                    }

                    @Override
                    public boolean hasPayloads() {
                        return MemoryIndex.this.storePayloads;
                    }
                };
            }

            @Override
            public int size() {
                return Math.toIntExact(this.fields.entrySet().stream().filter(e -> ((Info)e.getValue()).numTokens > 0).count());
            }
        }
    }

    private static final class NumericDocValuesProducer {
        long[] dvLongValues;
        int count;

        private NumericDocValuesProducer() {
        }

        private void prepareForUsage() {
            Arrays.sort(this.dvLongValues, 0, this.count);
        }
    }

    private static final class BytesRefHashDocValuesProducer {
        BytesRefHash dvBytesRefHashValuesSet;
        int[] bytesIds;

        private BytesRefHashDocValuesProducer() {
        }

        private void prepareForUsage() {
            this.bytesIds = this.dvBytesRefHashValuesSet.sort();
        }
    }

    private static final class BinaryDocValuesProducer {
        BytesRef dvBytesValuesSet;

        private BinaryDocValuesProducer() {
        }
    }

    private static class MemoryDocValuesIterator {
        int doc = -1;

        private MemoryDocValuesIterator() {
        }

        int advance(int doc) {
            this.doc = doc;
            return this.docId();
        }

        int nextDoc() {
            ++this.doc;
            return this.docId();
        }

        int docId() {
            return this.doc > 0 ? Integer.MAX_VALUE : this.doc;
        }
    }

    private final class Info {
        private FieldInfo fieldInfo;
        private Long norm;
        private BytesRefHash terms;
        private SliceByteStartArray sliceArray;
        private transient int[] sortedTerms;
        private int numTokens;
        private int numOverlapTokens;
        private long sumTotalTermFreq;
        private int maxTermFrequency;
        private int lastPosition;
        private int lastOffset;
        private BytesRefHashDocValuesProducer bytesRefHashProducer;
        private BinaryDocValuesProducer binaryProducer;
        private NumericDocValuesProducer numericProducer;
        private boolean preparedDocValuesAndPointValues;
        private List<Object> storedValues;
        private BytesRef[] pointValues;
        private int floatVectorCount;
        private float[][] floatVectorValues;
        private int byteVectorCount;
        private byte[][] byteVectorValues;
        private byte[] minPackedValue;
        private byte[] maxPackedValue;
        private int pointValuesCount;

        private Info(FieldInfo fieldInfo, ByteBlockPool byteBlockPool) {
            this.fieldInfo = fieldInfo;
            this.sliceArray = new SliceByteStartArray(16);
            this.terms = new BytesRefHash(byteBlockPool, 16, this.sliceArray);
            this.bytesRefHashProducer = new BytesRefHashDocValuesProducer();
            this.binaryProducer = new BinaryDocValuesProducer();
            this.numericProducer = new NumericDocValuesProducer();
        }

        void sortTerms() {
            if (this.sortedTerms == null) {
                this.sortedTerms = this.terms.sort();
            }
        }

        void prepareDocValuesAndPointValues() {
            if (!this.preparedDocValuesAndPointValues) {
                DocValuesType dvType = this.fieldInfo.getDocValuesType();
                if (dvType == DocValuesType.NUMERIC || dvType == DocValuesType.SORTED_NUMERIC) {
                    this.numericProducer.prepareForUsage();
                }
                if (dvType == DocValuesType.SORTED_SET) {
                    this.bytesRefHashProducer.prepareForUsage();
                }
                if (this.pointValues != null) {
                    assert (this.pointValues[0].bytes.length == this.pointValues[0].length) : "BytesRef should wrap a precise byte[], BytesRef.deepCopyOf() should take care of this";
                    int numDimensions = this.fieldInfo.getPointDimensionCount();
                    int numBytesPerDimension = this.fieldInfo.getPointNumBytes();
                    if (numDimensions == 1) {
                        Arrays.sort(this.pointValues, 0, this.pointValuesCount);
                        this.minPackedValue = (byte[])this.pointValues[0].bytes.clone();
                        this.maxPackedValue = (byte[])this.pointValues[this.pointValuesCount - 1].bytes.clone();
                    } else {
                        this.minPackedValue = (byte[])this.pointValues[0].bytes.clone();
                        this.maxPackedValue = (byte[])this.pointValues[0].bytes.clone();
                        for (int i = 0; i < this.pointValuesCount; ++i) {
                            BytesRef pointValue = this.pointValues[i];
                            assert (pointValue.bytes.length == pointValue.length) : "BytesRef should wrap a precise byte[], BytesRef.deepCopyOf() should take care of this";
                            for (int dim = 0; dim < numDimensions; ++dim) {
                                int offset = dim * numBytesPerDimension;
                                if (Arrays.compareUnsigned(pointValue.bytes, offset, offset + numBytesPerDimension, this.minPackedValue, offset, offset + numBytesPerDimension) < 0) {
                                    System.arraycopy(pointValue.bytes, offset, this.minPackedValue, offset, numBytesPerDimension);
                                }
                                if (Arrays.compareUnsigned(pointValue.bytes, offset, offset + numBytesPerDimension, this.maxPackedValue, offset, offset + numBytesPerDimension) <= 0) continue;
                                System.arraycopy(pointValue.bytes, offset, this.maxPackedValue, offset, numBytesPerDimension);
                            }
                        }
                    }
                }
                this.preparedDocValuesAndPointValues = true;
            }
        }

        NumericDocValues getNormDocValues() {
            if (this.norm == null) {
                FieldInvertState invertState = new FieldInvertState(Version.LATEST.major, this.fieldInfo.name, this.fieldInfo.getIndexOptions(), this.lastPosition, this.numTokens, this.numOverlapTokens, 0, this.maxTermFrequency, this.terms.size());
                long value = MemoryIndex.this.normSimilarity.computeNorm(invertState);
                this.norm = value;
            }
            return MemoryIndex.numericDocValues(this.norm);
        }
    }

    static class SlicedIntBlockPool
    extends IntBlockPool {
        private static final int[] NEXT_LEVEL_ARRAY = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 9};
        private static final int[] LEVEL_SIZE_ARRAY = new int[]{2, 4, 8, 16, 16, 32, 32, 64, 64, 128};
        private static final int FIRST_LEVEL_SIZE = LEVEL_SIZE_ARRAY[0];

        SlicedIntBlockPool(IntBlockPool.Allocator allocator) {
            super(allocator);
        }

        private static boolean assertSliceBuffer(int[] buffer) {
            for (int value : buffer) {
                if (value == 0) continue;
                return false;
            }
            return true;
        }

        private int newSlice(int size) {
            if (this.intUpto > 8192 - size) {
                this.nextBuffer();
                assert (SlicedIntBlockPool.assertSliceBuffer(this.buffer));
            }
            int upto = this.intUpto;
            this.intUpto += size;
            this.buffer[this.intUpto - 1] = 16;
            return upto;
        }

        private int allocSlice(int[] slice, int sliceOffset) {
            int level = slice[sliceOffset] & 0xF;
            int newLevel = NEXT_LEVEL_ARRAY[level];
            int newSize = LEVEL_SIZE_ARRAY[newLevel];
            if (this.intUpto > 8192 - newSize) {
                this.nextBuffer();
                assert (SlicedIntBlockPool.assertSliceBuffer(this.buffer));
            }
            int newUpto = this.intUpto;
            int offset = newUpto + this.intOffset;
            this.intUpto += newSize;
            slice[sliceOffset] = offset;
            this.buffer[this.intUpto - 1] = 0x10 | newLevel;
            return newUpto;
        }

        static class SliceReader {
            private final SlicedIntBlockPool slicedIntBlockPool;
            private int upto;
            private int bufferUpto;
            private int bufferOffset;
            private int[] buffer;
            private int limit;
            private int level;
            private int end;

            public SliceReader(SlicedIntBlockPool slicedIntBlockPool) {
                this.slicedIntBlockPool = slicedIntBlockPool;
            }

            public void reset(int startOffset, int endOffset) {
                this.bufferUpto = startOffset / 8192;
                this.bufferOffset = this.bufferUpto * 8192;
                this.end = endOffset;
                this.level = 0;
                this.buffer = this.slicedIntBlockPool.buffers[this.bufferUpto];
                this.upto = startOffset & 0x1FFF;
                int firstSize = LEVEL_SIZE_ARRAY[0];
                this.limit = startOffset + firstSize >= endOffset ? endOffset & 0x1FFF : this.upto + firstSize - 1;
            }

            public boolean endOfSlice() {
                assert (this.upto + this.bufferOffset <= this.end);
                return this.upto + this.bufferOffset == this.end;
            }

            public int readInt() {
                assert (!this.endOfSlice());
                assert (this.upto <= this.limit);
                if (this.upto == this.limit) {
                    this.nextSlice();
                }
                return this.buffer[this.upto++];
            }

            private void nextSlice() {
                int nextIndex = this.buffer[this.limit];
                this.level = NEXT_LEVEL_ARRAY[this.level];
                int newSize = LEVEL_SIZE_ARRAY[this.level];
                this.bufferUpto = nextIndex / 8192;
                this.bufferOffset = this.bufferUpto * 8192;
                this.buffer = this.slicedIntBlockPool.buffers[this.bufferUpto];
                this.upto = nextIndex & 0x1FFF;
                if (nextIndex + newSize >= this.end) {
                    assert (this.end - nextIndex > 0);
                    this.limit = this.end - this.bufferOffset;
                } else {
                    this.limit = this.upto + newSize - 1;
                }
            }
        }

        static class SliceWriter {
            private int offset;
            private final SlicedIntBlockPool slicedIntBlockPool;

            public SliceWriter(SlicedIntBlockPool slicedIntBlockPool) {
                this.slicedIntBlockPool = slicedIntBlockPool;
            }

            public void reset(int sliceOffset) {
                this.offset = sliceOffset;
            }

            public void writeInt(int value) {
                int[] ints = this.slicedIntBlockPool.buffers[this.offset >> 13];
                assert (ints != null);
                int relativeOffset = this.offset & 0x1FFF;
                if (ints[relativeOffset] != 0) {
                    relativeOffset = this.slicedIntBlockPool.allocSlice(ints, relativeOffset);
                    ints = this.slicedIntBlockPool.buffer;
                    this.offset = relativeOffset + this.slicedIntBlockPool.intOffset;
                }
                ints[relativeOffset] = value;
                ++this.offset;
            }

            public int startNewSlice() {
                this.offset = this.slicedIntBlockPool.newSlice(FIRST_LEVEL_SIZE) + this.slicedIntBlockPool.intOffset;
                return this.offset;
            }

            public int getCurrentOffset() {
                return this.offset;
            }
        }
    }
}

