/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.document;

import guideme.internal.shaded.lucene.analysis.Analyzer;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.tokenattributes.BytesTermAttribute;
import guideme.internal.shaded.lucene.analysis.tokenattributes.CharTermAttribute;
import guideme.internal.shaded.lucene.analysis.tokenattributes.OffsetAttribute;
import guideme.internal.shaded.lucene.document.InvertableType;
import guideme.internal.shaded.lucene.document.StoredValue;
import guideme.internal.shaded.lucene.index.IndexOptions;
import guideme.internal.shaded.lucene.index.IndexableField;
import guideme.internal.shaded.lucene.index.IndexableFieldType;
import guideme.internal.shaded.lucene.util.BytesRef;
import java.io.IOException;
import java.io.Reader;

public class Field
implements IndexableField {
    protected final IndexableFieldType type;
    protected final String name;
    protected Object fieldsData;
    protected TokenStream tokenStream;

    protected Field(String name, IndexableFieldType type) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.name = name;
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        this.type = type;
    }

    public Field(String name, byte[] value, IndexableFieldType type) {
        this(name, value, 0, value.length, type);
    }

    public Field(String name, byte[] value, int offset, int length, IndexableFieldType type) {
        this(name, value != null ? new BytesRef(value, offset, length) : null, type);
    }

    public Field(String name, BytesRef bytes, IndexableFieldType type) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (bytes == null) {
            throw new IllegalArgumentException("bytes must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        this.name = name;
        this.fieldsData = bytes;
        this.type = type;
    }

    public Field(String name, CharSequence value, IndexableFieldType type) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        if (!type.stored() && type.indexOptions() == IndexOptions.NONE) {
            throw new IllegalArgumentException("it doesn't make sense to have a field that is neither indexed nor stored");
        }
        this.name = name;
        this.fieldsData = value;
        this.type = type;
    }

    @Override
    public String stringValue() {
        if (this.fieldsData instanceof CharSequence || this.fieldsData instanceof Number) {
            return this.fieldsData.toString();
        }
        return null;
    }

    public Reader readerValue() {
        return this.fieldsData instanceof Reader ? (Reader)this.fieldsData : null;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Number numericValue() {
        if (this.fieldsData instanceof Number) {
            return (Number)this.fieldsData;
        }
        return null;
    }

    @Override
    public BytesRef binaryValue() {
        if (this.fieldsData instanceof BytesRef) {
            return (BytesRef)this.fieldsData;
        }
        return null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.type.toString());
        result.append('<');
        result.append(this.name);
        result.append(':');
        if (this.fieldsData != null) {
            result.append(this.fieldsData);
        }
        result.append('>');
        return result.toString();
    }

    @Override
    public IndexableFieldType fieldType() {
        return this.type;
    }

    @Override
    public InvertableType invertableType() {
        return InvertableType.TOKEN_STREAM;
    }

    @Override
    public TokenStream tokenStream(Analyzer analyzer, TokenStream reuse) {
        if (this.fieldType().indexOptions() == IndexOptions.NONE) {
            return null;
        }
        if (!this.fieldType().tokenized()) {
            if (this.stringValue() != null) {
                if (!(reuse instanceof StringTokenStream)) {
                    reuse = new StringTokenStream();
                }
                ((StringTokenStream)reuse).setValue(this.stringValue());
                return reuse;
            }
            if (this.binaryValue() != null) {
                if (!(reuse instanceof BinaryTokenStream)) {
                    reuse = new BinaryTokenStream();
                }
                ((BinaryTokenStream)reuse).setValue(this.binaryValue());
                return reuse;
            }
            throw new IllegalArgumentException("Non-Tokenized Fields must have a String value");
        }
        if (this.tokenStream != null) {
            return this.tokenStream;
        }
        if (this.readerValue() != null) {
            return analyzer.tokenStream(this.name(), this.readerValue());
        }
        if (this.stringValue() != null) {
            return analyzer.tokenStream(this.name(), this.stringValue());
        }
        throw new IllegalArgumentException("Field must have either TokenStream, String, Reader or Number value; got " + this);
    }

    @Override
    public StoredValue storedValue() {
        if (!this.fieldType().stored()) {
            return null;
        }
        if (this.fieldsData == null) {
            throw new IllegalArgumentException("fieldsData is unset");
        }
        if (this.fieldsData instanceof Integer) {
            return new StoredValue((Integer)this.fieldsData);
        }
        if (this.fieldsData instanceof Long) {
            return new StoredValue((Long)this.fieldsData);
        }
        if (this.fieldsData instanceof Float) {
            return new StoredValue(((Float)this.fieldsData).floatValue());
        }
        if (this.fieldsData instanceof Double) {
            return new StoredValue((Double)this.fieldsData);
        }
        if (this.fieldsData instanceof BytesRef) {
            return new StoredValue((BytesRef)this.fieldsData);
        }
        if (this.fieldsData instanceof String) {
            return new StoredValue((String)this.fieldsData);
        }
        throw new IllegalStateException("Cannot store value of type " + this.fieldsData.getClass());
    }

    public static enum Store {
        YES,
        NO;

    }

    private static final class StringTokenStream
    extends TokenStream {
        private final CharTermAttribute termAttribute = this.addAttribute(CharTermAttribute.class);
        private final OffsetAttribute offsetAttribute = this.addAttribute(OffsetAttribute.class);
        private boolean used = true;
        private String value = null;

        StringTokenStream() {
        }

        void setValue(String value) {
            this.value = value;
        }

        @Override
        public boolean incrementToken() {
            if (this.used) {
                return false;
            }
            this.clearAttributes();
            this.termAttribute.append(this.value);
            this.offsetAttribute.setOffset(0, this.value.length());
            this.used = true;
            return true;
        }

        @Override
        public void end() throws IOException {
            super.end();
            int finalOffset = this.value.length();
            this.offsetAttribute.setOffset(finalOffset, finalOffset);
        }

        @Override
        public void reset() {
            this.used = false;
        }

        @Override
        public void close() {
            this.value = null;
        }
    }

    private static final class BinaryTokenStream
    extends TokenStream {
        private final BytesTermAttribute bytesAtt = this.addAttribute(BytesTermAttribute.class);
        private boolean used = true;
        private BytesRef value;

        BinaryTokenStream() {
        }

        public void setValue(BytesRef value) {
            this.value = value;
        }

        @Override
        public boolean incrementToken() {
            if (this.used) {
                return false;
            }
            this.clearAttributes();
            this.bytesAtt.setBytesRef(this.value);
            this.used = true;
            return true;
        }

        @Override
        public void reset() {
            this.used = false;
        }

        @Override
        public void close() {
            this.value = null;
        }
    }
}

