/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.codecs.lucene95;

import guideme.internal.shaded.lucene.codecs.hnsw.FlatVectorsScorer;
import guideme.internal.shaded.lucene.codecs.lucene90.IndexedDISI;
import guideme.internal.shaded.lucene.codecs.lucene95.OrdToDocDISIReaderConfiguration;
import guideme.internal.shaded.lucene.index.ByteVectorValues;
import guideme.internal.shaded.lucene.index.VectorEncoding;
import guideme.internal.shaded.lucene.index.VectorSimilarityFunction;
import guideme.internal.shaded.lucene.store.IndexInput;
import guideme.internal.shaded.lucene.store.RandomAccessInput;
import guideme.internal.shaded.lucene.util.hnsw.RandomAccessVectorValues;
import guideme.internal.shaded.lucene.util.packed.DirectMonotonicReader;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class OffHeapByteVectorValues
extends ByteVectorValues
implements RandomAccessVectorValues.Bytes {
    protected final int dimension;
    protected final int size;
    protected final IndexInput slice;
    protected int lastOrd = -1;
    protected final byte[] binaryValue;
    protected final ByteBuffer byteBuffer;
    protected final int byteSize;
    protected final VectorSimilarityFunction similarityFunction;
    protected final FlatVectorsScorer flatVectorsScorer;

    OffHeapByteVectorValues(int dimension, int size, IndexInput slice, int byteSize, FlatVectorsScorer flatVectorsScorer, VectorSimilarityFunction similarityFunction) {
        this.dimension = dimension;
        this.size = size;
        this.slice = slice;
        this.byteSize = byteSize;
        this.byteBuffer = ByteBuffer.allocate(byteSize);
        this.binaryValue = this.byteBuffer.array();
        this.similarityFunction = similarityFunction;
        this.flatVectorsScorer = flatVectorsScorer;
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public byte[] vectorValue(int targetOrd) throws IOException {
        if (this.lastOrd != targetOrd) {
            this.readValue(targetOrd);
            this.lastOrd = targetOrd;
        }
        return this.binaryValue;
    }

    private void readValue(int targetOrd) throws IOException {
        this.slice.seek((long)targetOrd * (long)this.byteSize);
        this.slice.readBytes(this.byteBuffer.array(), this.byteBuffer.arrayOffset(), this.byteSize);
    }

    public static OffHeapByteVectorValues load(VectorSimilarityFunction vectorSimilarityFunction, FlatVectorsScorer flatVectorsScorer, OrdToDocDISIReaderConfiguration configuration, VectorEncoding vectorEncoding, int dimension, long vectorDataOffset, long vectorDataLength, IndexInput vectorData) throws IOException {
        if (configuration.isEmpty() || vectorEncoding != VectorEncoding.BYTE) {
            return new EmptyOffHeapVectorValues(dimension, flatVectorsScorer, vectorSimilarityFunction);
        }
        IndexInput bytesSlice = vectorData.slice("vector-data", vectorDataOffset, vectorDataLength);
        if (configuration.isDense()) {
            return new DenseOffHeapVectorValues(dimension, configuration.size, bytesSlice, dimension, flatVectorsScorer, vectorSimilarityFunction);
        }
        return new SparseOffHeapVectorValues(configuration, vectorData, bytesSlice, dimension, dimension, flatVectorsScorer, vectorSimilarityFunction);
    }

    private static class EmptyOffHeapVectorValues
    extends OffHeapByteVectorValues {
        private int doc = -1;

        public EmptyOffHeapVectorValues(int dimension, FlatVectorsScorer flatVectorsScorer, VectorSimilarityFunction vectorSimilarityFunction) {
            super(dimension, 0, null, 0, flatVectorsScorer, vectorSimilarityFunction);
        }

        @Override
        public int dimension() {
            return super.dimension();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public byte[] vectorValue() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        @Override
        public int advance(int target) throws IOException {
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        @Override
        public EmptyOffHeapVectorValues copy() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] vectorValue(int targetOrd) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private static class SparseOffHeapVectorValues
    extends OffHeapByteVectorValues {
        private final DirectMonotonicReader ordToDoc;
        private final IndexedDISI disi;
        private final IndexInput dataIn;
        private final OrdToDocDISIReaderConfiguration configuration;

        public SparseOffHeapVectorValues(OrdToDocDISIReaderConfiguration configuration, IndexInput dataIn, IndexInput slice, int dimension, int byteSize, FlatVectorsScorer flatVectorsScorer, VectorSimilarityFunction vectorSimilarityFunction) throws IOException {
            super(dimension, configuration.size, slice, byteSize, flatVectorsScorer, vectorSimilarityFunction);
            this.configuration = configuration;
            RandomAccessInput addressesData = dataIn.randomAccessSlice(configuration.addressesOffset, configuration.addressesLength);
            this.dataIn = dataIn;
            this.ordToDoc = DirectMonotonicReader.getInstance(configuration.meta, addressesData);
            this.disi = new IndexedDISI(dataIn, configuration.docsWithFieldOffset, configuration.docsWithFieldLength, configuration.jumpTableEntryCount, configuration.denseRankPower, configuration.size);
        }

        @Override
        public byte[] vectorValue() throws IOException {
            return this.vectorValue(this.disi.index());
        }

        @Override
        public int docID() {
            return this.disi.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            return this.disi.nextDoc();
        }

        @Override
        public int advance(int target) throws IOException {
            assert (this.docID() < target);
            return this.disi.advance(target);
        }

        @Override
        public SparseOffHeapVectorValues copy() throws IOException {
            return new SparseOffHeapVectorValues(this.configuration, this.dataIn, this.slice.clone(), this.dimension, this.byteSize, this.flatVectorsScorer, this.similarityFunction);
        }
    }

    public static class DenseOffHeapVectorValues
    extends OffHeapByteVectorValues {
        private int doc = -1;

        public DenseOffHeapVectorValues(int dimension, int size, IndexInput slice, int byteSize, FlatVectorsScorer flatVectorsScorer, VectorSimilarityFunction vectorSimilarityFunction) {
            super(dimension, size, slice, byteSize, flatVectorsScorer, vectorSimilarityFunction);
        }

        @Override
        public byte[] vectorValue() throws IOException {
            return this.vectorValue(this.doc);
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        @Override
        public int advance(int target) throws IOException {
            assert (this.docID() < target);
            if (target >= this.size) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = target;
            return this.doc;
        }

        @Override
        public DenseOffHeapVectorValues copy() throws IOException {
            return new DenseOffHeapVectorValues(this.dimension, this.size, this.slice.clone(), this.byteSize, this.flatVectorsScorer, this.similarityFunction);
        }
    }
}

