/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.codecs.lucene912;

import guideme.internal.shaded.lucene.store.DataOutput;
import guideme.internal.shaded.lucene.store.IndexInput;
import java.io.IOException;

final class PostingsUtil {
    static void readVIntBlock(IndexInput docIn, long[] docBuffer, long[] freqBuffer, int num, boolean indexHasFreq, boolean decodeFreq) throws IOException {
        block3: {
            block2: {
                docIn.readGroupVInts(docBuffer, num);
                if (!indexHasFreq || !decodeFreq) break block2;
                for (int i = 0; i < num; ++i) {
                    freqBuffer[i] = docBuffer[i] & 1L;
                    int n = i;
                    docBuffer[n] = docBuffer[n] >> 1;
                    if (freqBuffer[i] != 0L) continue;
                    freqBuffer[i] = docIn.readVInt();
                }
                break block3;
            }
            if (!indexHasFreq) break block3;
            int i = 0;
            while (i < num) {
                int n = i++;
                docBuffer[n] = docBuffer[n] >> 1;
            }
        }
    }

    static void writeVIntBlock(DataOutput docOut, long[] docBuffer, long[] freqBuffer, int num, boolean writeFreqs) throws IOException {
        int i;
        if (writeFreqs) {
            for (i = 0; i < num; ++i) {
                docBuffer[i] = docBuffer[i] << 1 | (long)(freqBuffer[i] == 1L ? 1 : 0);
            }
        }
        docOut.writeGroupVInts(docBuffer, num);
        if (writeFreqs) {
            for (i = 0; i < num; ++i) {
                int freq = (int)freqBuffer[i];
                if (freq == 1) continue;
                docOut.writeVInt(freq);
            }
        }
    }
}

