/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import guideme.Guide;
import guideme.Guides;
import guideme.PageAnchor;
import guideme.PageCollection;
import guideme.color.ConstantColor;
import guideme.color.SymbolicColor;
import guideme.compiler.ParsedGuidePage;
import guideme.document.DefaultStyles;
import guideme.document.LytRect;
import guideme.document.block.AlignItems;
import guideme.document.block.LytDocument;
import guideme.document.block.LytHBox;
import guideme.document.block.LytParagraph;
import guideme.document.flow.LytFlowBreak;
import guideme.document.flow.LytFlowLink;
import guideme.internal.GuideME;
import guideme.internal.GuideMEClient;
import guideme.internal.GuidebookText;
import guideme.internal.screen.DocumentScreen;
import guideme.internal.screen.GlobalInMemoryHistory;
import guideme.internal.screen.GuideIconButton;
import guideme.internal.screen.GuideNavigation;
import guideme.internal.screen.GuideScreen;
import guideme.internal.screen.GuideScreenHistory;
import guideme.internal.screen.NavigationToolbar;
import guideme.internal.search.GuideSearch;
import guideme.internal.util.Blitter;
import guideme.internal.util.NavigationUtil;
import guideme.render.GuiAssets;
import guideme.render.RenderContext;
import guideme.scene.LytItemImage;
import guideme.style.BorderStyle;
import guideme.ui.GuideUiHost;
import guideme.ui.UiPoint;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class GuideSearchScreen
extends DocumentScreen {
    public static final ResourceLocation PAGE_ID = GuideME.makeId("search");
    private final EditBox searchField;
    private final Guide guide;
    private final NavigationToolbar toolbar;
    @Nullable
    private Screen returnToOnClose;
    private final LytDocument searchResultsDoc = new LytDocument();
    private final List<GuideSearch.SearchResult> searchResults = new ArrayList<GuideSearch.SearchResult>();

    GuideSearchScreen(Guide guide) {
        super((Component)Component.m_237113_((String)"AE2 Guidebook Search"));
        this.guide = guide;
        this.toolbar = new NavigationToolbar(guide);
        this.toolbar.setCloseCallback(this::m_7379_);
        GuideMEClient.instance().getSearch().index(guide);
        this.searchField = new EditBox(Minecraft.m_91087_().f_91062_, 16, 6, 0, 14, (Component)GuidebookText.Search.text());
        this.searchField.m_94182_(false);
        this.searchField.m_257771_((Component)GuidebookText.Search.text().m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC));
        this.searchField.m_94151_(this::search);
        this.m_264313_((GuiEventListener)this.searchField);
    }

    public static GuideSearchScreen open(Guide guide, @Nullable String anchor) {
        GuideScreenHistory history = GlobalInMemoryHistory.get(guide);
        history.push(new PageAnchor(PAGE_ID, anchor));
        GuideSearchScreen screen = new GuideSearchScreen(guide);
        if (anchor != null) {
            screen.searchField.m_94144_(anchor);
        }
        return screen;
    }

    @Override
    protected LytDocument getDocument() {
        return this.searchResultsDoc;
    }

    @Override
    public void navigateTo(ResourceLocation pageId) {
    }

    @Override
    public void navigateTo(PageAnchor anchor) {
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)this.searchField);
        this.toolbar.addToScreen(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
        this.toolbar.update();
        this.searchField.m_252865_(this.screenRect.x() + 16);
        this.searchField.m_93674_(this.screenRect.right() - this.searchField.m_252754_() - this.toolbar.getWidth());
        this.searchField.m_94196_(this.searchField.m_94207_());
        if (this.screenRect.isEmpty()) {
            return;
        }
        int left = this.screenRect.x();
        int documentTop = this.searchField.m_252907_() + this.searchField.m_93694_();
        int toolbarTop = (documentTop - this.toolbar.getHeight()) / 2;
        this.toolbar.move(this.screenRect.right() - this.toolbar.getWidth(), toolbarTop);
        this.setDocumentRect(new LytRect(left, documentTop, this.screenRect.right() - left, this.screenRect.height() - this.getMarginBottom()));
        this.updateDocumentLayout();
    }

    private void search(String query) {
        GlobalInMemoryHistory.get(this.guide).push(this.makeSearchAnchor());
        GuideSearch search = GuideMEClient.instance().getSearch();
        this.searchResults.clear();
        this.searchResults.addAll(search.searchGuide(query, this.guide));
        this.searchResultsDoc.clearContent();
        for (GuideSearch.SearchResult searchResult : this.searchResults) {
            ParsedGuidePage page;
            LytHBox searchResultItem = new LytHBox();
            searchResultItem.setFullWidth(true);
            searchResultItem.setGap(5);
            searchResultItem.setAlignItems(AlignItems.CENTER);
            Guide guide = Guides.getById(searchResult.guideId());
            if (guide == null || (page = guide.getParsedPage(searchResult.pageId())) == null) continue;
            ItemStack icon = NavigationUtil.createNavigationIcon(page);
            LytItemImage image = new LytItemImage();
            if (!icon.m_41619_()) {
                image.setItem(icon);
            }
            searchResultItem.append(image);
            LytParagraph summary = new LytParagraph();
            LytFlowLink documentLink = this.buildLinkToSearchResult(searchResult, guide, page);
            summary.append(documentLink);
            summary.append(new LytFlowBreak());
            summary.append(searchResult.text());
            summary.setPaddingTop(2);
            summary.setPaddingBottom(2);
            searchResultItem.append(summary);
            searchResultItem.setBorderBottom(new BorderStyle(SymbolicColor.TABLE_BORDER, 1));
            this.searchResultsDoc.append(searchResultItem);
        }
        this.updateDocumentLayout();
    }

    private LytFlowLink buildLinkToSearchResult(GuideSearch.SearchResult searchResult, Guide guide, ParsedGuidePage page) {
        LytFlowLink documentLink = new LytFlowLink();
        documentLink.appendText(searchResult.pageTitle());
        documentLink.setClickCallback(ignored -> {
            GuideUiHost guideHost;
            GuideScreenHistory history = GlobalInMemoryHistory.get(guide);
            history.push(this.makeSearchAnchor());
            Screen patt6743$temp = this.returnToOnClose;
            if (patt6743$temp instanceof GuideUiHost && (guideHost = (GuideUiHost)patt6743$temp).getGuide() == guide) {
                this.m_7379_();
                guideHost.navigateTo(page.getId());
            } else {
                this.returnToOnClose = GuideScreen.openNew(guide, PageAnchor.page(page.getId()));
                this.m_7379_();
            }
        });
        return documentLink;
    }

    @Override
    protected void scaledRender(GuiGraphics guiGraphics, RenderContext context, int mouseX, int mouseY, float partialTick) {
        context.fillIcon(this.screenRect, GuiAssets.GUIDE_BACKGROUND, SymbolicColor.GUIDE_SCREEN_BACKGROUND);
        Blitter.texture(GuideME.makeId("textures/guide/buttons.png"), 64, 64).src(GuideIconButton.Role.SEARCH.iconSrcX, GuideIconButton.Role.SEARCH.iconSrcY, 16, 16).dest(this.screenRect.x(), 2, 16, 16).colorArgb(context.resolveColor(SymbolicColor.ICON_BUTTON_NORMAL)).blit(guiGraphics);
        LytRect documentRect = this.getDocumentRect();
        context.fillRect(documentRect, new ConstantColor(-2144128205));
        if (this.searchField.m_94155_().isEmpty()) {
            context.renderTextCenteredIn(GuidebookText.SearchNoQuery.text().getString(), DefaultStyles.BODY_TEXT.mergeWith(DefaultStyles.BASE_STYLE), documentRect);
        } else if (this.searchResults.isEmpty()) {
            context.renderTextCenteredIn(GuidebookText.SearchNoResults.text().getString(), DefaultStyles.BODY_TEXT.mergeWith(DefaultStyles.BASE_STYLE), documentRect);
        } else {
            this.renderDocument(context);
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 200.0f);
        this.renderTitle(documentRect, context);
        super.scaledRender(guiGraphics, context, mouseX, mouseY, partialTick);
        poseStack.m_85849_();
        this.renderDocumentTooltip(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void m_280273_(GuiGraphics graphics) {
    }

    private void renderTitle(LytRect documentRect, RenderContext context) {
        LytRect separatorRect = new LytRect(documentRect.x(), documentRect.y() - 1, documentRect.width(), 1);
        separatorRect = separatorRect.withWidth(this.screenRect.width());
        context.fillRect(separatorRect, SymbolicColor.HEADER1_SEPARATOR);
    }

    private PageAnchor makeSearchAnchor() {
        if (this.searchField.m_94155_().isBlank()) {
            return PageAnchor.page(PAGE_ID);
        }
        return new PageAnchor(PAGE_ID, this.searchField.m_94155_());
    }

    @Override
    protected boolean documentClicked(UiPoint documentPoint, int button) {
        if (button == 3) {
            GuideNavigation.navigateBack(this.guide);
            return true;
        }
        if (button == 4) {
            GuideNavigation.navigateForward(this.guide);
            return true;
        }
        return false;
    }

    @Override
    public void m_7379_() {
        if (this.f_96541_ != null && this.f_96541_.f_91080_ == this && this.returnToOnClose != null) {
            this.f_96541_.m_91152_(this.returnToOnClose);
            this.returnToOnClose = null;
            return;
        }
        super.m_7379_();
    }

    public void setReturnToOnClose(@Nullable Screen screen) {
        this.returnToOnClose = screen;
    }

    @Nullable
    public Screen getReturnToOnClose() {
        return this.returnToOnClose;
    }

    @Override
    public PageCollection getGuide() {
        return this.guide;
    }

    @Override
    public void reloadPage() {
    }
}

