/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal;

import guideme.Guide;
import guideme.GuideItemSettings;
import guideme.GuidePage;
import guideme.GuidePageChange;
import guideme.compiler.PageCompiler;
import guideme.compiler.ParsedGuidePage;
import guideme.extensions.ExtensionCollection;
import guideme.indices.PageIndex;
import guideme.internal.GuideMEClient;
import guideme.internal.GuideSourceWatcher;
import guideme.internal.screen.GuideScreen;
import guideme.internal.util.LangUtil;
import guideme.navigation.NavigationTree;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MutableGuide
implements Guide {
    private static final Logger LOG = LoggerFactory.getLogger(MutableGuide.class);
    private final ResourceLocation id;
    private final String defaultNamespace;
    private final String folder;
    private final String defaultLanguage;
    private final ResourceLocation startPage;
    private final Map<ResourceLocation, ParsedGuidePage> developmentPages = new HashMap<ResourceLocation, ParsedGuidePage>();
    private final Map<Class<?>, PageIndex> indices;
    private NavigationTree navigationTree = new NavigationTree();
    private Map<ResourceLocation, ParsedGuidePage> pages;
    private final ExtensionCollection extensions;
    private final boolean availableToOpenHotkey;
    private final GuideItemSettings itemSettings;
    @Nullable
    private final Path developmentSourceFolder;
    @Nullable
    private final String developmentSourceNamespace;
    @Nullable
    private GuideSourceWatcher watcher;

    public MutableGuide(ResourceLocation id, String defaultNamespace, String folder, String defaultLanguage, ResourceLocation startPage, @Nullable Path developmentSourceFolder, @Nullable String developmentSourceNamespace, Map<Class<?>, PageIndex> indices, ExtensionCollection extensions, boolean availableToOpenHotkey, GuideItemSettings itemSettings) {
        this.id = id;
        this.defaultNamespace = defaultNamespace;
        this.folder = folder;
        this.defaultLanguage = defaultLanguage;
        this.startPage = startPage;
        this.developmentSourceFolder = developmentSourceFolder;
        this.developmentSourceNamespace = developmentSourceNamespace;
        this.indices = indices;
        this.extensions = extensions;
        this.availableToOpenHotkey = availableToOpenHotkey;
        this.itemSettings = itemSettings;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public ResourceLocation getStartPage() {
        return this.startPage;
    }

    @Override
    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    @Override
    public String getContentRootFolder() {
        return this.folder;
    }

    @Override
    public <T extends PageIndex> T getIndex(Class<T> indexClass) {
        PageIndex index = this.indices.get(indexClass);
        if (index == null) {
            throw new IllegalArgumentException("No index of type " + indexClass + " is registered with this guide.");
        }
        return (T)((PageIndex)indexClass.cast(index));
    }

    @Override
    @Nullable
    public ParsedGuidePage getParsedPage(ResourceLocation id) {
        if (this.pages == null) {
            LOG.warn("Can't get page {}. Pages not loaded yet.", (Object)id);
            return null;
        }
        return this.developmentPages.getOrDefault(id, this.pages.get(id));
    }

    @Override
    @Nullable
    public GuidePage getPage(ResourceLocation id) {
        ParsedGuidePage page = this.getParsedPage(id);
        return page != null ? PageCompiler.compile(this, this.extensions, page) : null;
    }

    @Override
    public Collection<ParsedGuidePage> getPages() {
        if (this.pages == null) {
            throw new IllegalStateException("Pages are not loaded yet.");
        }
        if (this.developmentPages.isEmpty()) {
            return this.pages.values();
        }
        LinkedHashMap<ResourceLocation, ParsedGuidePage> pages = new LinkedHashMap<ResourceLocation, ParsedGuidePage>(this.pages);
        pages.putAll(this.developmentPages);
        return pages.values();
    }

    @Override
    public byte[] loadAsset(ResourceLocation id) {
        byte[] result;
        String language = LangUtil.getCurrentLanguage();
        if (!GuideMEClient.instance().isIgnoreTranslatedGuides() && !Objects.equals(language, this.defaultLanguage) && (result = this.loadAssetInternal(id.m_246208_("_" + language + "/"))) != null) {
            return result;
        }
        return this.loadAssetInternal(id);
    }

    private byte @Nullable [] loadAssetInternal(ResourceLocation id) {
        byte[] byArray;
        block21: {
            block20: {
                if (this.developmentSourceFolder != null && id.m_135827_().equals(this.developmentSourceNamespace)) {
                    byte[] byArray2;
                    block19: {
                        Path path = this.developmentSourceFolder.resolve(id.m_135815_());
                        InputStream in2 = Files.newInputStream(path, new OpenOption[0]);
                        try {
                            byArray2 = in2.readAllBytes();
                            if (in2 == null) break block19;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (in2 != null) {
                                    try {
                                        in2.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (NoSuchFileException in2) {
                                break block20;
                            }
                            catch (IOException e) {
                                LOG.error("Failed to open guidebook asset {}", (Object)path);
                                return null;
                            }
                        }
                        in2.close();
                    }
                    return byArray2;
                }
            }
            id = new ResourceLocation(id.m_135827_(), this.folder + "/" + id.m_135815_());
            Resource resource = Minecraft.m_91087_().m_91098_().m_213713_(id).orElse(null);
            if (resource == null) {
                return null;
            }
            InputStream input = resource.m_215507_();
            try {
                byArray = input.readAllBytes();
                if (input == null) break block21;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error("Failed to open guidebook asset {}", (Object)id);
                    return null;
                }
            }
            input.close();
        }
        return byArray;
    }

    @Override
    public NavigationTree getNavigationTree() {
        return this.navigationTree;
    }

    @Override
    public boolean pageExists(ResourceLocation pageId) {
        return this.developmentPages.containsKey(pageId) || this.pages != null && this.pages.containsKey(pageId);
    }

    @Nullable
    public Path getDevelopmentSourcePath(ResourceLocation id) {
        Path path;
        if (this.developmentSourceFolder != null && id.m_135827_().equals(this.developmentSourceNamespace) && Files.exists(path = this.developmentSourceFolder.resolve(id.m_135815_()), new LinkOption[0])) {
            return path;
        }
        return null;
    }

    @Nullable
    public Path getDevelopmentSourceFolder() {
        return this.developmentSourceFolder;
    }

    @Override
    public ExtensionCollection getExtensions() {
        return this.extensions;
    }

    public boolean isAvailableToOpenHotkey() {
        return this.availableToOpenHotkey;
    }

    public void watchDevelopmentSources() {
        if (this.watcher != null) {
            return;
        }
        this.watcher = new GuideSourceWatcher(this.developmentSourceNamespace, this.defaultLanguage, this.developmentSourceFolder);
        Runtime.getRuntime().addShutdownHook(new Thread(this.watcher::close));
    }

    public void tick() {
        if (this.pages == null || this.watcher == null) {
            return;
        }
        List<GuidePageChange> changes = this.watcher.takeChanges(LangUtil.getCurrentLanguage());
        if (!changes.isEmpty()) {
            this.applyChanges(changes);
        }
    }

    private void applyChanges(List<GuidePageChange> changes) {
        PageIndex index2;
        for (int i = 0; i < changes.size(); ++i) {
            GuidePageChange change = changes.get(i);
            ResourceLocation pageId = change.pageId();
            ParsedGuidePage oldPage = change.newPage() != null ? this.developmentPages.put(pageId, change.newPage()) : this.developmentPages.remove(pageId);
            changes.set(i, new GuidePageChange(pageId, oldPage, change.newPage()));
        }
        ArrayList<ParsedGuidePage> allPages = new ArrayList<ParsedGuidePage>(this.pages.size() + this.developmentPages.size());
        allPages.addAll(this.pages.values());
        allPages.addAll(this.developmentPages.values());
        for (PageIndex index2 : this.indices.values()) {
            if (index2.supportsUpdate()) {
                index2.update(allPages, changes);
                continue;
            }
            index2.rebuild(allPages);
        }
        this.navigationTree = this.buildNavigation();
        index2 = Minecraft.m_91087_().f_91080_;
        if (index2 instanceof GuideScreen) {
            GuideScreen guideScreen = (GuideScreen)((Object)index2);
            ResourceLocation currentPageId = guideScreen.getCurrentPageId();
            if (changes.stream().anyMatch(c -> c.pageId().equals((Object)currentPageId))) {
                guideScreen.reloadPage();
            }
        }
    }

    private NavigationTree buildNavigation() {
        if (this.developmentPages.isEmpty()) {
            return NavigationTree.build(this.pages.values());
        }
        HashMap<ResourceLocation, ParsedGuidePage> allPages = new HashMap<ResourceLocation, ParsedGuidePage>(this.pages);
        allPages.putAll(this.developmentPages);
        return NavigationTree.build(allPages.values());
    }

    public void validateAll() {
        for (Map.Entry<ResourceLocation, ParsedGuidePage> entry : this.developmentPages.entrySet()) {
            LOG.info("Compiling {}", (Object)entry.getKey());
            this.getPage(entry.getKey());
        }
    }

    @ApiStatus.Internal
    public void rebuildIndices() {
        ArrayList<ParsedGuidePage> allPages = new ArrayList<ParsedGuidePage>(this.getPages());
        for (PageIndex index : this.indices.values()) {
            index.rebuild(allPages);
        }
    }

    public void setPages(Map<ResourceLocation, ParsedGuidePage> pages) {
        this.pages = Map.copyOf(pages);
        if (this.watcher != null) {
            this.watcher.clearChanges();
            for (ParsedGuidePage page : this.watcher.loadAll(this.defaultLanguage)) {
                this.developmentPages.put(page.getId(), page);
            }
        }
        this.rebuildIndices();
        this.navigationTree = this.buildNavigation();
    }

    public GuideItemSettings getItemSettings() {
        return this.itemSettings;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }
}

