/*
 * Decompiled with CFR 0.152.
 */
package guideme.compiler.tags;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import guideme.color.ColorValue;
import guideme.color.ConstantColor;
import guideme.compiler.PageCompiler;
import guideme.document.LytErrorSink;
import guideme.libs.mdast.mdx.model.MdxJsxAttribute;
import guideme.libs.mdast.mdx.model.MdxJsxAttributeNode;
import guideme.libs.mdast.mdx.model.MdxJsxElementFields;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class MdxAttrs {
    private static final Pattern COLOR_PATTERN = Pattern.compile("^#([0-9a-fA-F]{2}){3,4}$");

    private MdxAttrs() {
    }

    @Contract(value="_, _, _, _, !null -> !null")
    public static String getString(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, String attribute, String defaultValue) {
        MdxJsxAttribute id = el.getAttribute(attribute);
        if (id == null) {
            return defaultValue;
        }
        if (id.hasStringValue()) {
            return id.getStringValue();
        }
        if (id.hasExpressionValue()) {
            errorSink.appendError(compiler, "Expected string for '" + attribute + "' but got an expression.", el);
            return defaultValue;
        }
        return defaultValue;
    }

    @Contract(value="_, _, _, _, !null -> !null")
    public static CompoundTag getCompoundTag(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, String attribute, CompoundTag defaultValue) {
        String nbtString = MdxAttrs.getString(compiler, errorSink, el, attribute, null);
        if (nbtString == null) {
            return defaultValue;
        }
        try {
            return new TagParser(new StringReader(nbtString)).m_129373_();
        }
        catch (CommandSyntaxException e) {
            errorSink.appendError(compiler, e.getMessage(), el);
            return defaultValue;
        }
    }

    @Nullable
    public static ResourceLocation getRequiredId(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, String attribute) {
        String id = MdxAttrs.getString(compiler, errorSink, el, attribute, null);
        if (id == null) {
            errorSink.appendError(compiler, "Missing " + attribute + " attribute.", el);
            return null;
        }
        id = id.trim();
        try {
            return compiler.resolveId(id);
        }
        catch (ResourceLocationException e) {
            errorSink.appendError(compiler, "Malformed id " + id + ": " + e.getMessage(), el);
            return null;
        }
    }

    @Nullable
    public static Pair<ResourceLocation, Block> getRequiredBlockAndId(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, String attribute) {
        ResourceLocation itemId = MdxAttrs.getRequiredId(compiler, errorSink, el, attribute);
        Block resultItem = BuiltInRegistries.f_256975_.m_6612_(itemId).orElse(null);
        if (resultItem == null) {
            errorSink.appendError(compiler, "Missing block: " + itemId, el);
            return null;
        }
        return Pair.of((Object)itemId, (Object)resultItem);
    }

    @Nullable
    public static Pair<ResourceLocation, Item> getRequiredItemAndId(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, String attribute) {
        ResourceLocation itemId = MdxAttrs.getRequiredId(compiler, errorSink, el, attribute);
        Item resultItem = BuiltInRegistries.f_257033_.m_6612_(itemId).orElse(null);
        if (resultItem == null) {
            errorSink.appendError(compiler, "Missing item: " + itemId, el);
            return null;
        }
        return Pair.of((Object)itemId, (Object)resultItem);
    }

    @Nullable
    public static Pair<ResourceLocation, EntityType<?>> getRequiredEntityTypeAndId(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, String attribute) {
        ResourceLocation entityTypeId = MdxAttrs.getRequiredId(compiler, errorSink, el, attribute);
        EntityType resultType = BuiltInRegistries.f_256780_.m_6612_(entityTypeId).orElse(null);
        if (resultType == null) {
            errorSink.appendError(compiler, "Missing entity type: " + entityTypeId, el);
            return null;
        }
        return Pair.of((Object)entityTypeId, (Object)resultType);
    }

    @Nullable
    public static Item getRequiredItem(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, String attribute) {
        Pair<ResourceLocation, Item> result = MdxAttrs.getRequiredItemAndId(compiler, errorSink, el, attribute);
        if (result != null) {
            return (Item)result.getRight();
        }
        return null;
    }

    @Nullable
    public static ItemStack getRequiredItemStack(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el) {
        Item item = MdxAttrs.getRequiredItem(compiler, errorSink, el, "id");
        if (item == null) {
            return null;
        }
        CompoundTag tag = MdxAttrs.getCompoundTag(compiler, errorSink, el, "tag", null);
        return new ItemStack((ItemLike)item, 1, tag);
    }

    public static float getFloat(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, String name, float defaultValue) {
        String attrValue;
        MdxJsxAttribute attr = el.getAttribute(name);
        if (attr == null) {
            return defaultValue;
        }
        if (attr.hasExpressionValue()) {
            attrValue = attr.getExpressionValue();
        } else if (attr.hasStringValue()) {
            attrValue = attr.getStringValue();
        } else {
            return defaultValue;
        }
        try {
            return Float.parseFloat(attrValue);
        }
        catch (NumberFormatException e) {
            errorSink.appendError(compiler, "Malformed floating point value: '" + attrValue + "'", el);
            return defaultValue;
        }
    }

    @Contract(value="_, _, _, _, !null -> !null")
    @Nullable
    public static Vector3f getVector3(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, String name, @Nullable Vector3fc defaultValue) {
        String attrValue = MdxAttrs.getString(compiler, errorSink, el, name, null);
        if (attrValue == null) {
            return defaultValue != null ? new Vector3f(defaultValue) : null;
        }
        String[] parts = attrValue.trim().split("\\s+", 3);
        Vector3f result = new Vector3f();
        try {
            for (int i = 0; i < parts.length; ++i) {
                float v = Float.parseFloat(parts[i]);
                result.setComponent(i, v);
            }
        }
        catch (NumberFormatException e) {
            errorSink.appendError(compiler, "Malformed 3D vector: '" + attrValue + "'", el);
            return defaultValue != null ? new Vector3f(defaultValue) : null;
        }
        return result;
    }

    @Contract(value="_, _, _, _, !null -> !null")
    @Nullable
    public static Vector2f getVector2(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, String name, @Nullable Vector2fc defaultValue) {
        String attrValue = MdxAttrs.getString(compiler, errorSink, el, name, null);
        if (attrValue == null) {
            return defaultValue != null ? new Vector2f(defaultValue) : null;
        }
        String[] parts = attrValue.trim().split("\\s+", 2);
        Vector2f result = new Vector2f();
        try {
            for (int i = 0; i < parts.length; ++i) {
                float v = Float.parseFloat(parts[i]);
                result.setComponent(i, v);
            }
        }
        catch (NumberFormatException e) {
            errorSink.appendError(compiler, "Malformed 2D vector: '" + attrValue + "'", el);
            return defaultValue != null ? new Vector2f(defaultValue) : null;
        }
        return result;
    }

    public static int getInt(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, String name, int defaultValue) {
        String attrValue = MdxAttrs.getString(compiler, errorSink, el, name, null);
        if (attrValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(attrValue);
        }
        catch (NumberFormatException e) {
            errorSink.appendError(compiler, "Malformed integer value: '" + attrValue + "'", el);
            return defaultValue;
        }
    }

    @Nullable
    public static <T extends Enum<T>> T getEnum(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, String name, T defaultValue) {
        String stringValue = MdxAttrs.getString(compiler, errorSink, el, name, ((StringRepresentable)defaultValue).m_7912_());
        Class<?> clazz = defaultValue.getClass();
        for (Enum constant : (Enum[])clazz.getEnumConstants()) {
            if (!((StringRepresentable)constant).m_7912_().equals(stringValue)) continue;
            return (T)constant;
        }
        errorSink.appendError(compiler, "Unrecognized option for attribute " + name + ": " + stringValue, el);
        return null;
    }

    public static BlockState applyBlockStateProperties(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, BlockState state) {
        for (MdxJsxAttributeNode attrNode : el.attributes()) {
            if (!(attrNode instanceof MdxJsxAttribute)) continue;
            MdxJsxAttribute attr = (MdxJsxAttribute)attrNode;
            String attrName = attr.name;
            if (!attrName.startsWith("p:")) continue;
            String statePropertyName = attrName.substring("p:".length());
            StateDefinition stateDefinition = state.m_60734_().m_49965_();
            Property property = stateDefinition.m_61081_(statePropertyName);
            if (property == null) {
                errorSink.appendError(compiler, "block doesn't have property " + statePropertyName, el);
                continue;
            }
            state = MdxAttrs.applyProperty(compiler, errorSink, el, state, property, attr.getStringValue());
        }
        return state;
    }

    private static <T extends Comparable<T>> BlockState applyProperty(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, BlockState state, Property<T> property, String stringValue) {
        Optional propertyValue = property.m_6215_(stringValue);
        if (propertyValue.isEmpty()) {
            errorSink.appendError(compiler, "Invalid value  for property " + property + ": " + stringValue, el);
            return state;
        }
        return (BlockState)state.m_61124_(property, (Comparable)propertyValue.get());
    }

    public static BlockPos getPos(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el) {
        int x = MdxAttrs.getInt(compiler, errorSink, el, "x", 0);
        int y = MdxAttrs.getInt(compiler, errorSink, el, "y", 0);
        int z = MdxAttrs.getInt(compiler, errorSink, el, "z", 0);
        return new BlockPos(x, y, z);
    }

    public static void getFloatPos(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, Vector3f out) {
        out.x = MdxAttrs.getFloat(compiler, errorSink, el, "x", out.x);
        out.y = MdxAttrs.getFloat(compiler, errorSink, el, "y", out.y);
        out.z = MdxAttrs.getFloat(compiler, errorSink, el, "z", out.z);
    }

    public static ColorValue getColor(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, String name, ColorValue defaultColor) {
        String colorStr = MdxAttrs.getString(compiler, errorSink, el, name, null);
        if (colorStr != null) {
            int b;
            int g;
            int r;
            if ("transparent".equals(colorStr)) {
                return new ConstantColor(0);
            }
            Matcher m = COLOR_PATTERN.matcher(colorStr);
            if (!m.matches()) {
                errorSink.appendError(compiler, "Color must have format #AARRGGBB", el);
                return defaultColor;
            }
            int a = 255;
            if (colorStr.length() == 7) {
                r = Integer.valueOf(colorStr.substring(1, 3), 16);
                g = Integer.valueOf(colorStr.substring(3, 5), 16);
                b = Integer.valueOf(colorStr.substring(5, 7), 16);
            } else {
                a = Integer.valueOf(colorStr.substring(1, 3), 16);
                r = Integer.valueOf(colorStr.substring(3, 5), 16);
                g = Integer.valueOf(colorStr.substring(5, 7), 16);
                b = Integer.valueOf(colorStr.substring(7, 9), 16);
            }
            return new ConstantColor(FastColor.ARGB32.m_13660_((int)a, (int)r, (int)g, (int)b));
        }
        return defaultColor;
    }

    public static boolean getBoolean(PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el, String name, boolean defaultValue) {
        MdxJsxAttribute attribute = el.getAttribute(name);
        if (attribute == null) {
            return defaultValue;
        }
        if (attribute.hasExpressionValue()) {
            String expressionValue = attribute.getExpressionValue();
            if (expressionValue.equals("true")) {
                return true;
            }
            if (expressionValue.equals("false")) {
                return false;
            }
        }
        errorSink.appendError(compiler, name + " should be {true} or {false}", el);
        return defaultValue;
    }
}

