/*
 * Decompiled with CFR 0.152.
 */
package guideme.compiler.tags;

import guideme.compiler.PageCompiler;
import guideme.compiler.tags.BlockTagCompiler;
import guideme.compiler.tags.MdxAttrs;
import guideme.compiler.tags.RecipeTypeMappingSupplier;
import guideme.document.block.LytBlock;
import guideme.document.block.LytBlockContainer;
import guideme.internal.util.Platform;
import guideme.libs.mdast.mdx.model.MdxJsxElementFields;
import guideme.libs.mdast.model.MdAstNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecipeCompiler
extends BlockTagCompiler {
    private static final Logger LOG = LoggerFactory.getLogger(RecipeCompiler.class);
    @Nullable
    private List<RecipeTypeMapping<?, ?>> sharedMappings;

    @Override
    public Set<String> getTagNames() {
        return Set.of("Recipe", "RecipeFor");
    }

    @Override
    protected void compile(PageCompiler compiler, LytBlockContainer parent, MdxJsxElementFields el) {
        RecipeManager recipeManager = Platform.getClientRecipeManager();
        if (recipeManager == null) {
            parent.appendError(compiler, "Cannot show recipe while not in-game", el);
            return;
        }
        if ("RecipeFor".equals(el.name())) {
            Pair<ResourceLocation, Item> itemAndId = MdxAttrs.getRequiredItemAndId(compiler, parent, el, "id");
            if (itemAndId == null) {
                return;
            }
            ResourceLocation id = (ResourceLocation)itemAndId.getLeft();
            Item item = (Item)itemAndId.getRight();
            for (RecipeTypeMapping<?, ?> mapping : this.getMappings(compiler)) {
                LytBlock block = mapping.tryCreate(recipeManager, item);
                if (block == null) continue;
                block.setSourceNode((MdAstNode)((Object)el));
                parent.append(block);
                return;
            }
            parent.appendError(compiler, "Couldn't find recipe for " + id, el);
        } else {
            ResourceLocation recipeId = MdxAttrs.getRequiredId(compiler, parent, el, "id");
            if (recipeId == null) {
                return;
            }
            Recipe recipe = recipeManager.byKey(recipeId).orElse(null);
            if (recipe == null) {
                parent.appendError(compiler, "Couldn't find recipe " + recipeId, el);
                return;
            }
            for (RecipeTypeMapping<?, ?> mapping : this.getMappings(compiler)) {
                LytBlock block = mapping.tryCreate(recipe);
                if (block == null) continue;
                block.setSourceNode((MdAstNode)((Object)el));
                parent.append(block);
                return;
            }
            parent.appendError(compiler, "Couldn't find a handler for recipe " + recipeId, el);
        }
    }

    private Iterable<RecipeTypeMapping<?, ?>> getMappings(PageCompiler compiler) {
        final ArrayList result = new ArrayList();
        RecipeTypeMappingSupplier.RecipeTypeMappings mappings = new RecipeTypeMappingSupplier.RecipeTypeMappings(){

            @Override
            public <T extends Recipe<C>, C extends Container> void add(RecipeType<T> recipeType, Function<? super T, LytBlock> factory) {
                result.add(new RecipeTypeMapping(recipeType, factory));
            }
        };
        for (RecipeTypeMappingSupplier extension : compiler.getExtensions(RecipeTypeMappingSupplier.EXTENSION_POINT)) {
            extension.collect(mappings);
        }
        result.addAll(this.getSharedMappings());
        return result;
    }

    private List<? extends RecipeTypeMapping<?, ?>> getSharedMappings() {
        if (this.sharedMappings != null) {
            return this.sharedMappings;
        }
        final HashSet recipeTypes = new HashSet();
        final ArrayList result = new ArrayList();
        RecipeTypeMappingSupplier.RecipeTypeMappings mappings = new RecipeTypeMappingSupplier.RecipeTypeMappings(){

            @Override
            public <T extends Recipe<C>, C extends Container> void add(RecipeType<T> recipeType, Function<? super T, LytBlock> factory) {
                Objects.requireNonNull(recipeType, "recipeType");
                Objects.requireNonNull(factory, "factory");
                recipeTypes.add(BuiltInRegistries.RECIPE_TYPE.getKey(recipeType));
                result.add(new RecipeTypeMapping(recipeType, factory));
            }
        };
        Iterator it = ServiceLoader.load(RecipeTypeMappingSupplier.class).stream().iterator();
        while (it.hasNext()) {
            ServiceLoader.Provider provider = (ServiceLoader.Provider)it.next();
            try {
                ((RecipeTypeMappingSupplier)provider.get()).collect(mappings);
            }
            catch (Exception e) {
                LOG.error("Failed to collect shared recipe type mappings from {}", provider.type(), (Object)e);
            }
        }
        ArrayList recipeTypesSorted = new ArrayList(recipeTypes);
        Collections.sort(recipeTypesSorted);
        LOG.info("Discovered shared recipe type mappings: {}", recipeTypesSorted);
        this.sharedMappings = List.copyOf(result);
        return this.sharedMappings;
    }

    private record RecipeTypeMapping<T extends Recipe<C>, C extends Container>(RecipeType<T> recipeType, Function<? super T, LytBlock> factory) {
        @Nullable
        LytBlock tryCreate(RecipeManager recipeManager, Item resultItem) {
            RegistryAccess registryAccess = Platform.getClientRegistryAccess();
            ArrayList<Recipe> fallbackCandidates = new ArrayList<Recipe>();
            for (Recipe recipe : recipeManager.byType(this.recipeType).values()) {
                if (recipe.isSpecial()) {
                    fallbackCandidates.add(recipe);
                    continue;
                }
                if (recipe.getResultItem(registryAccess).getItem() != resultItem) continue;
                return this.factory.apply(recipe);
            }
            for (Recipe recipe : fallbackCandidates) {
                if (recipe.getResultItem(registryAccess).getItem() != resultItem) continue;
                return this.factory.apply(recipe);
            }
            return null;
        }

        @Nullable
        LytBlock tryCreate(Recipe<?> recipe) {
            if (this.recipeType == recipe.getType()) {
                return this.factory.apply(recipe);
            }
            return null;
        }
    }
}

