/*
 * Decompiled with CFR 0.152.
 */
package guideme.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import guideme.color.LightDarkMode;
import guideme.render.GuiAssets;
import guideme.render.GuiSprite;
import guideme.render.GuiSpriteScaling;
import guideme.render.SpriteFillDirection;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;

final class SpriteLayer {
    private final ResourceLocation atlasLocation = GuiAssets.GUI_SPRITE_ATLAS;
    private BufferBuilder builder = Tesselator.m_85913_().m_85915_();

    public SpriteLayer() {
        this.builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
    }

    public void fillSprite(ResourceLocation id, float x, float y, float z, float width, float height, int color) {
        this.fillSprite(id, x, y, z, width, height, color, SpriteFillDirection.TOP_TO_BOTTOM);
    }

    public void fillSprite(ResourceLocation id, float x, float y, float z, float width, float height, int color, SpriteFillDirection fillDirection) {
        width = Math.min(65535.0f, width);
        height = Math.min(65535.0f, height);
        GuiSprite guiSprite = GuiAssets.sprite(id);
        GuiSpriteScaling scaling = guiSprite.spriteScaling();
        TextureAtlasSprite sprite = guiSprite.atlasSprite(LightDarkMode.current());
        float u0 = sprite.m_118409_();
        float u1 = sprite.m_118410_();
        float v0 = sprite.m_118411_();
        float v1 = sprite.m_118412_();
        if (scaling instanceof GuiSpriteScaling.Tile) {
            GuiSpriteScaling.Tile tiled = (GuiSpriteScaling.Tile)scaling;
            this.fillTiled(x, y, z, width, height, color, tiled.width(), tiled.height(), u0, u1, v0, v1, fillDirection);
        } else if (scaling instanceof GuiSpriteScaling.Stretch) {
            GuiSpriteScaling.Stretch stretch = (GuiSpriteScaling.Stretch)scaling;
            this.addQuad(x, y, z, width, height, color, u0, u1, v0, v1);
        } else if (scaling instanceof GuiSpriteScaling.NineSlice) {
            GuiSpriteScaling.NineSlice nineSlice = (GuiSpriteScaling.NineSlice)scaling;
            this.addTiledNineSlice(id, x, y, z, width, height, color, nineSlice.width(), nineSlice.height(), nineSlice.border(), u0, u1, v0, v1);
        }
    }

    private void addTiledNineSlice(ResourceLocation id, float x, float y, float z, float width, float height, int color, float nineSliceWidth, float nineSliceHeight, GuiSpriteScaling.NineSlice.Border border, float u0, float u1, float v0, float v1) {
        float leftWidth = Math.min((float)border.left(), width / 2.0f);
        float rightWidth = Math.min((float)border.right(), width / 2.0f);
        float topHeight = Math.min((float)border.top(), height / 2.0f);
        float bottomHeight = Math.min((float)border.bottom(), height / 2.0f);
        float innerWidth = nineSliceWidth - (float)border.left() - (float)border.right();
        float innerHeight = nineSliceHeight - (float)border.top() - (float)border.bottom();
        float leftU = u0 + leftWidth / nineSliceWidth * (u1 - u0);
        float rightU = u1 - rightWidth / nineSliceWidth * (u1 - u0);
        float topV = v0 + topHeight / nineSliceHeight * (v1 - v0);
        float bottomV = v1 - bottomHeight / nineSliceHeight * (v1 - v0);
        float dstInnerLeft = x + leftWidth;
        float dstInnerTop = y + topHeight;
        float dstInnerRight = x + width - rightWidth;
        float dstInnerBottom = y + height - bottomHeight;
        float dstInnerWidth = dstInnerRight - dstInnerLeft;
        float dstInnerHeight = dstInnerBottom - dstInnerTop;
        this.addQuad(x, y, z, leftWidth, topHeight, color, u0, leftU, v0, topV);
        this.addQuad(dstInnerRight, y, z, rightWidth, topHeight, color, rightU, u1, v0, topV);
        this.addQuad(dstInnerRight, dstInnerBottom, z, rightWidth, bottomHeight, color, rightU, u1, bottomV, v1);
        this.addQuad(x, dstInnerBottom, z, leftWidth, bottomHeight, color, u0, leftU, bottomV, v1);
        this.fillTiled(dstInnerLeft, y, z, dstInnerWidth, topHeight, color, innerWidth, border.top(), leftU, rightU, v0, topV);
        this.fillTiled(dstInnerLeft, dstInnerBottom, z, dstInnerWidth, bottomHeight, color, innerWidth, border.bottom(), leftU, rightU, bottomV, v1);
        this.fillTiled(x, dstInnerTop, z, leftWidth, dstInnerHeight, color, border.left(), innerHeight, u0, leftU, topV, bottomV);
        this.fillTiled(dstInnerRight, dstInnerTop, z, rightWidth, dstInnerHeight, color, border.right(), innerHeight, rightU, u1, topV, bottomV);
        this.fillTiled(dstInnerLeft, dstInnerTop, z, dstInnerWidth, dstInnerHeight, color, innerWidth, innerHeight, leftU, rightU, topV, bottomV);
    }

    private void fillTiled(float x, float y, float z, float width, float height, int color, float destTileWidth, float destTileHeight, float u0, float u1, float v0, float v1) {
        this.fillTiled(x, y, z, width, height, color, destTileWidth, destTileHeight, u0, u1, v0, v1, SpriteFillDirection.TOP_TO_BOTTOM);
    }

    private void fillTiled(float x, float y, float z, float width, float height, int color, float destTileWidth, float destTileHeight, float u0, float u1, float v0, float v1, SpriteFillDirection fillDirection) {
        if (destTileWidth <= 0.0f || destTileHeight <= 0.0f) {
            return;
        }
        float right = x + width;
        float bottom = y + height;
        if (fillDirection == SpriteFillDirection.BOTTOM_TO_TOP) {
            for (float cy = bottom; cy >= y; cy -= destTileHeight) {
                float tileHeight = Math.min(cy - y, destTileHeight);
                float tileV0 = v1 - (v1 - v0) * tileHeight / destTileHeight;
                for (float cx = x; cx < right; cx += destTileWidth) {
                    float tileWidth = Math.min(right - cx, destTileWidth);
                    float tileU1 = u0 + (u1 - u0) * tileWidth / destTileWidth;
                    this.addQuad(cx, cy - tileHeight, z, tileWidth, tileHeight, color, u0, tileU1, tileV0, v1);
                }
            }
        } else {
            for (float cy = y; cy < bottom; cy += destTileHeight) {
                float tileHeight = Math.min(bottom - cy, destTileHeight);
                float tileV1 = v0 + (v1 - v0) * tileHeight / destTileHeight;
                for (float cx = x; cx < right; cx += destTileWidth) {
                    float tileWidth = Math.min(right - cx, destTileWidth);
                    float tileU1 = u0 + (u1 - u0) * tileWidth / destTileWidth;
                    this.addQuad(cx, cy, z, tileWidth, tileHeight, color, u0, tileU1, v0, tileV1);
                }
            }
        }
    }

    public void addQuad(float x, float y, float z, float width, float height, int color, float minU, float maxU, float minV, float maxV) {
        if (width < 0.0f || height < 0.0f) {
            return;
        }
        this.builder.m_5483_((double)x, (double)y, (double)z).m_7421_(minU, minV).m_193479_(color).m_5752_();
        this.builder.m_5483_((double)x, (double)(y + height), (double)z).m_7421_(minU, maxV).m_193479_(color).m_5752_();
        this.builder.m_5483_((double)(x + width), (double)(y + height), (double)z).m_7421_(maxU, maxV).m_193479_(color).m_5752_();
        this.builder.m_5483_((double)(x + width), (double)y, (double)z).m_7421_(maxU, minV).m_193479_(color).m_5752_();
    }

    public void render(PoseStack poseStack, int x, int y, int z) {
        if (this.builder == null) {
            throw new IllegalStateException("Already rendered.");
        }
        BufferBuilder.RenderedBuffer meshData = this.builder.m_231168_();
        this.builder = null;
        if (meshData == null) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.atlasLocation);
        RenderSystem.setShader(GameRenderer::m_172820_);
        PoseStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.m_85836_();
        modelViewStack.m_252931_(poseStack.m_85850_().m_252922_());
        modelViewStack.m_252880_((float)x, (float)y, (float)z);
        RenderSystem.applyModelViewMatrix();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)meshData);
        modelViewStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }
}

