/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util.automaton;

import guideme.internal.shaded.lucene.util.BytesRefIterator;
import guideme.internal.shaded.lucene.util.automaton.Automaton;
import guideme.internal.shaded.lucene.util.automaton.DaciukMihovAutomatonBuilder;
import guideme.internal.shaded.lucene.util.automaton.Operations;
import java.io.IOException;

public final class Automata {
    private Automata() {
    }

    public static Automaton makeEmpty() {
        Automaton a = new Automaton();
        a.finishState();
        return a;
    }

    public static Automaton makeAnyString() {
        Automaton a = new Automaton();
        int s = a.createState();
        a.setAccept(s, true);
        a.addTransition(s, s, 0, 0x10FFFF);
        a.finishState();
        return a;
    }

    public static Automaton makeAnyChar() {
        return Automata.makeCharRange(0, 0x10FFFF);
    }

    public static Automaton makeChar(int c) {
        return Automata.makeCharRange(c, c);
    }

    public static Automaton makeCharRange(int min, int max) {
        if (min > max) {
            return Automata.makeEmpty();
        }
        Automaton a = new Automaton();
        int s1 = a.createState();
        int s2 = a.createState();
        a.setAccept(s2, true);
        a.addTransition(s1, s2, min, max);
        a.finishState();
        return a;
    }

    public static Automaton makeString(String s) {
        Automaton a = new Automaton();
        int lastState = a.createState();
        int cp = 0;
        for (int i = 0; i < s.length(); i += Character.charCount(cp)) {
            int state = a.createState();
            cp = s.codePointAt(i);
            a.addTransition(lastState, state, cp);
            lastState = state;
        }
        a.setAccept(lastState, true);
        a.finishState();
        assert (a.isDeterministic());
        assert (!Operations.hasDeadStates(a));
        return a;
    }

    public static Automaton makeBinaryStringUnion(BytesRefIterator utf8Strings) throws IOException {
        return DaciukMihovAutomatonBuilder.build(utf8Strings, true);
    }
}

