/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.search.AutomatonQuery;
import guideme.internal.shaded.lucene.util.automaton.Automata;
import guideme.internal.shaded.lucene.util.automaton.Automaton;
import guideme.internal.shaded.lucene.util.automaton.Operations;
import java.util.ArrayList;

public class WildcardQuery
extends AutomatonQuery {
    public WildcardQuery(Term term) {
        super(term, WildcardQuery.toAutomaton(term));
    }

    public static Automaton toAutomaton(Term wildcardquery) {
        int length;
        ArrayList<Automaton> automata = new ArrayList<Automaton>();
        String wildcardText = wildcardquery.text();
        block5: for (int i = 0; i < wildcardText.length(); i += length) {
            int c = wildcardText.codePointAt(i);
            length = Character.charCount(c);
            switch (c) {
                case 42: {
                    automata.add(Automata.makeAnyString());
                    continue block5;
                }
                case 63: {
                    automata.add(Automata.makeAnyChar());
                    continue block5;
                }
                case 92: {
                    if (i + length < wildcardText.length()) {
                        int nextChar = wildcardText.codePointAt(i + length);
                        length += Character.charCount(nextChar);
                        automata.add(Automata.makeChar(nextChar));
                        continue block5;
                    }
                }
                default: {
                    automata.add(Automata.makeChar(c));
                }
            }
        }
        return Operations.concatenate(automata);
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        if (!this.getField().equals(field)) {
            buffer.append(this.getField());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        return buffer.toString();
    }
}

