/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.IndexReaderContext;
import guideme.internal.shaded.lucene.index.LeafReader;
import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.ReaderUtil;
import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.index.TermState;
import guideme.internal.shaded.lucene.index.TermStates;
import guideme.internal.shaded.lucene.index.TermsEnum;
import guideme.internal.shaded.lucene.search.CollectionStatistics;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.LeafSimScorer;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.QueryVisitor;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.Scorer;
import guideme.internal.shaded.lucene.search.ScorerSupplier;
import guideme.internal.shaded.lucene.search.TermScorer;
import guideme.internal.shaded.lucene.search.TermStatistics;
import guideme.internal.shaded.lucene.search.Weight;
import guideme.internal.shaded.lucene.search.similarities.Similarity;
import java.io.IOException;
import java.util.Objects;

public class TermQuery
extends Query {
    private final Term term;
    private final TermStates perReaderTermState;

    public TermQuery(Term t) {
        this.term = Objects.requireNonNull(t);
        this.perReaderTermState = null;
    }

    public TermQuery(Term t, TermStates states) {
        assert (states != null);
        this.term = Objects.requireNonNull(t);
        this.perReaderTermState = Objects.requireNonNull(states);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        IndexReaderContext context = searcher.getTopReaderContext();
        TermStates termState = this.perReaderTermState == null || !this.perReaderTermState.wasBuiltFor(context) ? TermStates.build(searcher, this.term, scoreMode.needsScores()) : this.perReaderTermState;
        return new TermWeight(searcher, scoreMode, boost, termState);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.term.field())) {
            visitor.consumeTerms(this, this.term);
        }
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        return buffer.toString();
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.term.equals(((TermQuery)other).term);
    }

    @Override
    public int hashCode() {
        return this.classHash() ^ this.term.hashCode();
    }

    final class TermWeight
    extends Weight {
        private final Similarity similarity;
        private final Similarity.SimScorer simScorer;
        private final TermStates termStates;
        private final ScoreMode scoreMode;

        public TermWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost, TermStates termStates) throws IOException {
            TermStatistics termStats;
            CollectionStatistics collectionStats;
            super(TermQuery.this);
            if (scoreMode.needsScores() && termStates == null) {
                throw new IllegalStateException("termStates are required when scores are needed");
            }
            this.scoreMode = scoreMode;
            this.termStates = termStates;
            this.similarity = searcher.getSimilarity();
            if (scoreMode.needsScores()) {
                collectionStats = searcher.collectionStatistics(TermQuery.this.term.field());
                termStats = termStates.docFreq() > 0 ? searcher.termStatistics(TermQuery.this.term, termStates.docFreq(), termStates.totalTermFreq()) : null;
            } else {
                collectionStats = new CollectionStatistics(TermQuery.this.term.field(), 1L, 1L, 1L, 1L);
                termStats = new TermStatistics(TermQuery.this.term.bytes(), 1L, 1L);
            }
            this.simScorer = termStats == null ? null : (scoreMode.needsScores() ? this.similarity.scorer(boost, collectionStats, termStats) : new Similarity.SimScorer(){

                @Override
                public float score(float freq, long norm) {
                    return 0.0f;
                }
            });
        }

        public String toString() {
            return "weight(" + TermQuery.this + ")";
        }

        @Override
        public ScorerSupplier scorerSupplier(final LeafReaderContext context) throws IOException {
            assert (this.termStates == null || this.termStates.wasBuiltFor(ReaderUtil.getTopLevelContext(context))) : "The top-reader used to create Weight is not the same as the current reader's top-reader (" + ReaderUtil.getTopLevelContext(context);
            final TermsEnum termsEnum = this.getTermsEnum(context);
            if (termsEnum == null) {
                return null;
            }
            final int docFreq = termsEnum.docFreq();
            return new ScorerSupplier(){
                private boolean topLevelScoringClause = false;

                @Override
                public Scorer get(long leadCost) throws IOException {
                    LeafSimScorer scorer = new LeafSimScorer(TermWeight.this.simScorer, context.reader(), TermQuery.this.term.field(), TermWeight.this.scoreMode.needsScores());
                    if (TermWeight.this.scoreMode == ScoreMode.TOP_SCORES) {
                        return new TermScorer(TermWeight.this, termsEnum.impacts(8), scorer, this.topLevelScoringClause);
                    }
                    return new TermScorer(TermWeight.this, termsEnum.postings(null, TermWeight.this.scoreMode.needsScores() ? 8 : 0), scorer);
                }

                @Override
                public long cost() {
                    return docFreq;
                }

                @Override
                public void setTopLevelScoringClause() throws IOException {
                    this.topLevelScoringClause = true;
                }
            };
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            ScorerSupplier supplier = this.scorerSupplier(context);
            if (supplier == null) {
                return null;
            }
            return supplier.get(Long.MAX_VALUE);
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return true;
        }

        private TermsEnum getTermsEnum(LeafReaderContext context) throws IOException {
            assert (this.termStates != null);
            assert (this.termStates.wasBuiltFor(ReaderUtil.getTopLevelContext(context))) : "The top-reader used to create Weight is not the same as the current reader's top-reader (" + ReaderUtil.getTopLevelContext(context);
            TermState state = this.termStates.get(context);
            if (state == null) {
                assert (this.termNotInReader(context.reader(), TermQuery.this.term)) : "no termstate found but term exists in reader term=" + TermQuery.this.term;
                return null;
            }
            TermsEnum termsEnum = context.reader().terms(TermQuery.this.term.field()).iterator();
            termsEnum.seekExact(TermQuery.this.term.bytes(), state);
            return termsEnum;
        }

        private boolean termNotInReader(LeafReader reader, Term term) throws IOException {
            return reader.docFreq(term) == 0;
        }
    }
}

