/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.index.IndexSorter;
import guideme.internal.shaded.lucene.search.Sort;
import guideme.internal.shaded.lucene.util.TimSorter;
import guideme.internal.shaded.lucene.util.packed.PackedLongValues;
import java.io.IOException;

public final class Sorter {
    final Sort sort;

    Sorter(Sort sort) {
        if (sort.needsScores()) {
            throw new IllegalArgumentException("Cannot sort an index with a Sort that refers to the relevance score");
        }
        this.sort = sort;
    }

    static boolean isConsistent(DocMap docMap) {
        int maxDoc = docMap.size();
        for (int i = 0; i < maxDoc; ++i) {
            int newID = docMap.oldToNew(i);
            int oldID = docMap.newToOld(newID);
            assert (newID >= 0 && newID < maxDoc) : "doc IDs must be in [0-" + maxDoc + "[, got " + newID;
            assert (i == oldID) : "mapping is inconsistent: " + i + " --oldToNew--> " + newID + " --newToOld--> " + oldID;
            if (i == oldID && newID >= 0 && newID < maxDoc) continue;
            return false;
        }
        return true;
    }

    private static DocMap sort(final int maxDoc, IndexSorter.DocComparator comparator) {
        boolean sorted = true;
        for (int i = 1; i < maxDoc; ++i) {
            if (comparator.compare(i - 1, i) <= 0) continue;
            sorted = false;
            break;
        }
        if (sorted) {
            return null;
        }
        int[] docs = new int[maxDoc];
        for (int i = 0; i < maxDoc; ++i) {
            docs[i] = i;
        }
        DocValueSorter sorter = new DocValueSorter(docs, comparator);
        sorter.sort(0, docs.length);
        PackedLongValues.Builder newToOldBuilder = PackedLongValues.monotonicBuilder(0.0f);
        for (int i = 0; i < maxDoc; ++i) {
            newToOldBuilder.add(docs[i]);
        }
        final PackedLongValues newToOld = newToOldBuilder.build();
        for (int i = 0; i < maxDoc; ++i) {
            docs[(int)newToOld.get((long)((long)i))] = i;
        }
        PackedLongValues.Builder oldToNewBuilder = PackedLongValues.monotonicBuilder(0.0f);
        for (int i = 0; i < maxDoc; ++i) {
            oldToNewBuilder.add(docs[i]);
        }
        final PackedLongValues oldToNew = oldToNewBuilder.build();
        return new DocMap(){

            @Override
            public int oldToNew(int docID) {
                return (int)oldToNew.get(docID);
            }

            @Override
            public int newToOld(int docID) {
                return (int)newToOld.get(docID);
            }

            @Override
            public int size() {
                return maxDoc;
            }
        };
    }

    DocMap sort(int maxDoc, IndexSorter.DocComparator[] comparators) throws IOException {
        IndexSorter.DocComparator comparator = (docID1, docID2) -> {
            for (int i = 0; i < comparators.length; ++i) {
                int comp = comparators[i].compare(docID1, docID2);
                if (comp == 0) continue;
                return comp;
            }
            return Integer.compare(docID1, docID2);
        };
        return Sorter.sort(maxDoc, comparator);
    }

    public String getID() {
        return this.sort.toString();
    }

    public String toString() {
        return this.getID();
    }

    private static final class DocValueSorter
    extends TimSorter {
        private final int[] docs;
        private final IndexSorter.DocComparator comparator;
        private final int[] tmp;

        DocValueSorter(int[] docs, IndexSorter.DocComparator comparator) {
            super(docs.length / 64);
            this.docs = docs;
            this.comparator = comparator;
            this.tmp = new int[docs.length / 64];
        }

        @Override
        protected int compare(int i, int j) {
            return this.comparator.compare(this.docs[i], this.docs[j]);
        }

        @Override
        protected void swap(int i, int j) {
            int tmpDoc = this.docs[i];
            this.docs[i] = this.docs[j];
            this.docs[j] = tmpDoc;
        }

        @Override
        protected void copy(int src, int dest) {
            this.docs[dest] = this.docs[src];
        }

        @Override
        protected void save(int i, int len) {
            System.arraycopy(this.docs, i, this.tmp, 0, len);
        }

        @Override
        protected void restore(int i, int j) {
            this.docs[j] = this.tmp[i];
        }

        @Override
        protected int compareSaved(int i, int j) {
            return this.comparator.compare(this.tmp[i], this.docs[j]);
        }
    }

    public static abstract class DocMap {
        protected DocMap() {
        }

        public abstract int oldToNew(int var1);

        public abstract int newToOld(int var1);

        public abstract int size();
    }
}

