/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.codecs.lucene95;

import guideme.internal.shaded.lucene.codecs.lucene90.IndexedDISI;
import guideme.internal.shaded.lucene.index.DocsWithFieldSet;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.store.IndexInput;
import guideme.internal.shaded.lucene.store.IndexOutput;
import guideme.internal.shaded.lucene.util.Accountable;
import guideme.internal.shaded.lucene.util.RamUsageEstimator;
import guideme.internal.shaded.lucene.util.packed.DirectMonotonicReader;
import guideme.internal.shaded.lucene.util.packed.DirectMonotonicWriter;
import java.io.IOException;

public class OrdToDocDISIReaderConfiguration
implements Accountable {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(OrdToDocDISIReaderConfiguration.class);
    final int size;
    final short jumpTableEntryCount;
    final long docsWithFieldOffset;
    final long docsWithFieldLength;
    final byte denseRankPower;
    final long addressesOffset;
    final long addressesLength;
    final DirectMonotonicReader.Meta meta;

    public static void writeStoredMeta(int directMonotonicBlockShift, IndexOutput outputMeta, IndexOutput vectorData, int count, int maxDoc, DocsWithFieldSet docsWithField) throws IOException {
        if (count == 0) {
            outputMeta.writeLong(-2L);
            outputMeta.writeLong(0L);
            outputMeta.writeShort((short)-1);
            outputMeta.writeByte((byte)-1);
        } else if (count == maxDoc) {
            outputMeta.writeLong(-1L);
            outputMeta.writeLong(0L);
            outputMeta.writeShort((short)-1);
            outputMeta.writeByte((byte)-1);
        } else {
            long offset = vectorData.getFilePointer();
            outputMeta.writeLong(offset);
            short jumpTableEntryCount = IndexedDISI.writeBitSet(docsWithField.iterator(), vectorData, (byte)9);
            outputMeta.writeLong(vectorData.getFilePointer() - offset);
            outputMeta.writeShort(jumpTableEntryCount);
            outputMeta.writeByte((byte)9);
            long start = vectorData.getFilePointer();
            outputMeta.writeLong(start);
            outputMeta.writeVInt(directMonotonicBlockShift);
            DirectMonotonicWriter ordToDocWriter = DirectMonotonicWriter.getInstance(outputMeta, vectorData, count, directMonotonicBlockShift);
            DocIdSetIterator iterator = docsWithField.iterator();
            int doc = iterator.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                ordToDocWriter.add(doc);
                doc = iterator.nextDoc();
            }
            ordToDocWriter.finish();
            outputMeta.writeLong(vectorData.getFilePointer() - start);
        }
    }

    public static OrdToDocDISIReaderConfiguration fromStoredMeta(IndexInput inputMeta, int size) throws IOException {
        long docsWithFieldOffset = inputMeta.readLong();
        long docsWithFieldLength = inputMeta.readLong();
        short jumpTableEntryCount = inputMeta.readShort();
        byte denseRankPower = inputMeta.readByte();
        long addressesOffset = 0L;
        int blockShift = 0;
        DirectMonotonicReader.Meta meta = null;
        long addressesLength = 0L;
        if (docsWithFieldOffset > -1L) {
            addressesOffset = inputMeta.readLong();
            blockShift = inputMeta.readVInt();
            meta = DirectMonotonicReader.loadMeta(inputMeta, size, blockShift);
            addressesLength = inputMeta.readLong();
        }
        return new OrdToDocDISIReaderConfiguration(size, jumpTableEntryCount, addressesOffset, addressesLength, docsWithFieldOffset, docsWithFieldLength, denseRankPower, meta);
    }

    OrdToDocDISIReaderConfiguration(int size, short jumpTableEntryCount, long addressesOffset, long addressesLength, long docsWithFieldOffset, long docsWithFieldLength, byte denseRankPower, DirectMonotonicReader.Meta meta) {
        this.size = size;
        this.jumpTableEntryCount = jumpTableEntryCount;
        this.addressesOffset = addressesOffset;
        this.addressesLength = addressesLength;
        this.docsWithFieldOffset = docsWithFieldOffset;
        this.docsWithFieldLength = docsWithFieldLength;
        this.denseRankPower = denseRankPower;
        this.meta = meta;
    }

    @Override
    public long ramBytesUsed() {
        return SHALLOW_SIZE + RamUsageEstimator.sizeOf(this.meta);
    }

    public boolean isEmpty() {
        return this.docsWithFieldOffset == -2L;
    }

    public boolean isDense() {
        return this.docsWithFieldOffset == -1L;
    }
}

