/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.codecs;

import guideme.internal.shaded.lucene.codecs.KnnFieldVectorsWriter;
import guideme.internal.shaded.lucene.codecs.KnnVectorsReader;
import guideme.internal.shaded.lucene.index.ByteVectorValues;
import guideme.internal.shaded.lucene.index.DocIDMerger;
import guideme.internal.shaded.lucene.index.DocsWithFieldSet;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.FieldInfos;
import guideme.internal.shaded.lucene.index.FloatVectorValues;
import guideme.internal.shaded.lucene.index.MergeState;
import guideme.internal.shaded.lucene.index.Sorter;
import guideme.internal.shaded.lucene.index.VectorEncoding;
import guideme.internal.shaded.lucene.internal.hppc.IntIntHashMap;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.util.Accountable;
import guideme.internal.shaded.lucene.util.IOFunction;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;

public abstract class KnnVectorsWriter
implements Accountable,
Closeable {
    protected KnnVectorsWriter() {
    }

    public abstract KnnFieldVectorsWriter<?> addField(FieldInfo var1) throws IOException;

    public abstract void flush(int var1, Sorter.DocMap var2) throws IOException;

    public void mergeOneField(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
        switch (fieldInfo.getVectorEncoding()) {
            case BYTE: {
                KnnFieldVectorsWriter<?> byteWriter = this.addField(fieldInfo);
                ByteVectorValues mergedBytes = MergedVectorValues.mergeByteVectorValues(fieldInfo, mergeState);
                int doc = mergedBytes.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    byteWriter.addValue(doc, mergedBytes.vectorValue());
                    doc = mergedBytes.nextDoc();
                }
                break;
            }
            case FLOAT32: {
                KnnFieldVectorsWriter<?> floatWriter = this.addField(fieldInfo);
                FloatVectorValues mergedFloats = MergedVectorValues.mergeFloatVectorValues(fieldInfo, mergeState);
                int doc = mergedFloats.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    floatWriter.addValue(doc, mergedFloats.vectorValue());
                    doc = mergedFloats.nextDoc();
                }
                break;
            }
        }
    }

    public abstract void finish() throws IOException;

    public final void merge(MergeState mergeState) throws IOException {
        for (int i = 0; i < mergeState.fieldInfos.length; ++i) {
            KnnVectorsReader reader = mergeState.knnVectorsReaders[i];
            assert (reader != null || !mergeState.fieldInfos[i].hasVectorValues());
            if (reader == null) continue;
            reader.checkIntegrity();
        }
        for (FieldInfo fieldInfo : mergeState.mergeFieldInfos) {
            if (!fieldInfo.hasVectorValues()) continue;
            if (mergeState.infoStream.isEnabled("VV")) {
                mergeState.infoStream.message("VV", "merging " + mergeState.segmentInfo);
            }
            this.mergeOneField(fieldInfo, mergeState);
            if (!mergeState.infoStream.isEnabled("VV")) continue;
            mergeState.infoStream.message("VV", "merge done " + mergeState.segmentInfo);
        }
        this.finish();
    }

    public static void mapOldOrdToNewOrd(DocsWithFieldSet oldDocIds, Sorter.DocMap sortMap, int[] old2NewOrd, int[] new2OldOrd, DocsWithFieldSet newDocsWithField) throws IOException {
        Objects.requireNonNull(oldDocIds);
        Objects.requireNonNull(sortMap);
        assert (old2NewOrd != null || new2OldOrd != null || newDocsWithField != null);
        assert (old2NewOrd == null || old2NewOrd.length == oldDocIds.cardinality());
        assert (new2OldOrd == null || new2OldOrd.length == oldDocIds.cardinality());
        IntIntHashMap newIdToOldOrd = new IntIntHashMap();
        DocIdSetIterator iterator = oldDocIds.iterator();
        int[] newDocIds = new int[oldDocIds.cardinality()];
        int oldOrd = 0;
        int oldDocId = iterator.nextDoc();
        while (oldDocId != Integer.MAX_VALUE) {
            int newId = sortMap.oldToNew(oldDocId);
            newIdToOldOrd.put(newId, oldOrd);
            newDocIds[oldOrd] = newId;
            ++oldOrd;
            oldDocId = iterator.nextDoc();
        }
        Arrays.sort(newDocIds);
        int newOrd = 0;
        for (int newDocId : newDocIds) {
            int currOldOrd = newIdToOldOrd.get(newDocId);
            if (old2NewOrd != null) {
                old2NewOrd[currOldOrd] = newOrd;
            }
            if (new2OldOrd != null) {
                new2OldOrd[newOrd] = currOldOrd;
            }
            if (newDocsWithField != null) {
                newDocsWithField.add(newDocId);
            }
            ++newOrd;
        }
    }

    public static final class MergedVectorValues {
        private static void validateFieldEncoding(FieldInfo fieldInfo, VectorEncoding expected) {
            assert (fieldInfo != null && fieldInfo.hasVectorValues());
            VectorEncoding fieldEncoding = fieldInfo.getVectorEncoding();
            if (fieldEncoding != expected) {
                throw new UnsupportedOperationException("Cannot merge vectors encoded as [" + fieldEncoding + "] as " + expected);
            }
        }

        public static boolean hasVectorValues(FieldInfos fieldInfos, String fieldName) {
            if (!fieldInfos.hasVectorValues()) {
                return false;
            }
            FieldInfo info = fieldInfos.fieldInfo(fieldName);
            return info != null && info.hasVectorValues();
        }

        private static <V, S> List<S> mergeVectorValues(KnnVectorsReader[] knnVectorsReaders, MergeState.DocMap[] docMaps, FieldInfo mergingField, FieldInfos[] sourceFieldInfos, IOFunction<KnnVectorsReader, V> valuesSupplier, BiFunction<MergeState.DocMap, V, S> newSub) throws IOException {
            ArrayList<S> subs = new ArrayList<S>();
            for (int i = 0; i < knnVectorsReaders.length; ++i) {
                V values;
                KnnVectorsReader knnVectorsReader;
                FieldInfos sourceFieldInfo = sourceFieldInfos[i];
                if (!MergedVectorValues.hasVectorValues(sourceFieldInfo, mergingField.name) || (knnVectorsReader = knnVectorsReaders[i]) == null || (values = valuesSupplier.apply(knnVectorsReader)) == null) continue;
                subs.add(newSub.apply(docMaps[i], values));
            }
            return subs;
        }

        public static FloatVectorValues mergeFloatVectorValues(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
            MergedVectorValues.validateFieldEncoding(fieldInfo, VectorEncoding.FLOAT32);
            return new MergedFloat32VectorValues(MergedVectorValues.mergeVectorValues(mergeState.knnVectorsReaders, mergeState.docMaps, fieldInfo, mergeState.fieldInfos, knnVectorsReader -> knnVectorsReader.getFloatVectorValues(fieldInfo.name), FloatVectorValuesSub::new), mergeState);
        }

        public static ByteVectorValues mergeByteVectorValues(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
            MergedVectorValues.validateFieldEncoding(fieldInfo, VectorEncoding.BYTE);
            return new MergedByteVectorValues(MergedVectorValues.mergeVectorValues(mergeState.knnVectorsReaders, mergeState.docMaps, fieldInfo, mergeState.fieldInfos, knnVectorsReader -> knnVectorsReader.getByteVectorValues(fieldInfo.name), ByteVectorValuesSub::new), mergeState);
        }

        static class MergedByteVectorValues
        extends ByteVectorValues {
            private final List<ByteVectorValuesSub> subs;
            private final DocIDMerger<ByteVectorValuesSub> docIdMerger;
            private final int size;
            private int docId;
            ByteVectorValuesSub current;

            private MergedByteVectorValues(List<ByteVectorValuesSub> subs, MergeState mergeState) throws IOException {
                this.subs = subs;
                this.docIdMerger = DocIDMerger.of(subs, mergeState.needsIndexSort);
                int totalSize = 0;
                for (ByteVectorValuesSub sub : subs) {
                    totalSize += sub.values.size();
                }
                this.size = totalSize;
                this.docId = -1;
            }

            @Override
            public byte[] vectorValue() throws IOException {
                return this.current.values.vectorValue();
            }

            @Override
            public int docID() {
                return this.docId;
            }

            @Override
            public int nextDoc() throws IOException {
                this.current = this.docIdMerger.next();
                this.docId = this.current == null ? Integer.MAX_VALUE : this.current.mappedDocID;
                return this.docId;
            }

            @Override
            public int advance(int target) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                return this.size;
            }

            @Override
            public int dimension() {
                return this.subs.get((int)0).values.dimension();
            }
        }

        static class MergedFloat32VectorValues
        extends FloatVectorValues {
            private final List<FloatVectorValuesSub> subs;
            private final DocIDMerger<FloatVectorValuesSub> docIdMerger;
            private final int size;
            private int docId;
            FloatVectorValuesSub current;

            private MergedFloat32VectorValues(List<FloatVectorValuesSub> subs, MergeState mergeState) throws IOException {
                this.subs = subs;
                this.docIdMerger = DocIDMerger.of(subs, mergeState.needsIndexSort);
                int totalSize = 0;
                for (FloatVectorValuesSub sub : subs) {
                    totalSize += sub.values.size();
                }
                this.size = totalSize;
                this.docId = -1;
            }

            @Override
            public int docID() {
                return this.docId;
            }

            @Override
            public int nextDoc() throws IOException {
                this.current = this.docIdMerger.next();
                this.docId = this.current == null ? Integer.MAX_VALUE : this.current.mappedDocID;
                return this.docId;
            }

            @Override
            public float[] vectorValue() throws IOException {
                return this.current.values.vectorValue();
            }

            @Override
            public int advance(int target) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                return this.size;
            }

            @Override
            public int dimension() {
                return this.subs.get((int)0).values.dimension();
            }
        }
    }

    private static class ByteVectorValuesSub
    extends DocIDMerger.Sub {
        final ByteVectorValues values;

        ByteVectorValuesSub(MergeState.DocMap docMap, ByteVectorValues values) {
            super(docMap);
            this.values = values;
            assert (values.docID() == -1);
        }

        @Override
        public int nextDoc() throws IOException {
            return this.values.nextDoc();
        }
    }

    private static class FloatVectorValuesSub
    extends DocIDMerger.Sub {
        final FloatVectorValues values;

        FloatVectorValuesSub(MergeState.DocMap docMap, FloatVectorValues values) {
            super(docMap);
            this.values = values;
            assert (values.docID() == -1);
        }

        @Override
        public int nextDoc() throws IOException {
            return this.values.nextDoc();
        }
    }
}

