/*
 * Decompiled with CFR 0.152.
 */
package guideme.scene.export;

import com.mojang.blaze3d.vertex.BufferBuilder;
import guideme.scene.export.Mesh;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;

class MeshBuildingBufferSource
extends MultiBufferSource.BufferSource {
    private final List<Mesh> meshes = new ArrayList<Mesh>();

    public MeshBuildingBufferSource() {
        super(new BufferBuilder(256), Map.of());
    }

    public List<Mesh> getMeshes() {
        return this.meshes;
    }

    public void endBatch(RenderType renderType) {
        BufferBuilder bufferBuilder = this.fixedBuffers.getOrDefault(renderType, this.builder);
        boolean bl = Objects.equals(this.lastState, renderType.asOptional());
        if (!bl && bufferBuilder == this.builder) {
            return;
        }
        if (!this.startedBuffers.remove(bufferBuilder)) {
            return;
        }
        BufferBuilder.RenderedBuffer buffer = bufferBuilder.endOrDiscardIfEmpty();
        if (buffer != null) {
            BufferBuilder.DrawState drawState = buffer.drawState();
            ByteBuffer vbSource = buffer.vertexBuffer();
            ByteBuffer vertexBuffer = ByteBuffer.allocate(vbSource.remaining()).order(ByteOrder.nativeOrder());
            vertexBuffer.put(vbSource);
            vertexBuffer.flip();
            ByteBuffer ibSource = buffer.indexBuffer();
            ByteBuffer indexBuffer = ByteBuffer.allocate(ibSource.remaining());
            indexBuffer.put(ibSource);
            indexBuffer.flip();
            this.meshes.add(new Mesh(drawState, vertexBuffer, indexBuffer, renderType));
            buffer.release();
        }
        if (bl) {
            this.lastState = Optional.empty();
        }
    }
}

