/*
 * Decompiled with CFR 0.152.
 */
package guideme.scene;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexSorting;
import guideme.color.LightDarkMode;
import guideme.scene.CameraSettings;
import guideme.scene.GuidebookLightmap;
import guideme.scene.LiquidVertexConsumer;
import guideme.scene.SodiumCompat;
import guideme.scene.annotation.InWorldAnnotation;
import guideme.scene.annotation.InWorldAnnotationRenderer;
import guideme.scene.level.GuidebookLevel;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class GuidebookLevelRenderer {
    private static GuidebookLevelRenderer instance;
    private final GuidebookLightmap lightmap = new GuidebookLightmap();

    public static GuidebookLevelRenderer getInstance() {
        RenderSystem.assertOnRenderThread();
        if (instance == null) {
            instance = new GuidebookLevelRenderer();
        }
        return instance;
    }

    public void render(GuidebookLevel level, CameraSettings cameraSettings, Collection<InWorldAnnotation> annotations, LightDarkMode lightDarkMode) {
        this.lightmap.update(level);
        RenderSystem.clear((int)256, (boolean)Minecraft.ON_OSX);
        level.onRenderFrame();
        RenderSystem.setShaderGameTime((long)level.getGameTime(), (float)level.getPartialTick());
        MultiBufferSource.BufferSource buffers = Minecraft.getInstance().renderBuffers().bufferSource();
        this.render(level, cameraSettings, buffers, annotations, lightDarkMode);
        buffers.endBatch();
    }

    public void render(GuidebookLevel level, CameraSettings cameraSettings, MultiBufferSource.BufferSource buffers, Collection<InWorldAnnotation> annotations, LightDarkMode lightDarkMode) {
        this.lightmap.update(level);
        LevelLightEngine lightEngine = level.getLightEngine();
        while (lightEngine.hasLightWork()) {
            lightEngine.runLightUpdates();
        }
        Matrix4f projectionMatrix = cameraSettings.getProjectionMatrix();
        Matrix4f viewMatrix = cameraSettings.getViewMatrix();
        RenderSystem.setShaderFogColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f);
        RenderSystem.setShaderFogStart((float)0.0f);
        RenderSystem.setShaderFogEnd((float)1000.0f);
        RenderSystem.setShaderFogShape((FogShape)FogShape.SPHERE);
        PoseStack modelViewStack = RenderSystem.getModelViewStack();
        modelViewStack.pushPose();
        modelViewStack.setIdentity();
        modelViewStack.mulPoseMatrix(viewMatrix);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)projectionMatrix, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
        Vector4f lightDirection = new Vector4f(0.16666667f, 0.35f, 1.0f, 0.0f);
        Matrix4f lightTransform = new Matrix4f((Matrix4fc)viewMatrix);
        lightTransform.invert();
        lightTransform.transform(lightDirection);
        Lighting.setupLevel((Matrix4f)modelViewStack.last().pose());
        this.renderContent(level, buffers);
        InWorldAnnotationRenderer.render(buffers, annotations, lightDarkMode);
        modelViewStack.popPose();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.restoreProjectionMatrix();
        Lighting.setupFor3DItems();
    }

    public void renderContent(GuidebookLevel level, MultiBufferSource.BufferSource buffers) {
        RenderSystem.runAsFancy(() -> {
            this.renderBlocks(level, (MultiBufferSource)buffers, false);
            this.renderBlockEntities(level, (MultiBufferSource)buffers, level.getPartialTick());
            this.renderEntities(level, buffers, level.getPartialTick());
            buffers.endBatch(RenderType.entitySolid((ResourceLocation)TextureAtlas.LOCATION_BLOCKS));
            buffers.endBatch(RenderType.entityCutout((ResourceLocation)TextureAtlas.LOCATION_BLOCKS));
            buffers.endBatch(RenderType.entityCutoutNoCull((ResourceLocation)TextureAtlas.LOCATION_BLOCKS));
            buffers.endBatch(RenderType.entitySmoothCutout((ResourceLocation)TextureAtlas.LOCATION_BLOCKS));
            for (RenderType layer : RenderType.chunkBufferLayers()) {
                if (layer == RenderType.translucent()) continue;
                buffers.endBatch(layer);
            }
            buffers.endBatch(RenderType.solid());
            buffers.endBatch(RenderType.endPortal());
            buffers.endBatch(RenderType.endGateway());
            buffers.endBatch(Sheets.solidBlockSheet());
            buffers.endBatch(Sheets.cutoutBlockSheet());
            buffers.endBatch(Sheets.bedSheet());
            buffers.endBatch(Sheets.shulkerBoxSheet());
            buffers.endBatch(Sheets.signSheet());
            buffers.endBatch(Sheets.hangingSignSheet());
            buffers.endBatch(Sheets.chestSheet());
            buffers.endLastBatch();
            this.renderBlocks(level, (MultiBufferSource)buffers, true);
            buffers.endBatch(RenderType.translucent());
        });
    }

    private void renderBlocks(GuidebookLevel level, MultiBufferSource buffers, boolean translucent) {
        BlockRenderDispatcher blockRenderDispatcher = Minecraft.getInstance().getBlockRenderer();
        PoseStack poseStack = new PoseStack();
        SingleThreadedRandomSource randomSource = new SingleThreadedRandomSource(0L);
        Iterator it = level.getFilledBlocks().iterator();
        while (it.hasNext()) {
            RenderType renderType;
            BlockPos pos = (BlockPos)it.next();
            BlockState blockState = level.getBlockState(pos);
            FluidState fluidState = blockState.getFluidState();
            if (!fluidState.isEmpty() && ((renderType = ItemBlockRenderTypes.getRenderLayer((FluidState)fluidState)) != RenderType.translucent() || translucent)) {
                VertexConsumer bufferBuilder = buffers.getBuffer(renderType);
                SectionPos sectionPos = SectionPos.of((BlockPos)pos);
                LiquidVertexConsumer liquidVertexConsumer = new LiquidVertexConsumer(bufferBuilder, sectionPos);
                blockRenderDispatcher.renderLiquid(pos, (BlockAndTintGetter)level, (VertexConsumer)liquidVertexConsumer, blockState, fluidState);
                GuidebookLevelRenderer.markFluidSpritesActive(fluidState);
            }
            if (blockState.getRenderShape() == RenderShape.INVISIBLE) continue;
            BlockEntity be = level.getBlockEntity(pos);
            ModelData modelData = ModelData.EMPTY;
            if (be != null) {
                modelData = be.getModelData();
            }
            BakedModel model = blockRenderDispatcher.getBlockModel(blockState);
            modelData = model.getModelData((BlockAndTintGetter)level, pos, blockState, modelData);
            ChunkRenderTypeSet renderTypes = model.getRenderTypes(blockState, (RandomSource)randomSource, modelData);
            for (RenderType renderType2 : renderTypes) {
                if (renderType2 == RenderType.translucent() && !translucent) continue;
                randomSource.setSeed(blockState.getSeed(pos));
                VertexConsumer bufferBuilder = buffers.getBuffer(renderType2);
                poseStack.pushPose();
                poseStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
                blockRenderDispatcher.renderBatched(blockState, pos, (BlockAndTintGetter)level, poseStack, bufferBuilder, true, (RandomSource)randomSource, modelData, renderType2);
                poseStack.popPose();
            }
        }
    }

    private void renderBlockEntities(GuidebookLevel level, MultiBufferSource buffers, float partialTick) {
        PoseStack poseStack = new PoseStack();
        level.getFilledBlocks().forEach(pos -> {
            BlockEntity blockEntity;
            BlockState blockState = level.getBlockState((BlockPos)pos);
            if (blockState.hasBlockEntity() && (blockEntity = level.getBlockEntity((BlockPos)pos)) != null) {
                this.handleBlockEntity(poseStack, blockEntity, buffers, partialTick);
            }
        });
    }

    private static void markFluidSpritesActive(FluidState fluidState) {
        IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((FluidState)fluidState);
        TextureAtlasSprite sprite1 = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(props.getStillTexture());
        SodiumCompat.markSpriteActive(sprite1);
        TextureAtlasSprite sprite2 = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(props.getFlowingTexture());
        SodiumCompat.markSpriteActive(sprite2);
    }

    private <E extends BlockEntity> void handleBlockEntity(PoseStack stack, E blockEntity, MultiBufferSource buffers, float partialTicks) {
        BlockEntityRenderDispatcher dispatcher = Minecraft.getInstance().getBlockEntityRenderDispatcher();
        BlockEntityRenderer renderer = dispatcher.getRenderer(blockEntity);
        if (renderer != null && renderer.shouldRender(blockEntity, blockEntity.getBlockPos().getCenter())) {
            BlockPos pos = blockEntity.getBlockPos();
            stack.pushPose();
            stack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            int packedLight = LevelRenderer.getLightColor((BlockAndTintGetter)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos());
            renderer.render(blockEntity, partialTicks, stack, buffers, packedLight, OverlayTexture.NO_OVERLAY);
            stack.popPose();
        }
    }

    private void renderEntities(GuidebookLevel level, MultiBufferSource.BufferSource buffers, float partialTick) {
        PoseStack poseStack = new PoseStack();
        for (Entity entity : level.getEntitiesForRendering()) {
            this.handleEntity(level, poseStack, entity, (MultiBufferSource)buffers, partialTick);
        }
    }

    private <E extends Entity> void handleEntity(GuidebookLevel level, PoseStack poseStack, E entity, MultiBufferSource buffers, float partialTicks) {
        EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        EntityRenderer renderer = dispatcher.getRenderer(entity);
        if (renderer == null) {
            return;
        }
        BlockPos probePos = BlockPos.containing((Position)entity.getLightProbePosition(partialTicks));
        int packedLight = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)probePos);
        float yaw = entity.getYRot();
        Vec3 pos = entity.position();
        Vec3 offset = renderer.getRenderOffset(entity, partialTicks);
        poseStack.pushPose();
        poseStack.translate(pos.x + offset.x(), pos.y + offset.y(), pos.z + offset.z());
        renderer.render(entity, yaw, partialTicks, poseStack, buffers, packedLight);
        poseStack.popPose();
    }
}

