/*
 * Decompiled with CFR 0.152.
 */
package guideme.document.block.recipes;

import guideme.document.DefaultStyles;
import guideme.document.LytSize;
import guideme.document.block.AlignItems;
import guideme.document.block.LytBlock;
import guideme.document.block.LytGuiSprite;
import guideme.document.block.LytHBox;
import guideme.document.block.LytParagraph;
import guideme.document.block.LytSlotGrid;
import guideme.document.block.LytVBox;
import guideme.internal.util.Platform;
import guideme.render.GuiAssets;
import guideme.render.RenderContext;
import guideme.scene.LytItemImage;
import guideme.siteexport.ExportableResourceProvider;
import guideme.siteexport.ResourceExporter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class LytStandardRecipeBox<T extends Recipe<?>>
extends LytVBox
implements ExportableResourceProvider {
    private final T holder;

    @ApiStatus.Internal
    LytStandardRecipeBox(T holder) {
        this.holder = holder;
    }

    public T getRecipe() {
        return this.holder;
    }

    @Override
    public void render(RenderContext context) {
        context.renderPanel(this.getBounds());
        super.render(context);
    }

    @Override
    public void exportResources(ResourceExporter exporter) {
        exporter.referenceRecipe((Recipe<?>)this.holder);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private LytBlock icon;
        private final LytParagraph title = new LytParagraph();
        private final List<LytBlock> topDecoration = new ArrayList<LytBlock>();
        private final List<LytBlock> bottomDecoration = new ArrayList<LytBlock>();
        private final List<LytBlock> leftDecoration = new ArrayList<LytBlock>();
        private final List<LytBlock> rightDecoration = new ArrayList<LytBlock>();
        @Nullable
        private LytSlotGrid input;
        @Nullable
        private LytSlotGrid output;
        @Nullable
        private LytBlock customBody;

        private Builder() {
            this.title.setStyle(DefaultStyles.CRAFTING_RECIPE_TYPE);
        }

        public <T extends Recipe<?>> LytStandardRecipeBox<T> build(T recipe) {
            LytStandardRecipeBox<T> box = new LytStandardRecipeBox<T>(recipe);
            this.build(box);
            return box;
        }

        public Builder icon(LytBlock block) {
            this.icon = block;
            return this;
        }

        public Builder icon(ItemLike workbench) {
            return this.icon(workbench.asItem().getDefaultInstance());
        }

        public Builder icon(ItemStack workbench) {
            LytItemImage itemImage = new LytItemImage();
            itemImage.setScale(0.5f);
            itemImage.setItem(workbench);
            this.icon = itemImage;
            return this;
        }

        public Builder title(String title) {
            this.title.appendText(title);
            return this;
        }

        public Builder input(Ingredient ingredient) {
            this.input = LytSlotGrid.row(List.of(ingredient), false);
            return this;
        }

        public Builder input(LytSlotGrid grid) {
            this.input = grid;
            return this;
        }

        public Builder output(LytSlotGrid grid) {
            this.output = grid;
            return this;
        }

        public Builder output(ItemStack resultItem) {
            this.output = new LytSlotGrid(1, 1);
            this.output.setItem(0, 0, resultItem);
            return this;
        }

        public Builder outputFromResultOf(Recipe<?> recipe) {
            ItemStack resultItem = recipe.getResultItem(Platform.getClientRegistryAccess());
            if (!resultItem.isEmpty()) {
                this.output(resultItem);
            }
            return this;
        }

        public Builder addTop(LytBlock block) {
            this.topDecoration.add(block);
            return this;
        }

        public Builder addLeft(LytBlock block) {
            this.leftDecoration.add(block);
            return this;
        }

        public Builder addBottom(LytBlock block) {
            this.bottomDecoration.add(block);
            return this;
        }

        public Builder addRight(LytBlock block) {
            this.rightDecoration.add(block);
            return this;
        }

        public Builder customBody(@Nullable LytBlock customBody) {
            this.customBody = customBody;
            return this;
        }

        @ApiStatus.Internal
        <T extends Recipe<?>> void build(LytStandardRecipeBox<T> box) {
            if (this.customBody != null) {
                if (!this.leftDecoration.isEmpty()) {
                    throw new IllegalStateException("Cannot combine a custom recipe body with left decorations");
                }
                if (!this.rightDecoration.isEmpty()) {
                    throw new IllegalStateException("Cannot combine a custom recipe body with right decorations");
                }
                if (this.input != null) {
                    throw new IllegalStateException("Cannot set recipe inputs when a custom body is used.");
                }
                if (this.output != null) {
                    throw new IllegalStateException("Cannot set recipe outputs when a custom body is used.");
                }
            }
            box.setGap(2);
            box.setPadding(5);
            LytHBox titleRow = new LytHBox();
            titleRow.setAlignItems(AlignItems.CENTER);
            titleRow.setWrap(false);
            if (this.icon != null) {
                titleRow.append(this.icon);
            }
            if (!this.title.isEmpty()) {
                titleRow.append(this.title);
            }
            titleRow.setGap(2);
            box.append(titleRow);
            for (LytBlock lytBlock : this.topDecoration) {
                box.append(lytBlock);
            }
            if (this.customBody != null) {
                box.append(this.customBody);
            } else if (this.input != null || this.output != null || !this.leftDecoration.isEmpty() || !this.rightDecoration.isEmpty()) {
                LytHBox gridRow = new LytHBox();
                gridRow.setGap(2);
                gridRow.setAlignItems(AlignItems.CENTER);
                gridRow.setWrap(false);
                for (LytBlock block : this.leftDecoration) {
                    gridRow.append(block);
                }
                if (this.input != null) {
                    gridRow.append(this.input);
                }
                if (this.input != null || this.output != null) {
                    gridRow.append(new LytGuiSprite(GuiAssets.ARROW, new LytSize(24, 17)));
                }
                if (this.output != null) {
                    gridRow.append(this.output);
                }
                for (LytBlock block : this.rightDecoration) {
                    gridRow.append(block);
                }
                box.append(gridRow);
            }
            for (LytBlock lytBlock : this.bottomDecoration) {
                box.append(lytBlock);
            }
        }
    }
}

