/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark;

import guideme.libs.micromark.Construct;
import guideme.libs.micromark.InitialConstruct;
import guideme.libs.micromark.Point;
import guideme.libs.micromark.State;
import guideme.libs.micromark.Token;
import guideme.libs.micromark.TokenizeContext;
import guideme.libs.micromark.Tokenizer;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class InitializeText {
    public static final Construct.Resolver resolver = InitializeText.createResolver(null);
    public static final InitialConstruct string = InitializeText.initializeFactory("string");
    public static final InitialConstruct text = InitializeText.initializeFactory("text");

    private static InitialConstruct initializeFactory(String field) {
        InitialConstruct construct = new InitialConstruct();
        construct.tokenize = (context, effects, ok, nok) -> {
            Map<Integer, List<Construct>> constructs = switch (field) {
                case "text" -> context.getParser().constructs.text;
                case "string" -> context.getParser().constructs.string;
                default -> throw new IllegalArgumentException(field);
            };
            return new TextTokenizer(context, constructs, effects)::start;
        };
        if ("text".equals(field)) {
            construct.resolveAll = InitializeText::resolveAllLineSuffixes;
        }
        return construct;
    }

    static Construct.Resolver createResolver(Construct.Resolver extraResolver) {
        return (events, context) -> {
            int index = -1;
            int enter = -1;
            while (++index <= events.size()) {
                Tokenizer.Event event;
                Tokenizer.Event event2 = event = index < events.size() ? events.get(index) : null;
                if (enter == -1) {
                    if (event == null || !event.token().type.equals("data")) continue;
                    enter = index++;
                    continue;
                }
                if (event != null && event.token().type.equals("data")) continue;
                if (index != enter + 2) {
                    events.get((int)enter).token().end = events.get((int)(index - 1)).token().end;
                    events.subList(enter + 2, index).clear();
                    index = enter + 2;
                }
                enter = -1;
            }
            return extraResolver != null ? extraResolver.resolve(events, context) : events;
        };
    }

    static List<Tokenizer.Event> resolveAllLineSuffixes(List<Tokenizer.Event> events, TokenizeContext context) {
        int eventIndex = 0;
        while (++eventIndex <= events.size()) {
            if (eventIndex != events.size() && !events.get((int)eventIndex).token().type.equals("lineEnding") || !events.get((int)(eventIndex - 1)).token().type.equals("data")) continue;
            Token data = events.get(eventIndex - 1).token();
            List<Object> chunks = context.sliceStream(data);
            int index = chunks.size();
            int bufferIndex = -1;
            int size = 0;
            boolean tabs = false;
            while (index-- != 0) {
                Object chunk = chunks.get(index);
                if (chunk instanceof String) {
                    String textChunk = (String)chunk;
                    for (bufferIndex = textChunk.length(); bufferIndex > 0 && textChunk.charAt(bufferIndex - 1) == ' '; --bufferIndex) {
                        ++size;
                    }
                    if (bufferIndex != 0) break;
                    bufferIndex = -1;
                    continue;
                }
                if (Objects.equals(chunk, -2)) {
                    tabs = true;
                    ++size;
                    continue;
                }
                if (Objects.equals(chunk, -1)) continue;
                ++index;
                break;
            }
            if (size != 0) {
                Token token = new Token();
                token.type = eventIndex == events.size() || tabs || size < 2 ? "lineSuffix" : "hardBreakTrailing";
                token.start = new Point(data.end.line(), data.end.column() - size, data.end.offset() - size, data.start._index() + index, index != 0 ? bufferIndex : data.start._bufferIndex() + bufferIndex);
                token.end = data.end;
                data.end = token.start;
                if (data.start.offset() == data.end.offset()) {
                    token.copyTo(data);
                } else {
                    events.add(eventIndex++, new Tokenizer.Event(Tokenizer.EventType.ENTER, token, context));
                    events.add(eventIndex++, new Tokenizer.Event(Tokenizer.EventType.EXIT, token, context));
                }
            }
            ++eventIndex;
        }
        return events;
    }

    static class TextTokenizer {
        private final TokenizeContext context;
        private final Map<Integer, List<Construct>> constructs;
        private final Tokenizer.Effects effects;
        private final State text;

        public TextTokenizer(TokenizeContext context, Map<Integer, List<Construct>> constructs, Tokenizer.Effects effects) {
            this.context = context;
            this.constructs = constructs;
            this.effects = effects;
            this.text = effects.attempt.hook(constructs, this::start, this::notText);
        }

        private State start(int code) {
            return this.atBreak(code) ? this.text.step(code) : this.notText(code);
        }

        private State notText(int code) {
            if (code == Integer.MIN_VALUE) {
                this.effects.consume(code);
                return null;
            }
            this.effects.enter("data");
            this.effects.consume(code);
            return this::data;
        }

        private State data(int code) {
            if (this.atBreak(code)) {
                this.effects.exit("data");
                return this.text.step(code);
            }
            this.effects.consume(code);
            return this::data;
        }

        boolean atBreak(int code) {
            if (code == Integer.MIN_VALUE) {
                return true;
            }
            List<Construct> list = this.constructs.get(code);
            int index = -1;
            if (list != null) {
                while (++index < list.size()) {
                    Construct item = list.get(index);
                    if (item.previous != null && !item.previous.previous(this.context, this.context.getPrevious())) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

