/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.util.automaton;

public class RegExp {
    public final Kind kind;
    public final RegExp exp1;
    public final RegExp exp2;
    public final String s;
    public final int c;
    public final int min;
    public final int max;
    public final int digits;
    public final int from;
    public final int to;

    public String toString() {
        StringBuilder b = new StringBuilder();
        this.toStringBuilder(b);
        return b.toString();
    }

    void toStringBuilder(StringBuilder b) {
        switch (this.kind) {
            case REGEXP_UNION: {
                b.append("(");
                this.exp1.toStringBuilder(b);
                b.append("|");
                this.exp2.toStringBuilder(b);
                b.append(")");
                break;
            }
            case REGEXP_CONCATENATION: {
                this.exp1.toStringBuilder(b);
                this.exp2.toStringBuilder(b);
                break;
            }
            case REGEXP_INTERSECTION: {
                b.append("(");
                this.exp1.toStringBuilder(b);
                b.append("&");
                this.exp2.toStringBuilder(b);
                b.append(")");
                break;
            }
            case REGEXP_OPTIONAL: {
                b.append("(");
                this.exp1.toStringBuilder(b);
                b.append(")?");
                break;
            }
            case REGEXP_REPEAT: {
                b.append("(");
                this.exp1.toStringBuilder(b);
                b.append(")*");
                break;
            }
            case REGEXP_REPEAT_MIN: {
                b.append("(");
                this.exp1.toStringBuilder(b);
                b.append("){").append(this.min).append(",}");
                break;
            }
            case REGEXP_REPEAT_MINMAX: {
                b.append("(");
                this.exp1.toStringBuilder(b);
                b.append("){").append(this.min).append(",").append(this.max).append("}");
                break;
            }
            case REGEXP_COMPLEMENT: {
                b.append("~(");
                this.exp1.toStringBuilder(b);
                b.append(")");
                break;
            }
            case REGEXP_CHAR: {
                b.append("\\").appendCodePoint(this.c);
                break;
            }
            case REGEXP_CHAR_RANGE: {
                b.append("[\\").appendCodePoint(this.from).append("-\\").appendCodePoint(this.to).append("]");
                break;
            }
            case REGEXP_ANYCHAR: {
                b.append(".");
                break;
            }
            case REGEXP_EMPTY: {
                b.append("#");
                break;
            }
            case REGEXP_STRING: {
                b.append("\"").append(this.s).append("\"");
                break;
            }
            case REGEXP_ANYSTRING: {
                b.append("@");
                break;
            }
            case REGEXP_AUTOMATON: {
                b.append("<").append(this.s).append(">");
                break;
            }
            case REGEXP_INTERVAL: {
                int i;
                String s1 = Integer.toString(this.min);
                String s2 = Integer.toString(this.max);
                b.append("<");
                if (this.digits > 0) {
                    for (i = s1.length(); i < this.digits; ++i) {
                        b.append('0');
                    }
                }
                b.append(s1).append("-");
                if (this.digits > 0) {
                    for (i = s2.length(); i < this.digits; ++i) {
                        b.append('0');
                    }
                }
                b.append(s2).append(">");
                break;
            }
            case REGEXP_PRE_CLASS: {
                b.append("\\").appendCodePoint(this.from);
            }
        }
    }

    public static enum Kind {
        REGEXP_UNION,
        REGEXP_CONCATENATION,
        REGEXP_INTERSECTION,
        REGEXP_OPTIONAL,
        REGEXP_REPEAT,
        REGEXP_REPEAT_MIN,
        REGEXP_REPEAT_MINMAX,
        REGEXP_COMPLEMENT,
        REGEXP_CHAR,
        REGEXP_CHAR_RANGE,
        REGEXP_ANYCHAR,
        REGEXP_EMPTY,
        REGEXP_STRING,
        REGEXP_ANYSTRING,
        REGEXP_AUTOMATON,
        REGEXP_INTERVAL,
        REGEXP_PRE_CLASS;

    }
}

