/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.store;

import guideme.internal.shaded.lucene.store.FlushInfo;
import guideme.internal.shaded.lucene.store.MergeInfo;
import java.util.Objects;

public class IOContext {
    public final Context context;
    public final MergeInfo mergeInfo;
    public final FlushInfo flushInfo;
    public final boolean readOnce;
    public final boolean randomAccess;
    public final boolean load;
    public static final IOContext DEFAULT = new IOContext(Context.DEFAULT);
    public static final IOContext READONCE = new IOContext(true, false, false);
    public static final IOContext READ = new IOContext(false, false, false);
    public static final IOContext LOAD = new IOContext(false, true, true);
    public static final IOContext RANDOM = new IOContext(false, false, true);

    public IOContext() {
        this(false, false, false);
    }

    public IOContext(FlushInfo flushInfo) {
        assert (flushInfo != null);
        this.context = Context.FLUSH;
        this.mergeInfo = null;
        this.readOnce = false;
        this.load = false;
        this.randomAccess = false;
        this.flushInfo = flushInfo;
    }

    public IOContext(Context context) {
        this(context, null);
    }

    private IOContext(boolean readOnce, boolean load, boolean randomAccess) {
        if (readOnce && randomAccess) {
            throw new IllegalArgumentException("cannot be both readOnce and randomAccess");
        }
        if (load && !randomAccess) {
            throw new IllegalArgumentException("cannot be load but not randomAccess");
        }
        this.context = Context.READ;
        this.mergeInfo = null;
        this.readOnce = readOnce;
        this.load = load;
        this.randomAccess = randomAccess;
        this.flushInfo = null;
    }

    public IOContext(MergeInfo mergeInfo) {
        this(Context.MERGE, mergeInfo);
    }

    private IOContext(Context context, MergeInfo mergeInfo) {
        assert (context != Context.MERGE || mergeInfo != null) : "MergeInfo must not be null if context is MERGE";
        assert (context != Context.FLUSH) : "Use IOContext(FlushInfo) to create a FLUSH IOContext";
        this.context = context;
        this.readOnce = false;
        this.load = false;
        this.randomAccess = false;
        this.mergeInfo = mergeInfo;
        this.flushInfo = null;
    }

    public IOContext withRandomAccess() {
        if (this.context == Context.READ || this.context == Context.DEFAULT) {
            return RANDOM;
        }
        return this;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.context, this.flushInfo, this.mergeInfo, this.readOnce, this.load, this.randomAccess});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IOContext other = (IOContext)obj;
        if (this.context != other.context) {
            return false;
        }
        if (!Objects.equals(this.flushInfo, other.flushInfo)) {
            return false;
        }
        if (!Objects.equals(this.mergeInfo, other.mergeInfo)) {
            return false;
        }
        if (this.readOnce != other.readOnce) {
            return false;
        }
        if (this.load != other.load) {
            return false;
        }
        return this.randomAccess == other.randomAccess;
    }

    public String toString() {
        return "IOContext [context=" + this.context + ", mergeInfo=" + this.mergeInfo + ", flushInfo=" + this.flushInfo + ", readOnce=" + this.readOnce + ", load=" + this.load + ", randomAccess=" + this.randomAccess + "]";
    }

    public static enum Context {
        MERGE,
        READ,
        FLUSH,
        DEFAULT;

    }
}

