/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.ImpactsEnum;
import guideme.internal.shaded.lucene.index.PostingsEnum;
import guideme.internal.shaded.lucene.index.SlowImpactsEnum;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.ImpactsDISI;
import guideme.internal.shaded.lucene.search.LeafSimScorer;
import guideme.internal.shaded.lucene.search.MaxScoreCache;
import guideme.internal.shaded.lucene.search.Scorer;
import guideme.internal.shaded.lucene.search.Weight;
import java.io.IOException;

public final class TermScorer
extends Scorer {
    private final PostingsEnum postingsEnum;
    private final DocIdSetIterator iterator;
    private final LeafSimScorer docScorer;
    private final ImpactsDISI impactsDisi;
    private final MaxScoreCache maxScoreCache;

    public TermScorer(Weight weight, PostingsEnum postingsEnum, LeafSimScorer docScorer) {
        super(weight);
        this.postingsEnum = postingsEnum;
        this.iterator = this.postingsEnum;
        SlowImpactsEnum impactsEnum = new SlowImpactsEnum(postingsEnum);
        this.maxScoreCache = new MaxScoreCache(impactsEnum, docScorer.getSimScorer());
        this.impactsDisi = null;
        this.docScorer = docScorer;
    }

    public TermScorer(Weight weight, ImpactsEnum impactsEnum, LeafSimScorer docScorer, boolean topLevelScoringClause) {
        super(weight);
        this.postingsEnum = impactsEnum;
        this.maxScoreCache = new MaxScoreCache(impactsEnum, docScorer.getSimScorer());
        if (topLevelScoringClause) {
            this.impactsDisi = new ImpactsDISI(impactsEnum, this.maxScoreCache);
            this.iterator = this.impactsDisi;
        } else {
            this.impactsDisi = null;
            this.iterator = impactsEnum;
        }
        this.docScorer = docScorer;
    }

    @Override
    public int docID() {
        return this.postingsEnum.docID();
    }

    public final int freq() throws IOException {
        return this.postingsEnum.freq();
    }

    @Override
    public DocIdSetIterator iterator() {
        return this.iterator;
    }

    @Override
    public float score() throws IOException {
        assert (this.docID() != Integer.MAX_VALUE);
        return this.docScorer.score(this.postingsEnum.docID(), this.postingsEnum.freq());
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        return this.maxScoreCache.advanceShallow(target);
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        return this.maxScoreCache.getMaxScore(upTo);
    }

    @Override
    public void setMinCompetitiveScore(float minScore) {
        if (this.impactsDisi != null) {
            this.impactsDisi.setMinCompetitiveScore(minScore);
        }
    }

    public String toString() {
        return "scorer(" + this.weight + ")[" + super.toString() + "]";
    }
}

